/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.annotate;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import com.zipow.annotate.AnnoPoint;
import com.zipow.annotate.AnnoPointF;
import com.zipow.annotate.AnnoToolType;
import com.zipow.annotate.ISAnnotateDraw;
import java.util.List;

public class AutoArrow
extends ISAnnotateDraw {
    private Paint m_paint = new Paint();
    private AnnoPointF startPos = new AnnoPointF(0.0f, 0.0f);
    private AnnoPointF endPos = new AnnoPointF(0.0f, 0.0f);
    private float m_width = 4.0f;
    private AnnoToolType m_annoToolType;

    public AutoArrow(float width, int color, int alpha) {
        this.m_width = width;
        this.m_paint.setAntiAlias(true);
        this.m_paint.setDither(true);
        this.m_paint.setColor(color);
        this.m_paint.setAlpha(alpha);
        this.m_paint.setStyle(Paint.Style.FILL);
        this.m_paint.setStrokeJoin(Paint.Join.MITER);
        this.m_paint.setStrokeWidth(2.0f);
    }

    @Override
    public void draw(Canvas canvas) {
        if (null != canvas) {
            Path path = new Path();
            switch (this.m_annoToolType) {
                case ANNO_TOOL_TYPE_AUTO_DOUBLE_ARROW: {
                    this.drawdoubleArrow(path);
                    break;
                }
                case ANNO_TOOL_TYPE_AUTO_ARROW1: {
                    this.drawArrow1(path);
                    break;
                }
                case ANNO_TOOL_TYPE_AUTO_ARROW2: {
                    this.drawArrow2(path);
                }
            }
            canvas.drawPath(path, this.m_paint);
        }
    }

    public void drawArrow1(Path path) {
        float widthAB = this.m_width;
        float minimalArrowLength = this.m_width * 3.0f;
        float middleFC2e = Math.max(10.5f, this.m_width * 6.0f);
        float widthFC = this.m_width;
        float middleGD2e = Math.max(14.0f, this.m_width * 9.0f);
        float widthGD = Math.max(11.5f, this.m_width * 6.3f);
        AnnoPointF posS = new AnnoPointF(this.startPos.x, this.startPos.y);
        AnnoPointF posE = new AnnoPointF(this.endPos.x, this.endPos.y);
        float arrowLength = this.afpDistance(posS, posE);
        if (arrowLength < minimalArrowLength) {
            posE = this.afpAtpoint(new AnnoPointF(posS.x, posS.y), new AnnoPointF(posE.x, posE.y), minimalArrowLength - arrowLength);
        }
        arrowLength = this.afpDistance(posS, posE);
        AnnoPointF dir = this.afpSub(posE, posS);
        AnnoPointF perpendicular = this.afpNormalize(this.afpPerp(dir));
        AnnoPointF perpendicularAB = this.afpMult(perpendicular, widthAB / 2.0f);
        AnnoPointF posA = this.afpAdd(posS, perpendicularAB);
        AnnoPointF posB = this.afpSub(posS, perpendicularAB);
        AnnoPointF posMiddleFC = this.afpAtpoint(posS, posE, 0.0f - middleFC2e);
        AnnoPointF perpendicularFC = this.afpMult(perpendicular, widthFC / 2.0f);
        AnnoPointF posF = this.afpAdd(posMiddleFC, perpendicularFC);
        AnnoPointF posC = this.afpSub(posMiddleFC, perpendicularFC);
        AnnoPointF posMiddleGD = this.afpAtpoint(posS, posE, 0.0f - middleGD2e);
        AnnoPointF perpendicularGD = this.afpMult(perpendicular, widthGD / 2.0f);
        AnnoPointF posG = this.afpAdd(posMiddleGD, perpendicularGD);
        AnnoPointF posD = this.afpSub(posMiddleGD, perpendicularGD);
        path.moveTo(posA.x, posA.y);
        path.lineTo(posB.x, posB.y);
        path.lineTo(posC.x, posC.y);
        path.lineTo(posD.x, posD.y);
        path.lineTo(posE.x, posE.y);
        path.lineTo(posG.x, posG.y);
        path.lineTo(posF.x, posF.y);
        path.close();
    }

    public void drawArrow2(Path path) {
        float widthAB = this.m_width;
        float minimalArrowLength = this.m_width * 6.0f;
        float scalableArrowLength = this.m_width * 40.0f;
        float middleFC2e = this.m_width * 9.33333f;
        float widthFC = this.m_width * 4.0f;
        float middleGD2e = this.m_width * 10.3333f;
        float widthGD = this.m_width * 9.3333f;
        AnnoPointF posS = new AnnoPointF(this.startPos.x, this.startPos.y);
        AnnoPointF posE = new AnnoPointF(this.endPos.x, this.endPos.y);
        float arrowLength = this.afpDistance(posS, posE);
        if (arrowLength < minimalArrowLength) {
            posE = this.afpAtpoint(posS, posE, minimalArrowLength - arrowLength);
        }
        if ((arrowLength = this.afpDistance(posS, posE)) < scalableArrowLength) {
            float minimalFactor = 0.3f;
            float scaleFactor = (1.0f - minimalFactor) * arrowLength / scalableArrowLength + minimalFactor;
            middleFC2e *= scaleFactor;
            widthFC *= scaleFactor;
            middleGD2e *= scaleFactor;
            widthGD *= scaleFactor;
        }
        AnnoPointF dir = this.afpSub(posE, posS);
        AnnoPointF perpendicular = this.afpNormalize(this.afpPerp(dir));
        AnnoPointF perpendicularAB = this.afpMult(perpendicular, widthAB / 2.0f);
        AnnoPointF posA = this.afpAdd(posS, perpendicularAB);
        AnnoPointF posB = this.afpSub(posS, perpendicularAB);
        AnnoPointF posMiddleFC = this.afpAtpoint(posS, posE, 0.0f - middleFC2e);
        AnnoPointF perpendicularFC = this.afpMult(perpendicular, widthFC / 2.0f);
        AnnoPointF posF = this.afpAdd(posMiddleFC, perpendicularFC);
        AnnoPointF posC = this.afpSub(posMiddleFC, perpendicularFC);
        AnnoPointF posMiddleGD = this.afpAtpoint(posS, posE, 0.0f - middleGD2e);
        AnnoPointF perpendicularGD = this.afpMult(perpendicular, widthGD / 2.0f);
        AnnoPointF posG = this.afpAdd(posMiddleGD, perpendicularGD);
        AnnoPointF posD = this.afpSub(posMiddleGD, perpendicularGD);
        path.lineTo(posA.x, posA.y);
        path.lineTo(posB.x, posB.y);
        path.lineTo(posC.x, posC.y);
        path.lineTo(posD.x, posD.y);
        path.lineTo(posE.x, posE.y);
        path.lineTo(posG.x, posG.y);
        path.lineTo(posF.x, posF.y);
        path.lineTo(posA.x, posA.y);
        path.close();
    }

    public void drawdoubleArrow(Path path) {
        float widthGD;
        float middleFC2e;
        float widthAB = this.m_width;
        float minimalArrowLength = this.m_width * 3.0f;
        float middleAB2s = middleFC2e = Math.max(10.5f, this.m_width * 6.0f);
        float widthFC = this.m_width;
        float middleGD2e = Math.max(14.0f, this.m_width * 9.0f);
        float widthHI = widthGD = Math.max(11.5f, this.m_width * 6.3f);
        AnnoPointF posS = new AnnoPointF(this.startPos.x, this.startPos.y);
        AnnoPointF posE = new AnnoPointF(this.endPos.x, this.endPos.y);
        float arrowLength = this.afpDistance(new AnnoPointF(posS.x, posS.y), new AnnoPointF(posE.x, posE.y));
        if (arrowLength < minimalArrowLength) {
            posE = this.afpAtpoint(new AnnoPointF(posS.x, posS.y), new AnnoPointF(posE.x, posE.y), minimalArrowLength - arrowLength);
        }
        arrowLength = this.afpDistance(posS, posE);
        AnnoPointF dir = this.afpSub(posE, posS);
        AnnoPointF perpendicular = this.afpNormalize(this.afpPerp(dir));
        AnnoPointF posMiddleAB = this.afpAtpoint(posE, posS, 0.0f - middleAB2s);
        AnnoPointF perpendicularAB = this.afpMult(perpendicular, widthAB / 2.0f);
        AnnoPointF posA = this.afpAdd(posMiddleAB, perpendicularAB);
        AnnoPointF posB = this.afpSub(posMiddleAB, perpendicularAB);
        AnnoPointF posMiddleHI = this.afpAtpoint(posE, posS, 0.0f - middleGD2e);
        AnnoPointF perpendicularHI = this.afpMult(perpendicular, widthHI / 2.0f);
        AnnoPointF posH = this.afpAdd(posMiddleHI, perpendicularHI);
        AnnoPointF posI = this.afpSub(posMiddleHI, perpendicularHI);
        AnnoPointF posMiddleFC = this.afpAtpoint(posS, posE, 0.0f - middleFC2e);
        AnnoPointF perpendicularFC = this.afpMult(perpendicular, widthFC / 2.0f);
        AnnoPointF posF = this.afpAdd(posMiddleFC, perpendicularFC);
        AnnoPointF posC = this.afpSub(posMiddleFC, perpendicularFC);
        AnnoPointF posMiddleGD = this.afpAtpoint(posS, posE, 0.0f - middleGD2e);
        AnnoPointF perpendicularGD = this.afpMult(perpendicular, widthGD / 2.0f);
        AnnoPointF posG = this.afpAdd(posMiddleGD, perpendicularGD);
        AnnoPointF posD = this.afpSub(posMiddleGD, perpendicularGD);
        path.moveTo(posS.x, posS.y);
        path.lineTo(posH.x, posH.y);
        path.lineTo(posA.x, posA.y);
        path.lineTo(posF.x, posF.y);
        path.lineTo(posG.x, posG.y);
        path.lineTo(posE.x, posE.y);
        path.lineTo(posD.x, posD.y);
        path.lineTo(posC.x, posC.y);
        path.lineTo(posB.x, posB.y);
        path.lineTo(posI.x, posI.y);
        path.close();
    }

    @Override
    public void touchDown(float x, float y) {
        this.startPos.x = x;
        this.startPos.y = y;
        this.endPos.x = x;
        this.endPos.y = y;
    }

    @Override
    public void touchMove(float x, float y) {
        this.endPos.x = x;
        this.endPos.y = y;
    }

    @Override
    public void touchUp(float x, float y) {
        this.endPos.x = x;
        this.endPos.y = y;
    }

    @Override
    public void setAnnoPoints(List<AnnoPoint> annoPoints) {
        for (int i = 0; i < annoPoints.size(); ++i) {
            AnnoPoint point = annoPoints.get(i);
            if (0 == i) {
                this.touchDown(point.m_x, point.m_y);
                continue;
            }
            this.touchMove(point.m_x, point.m_y);
        }
    }

    float afpDistance(AnnoPointF v1, AnnoPointF v2) {
        return this.afpLength(this.afpSub(v1, v2));
    }

    float afpLength(AnnoPointF v) {
        return (float)Math.sqrt(this.afpLengthSQ(v));
    }

    float afpLengthSQ(AnnoPointF v) {
        return v.x * v.x + v.y * v.y;
    }

    AnnoPointF afpSub(AnnoPointF v1, AnnoPointF v2) {
        return new AnnoPointF(v1.x - v2.x, v1.y - v2.y);
    }

    AnnoPointF afpAtpoint(AnnoPointF v1, AnnoPointF v2, float distanceFromv2) {
        if (distanceFromv2 == 0.0f) {
            return v2;
        }
        float distance_v1v2 = this.afpDistance(v1, v2);
        float x = ((distance_v1v2 + distanceFromv2) * v2.x - distanceFromv2 * v1.x) / distance_v1v2;
        float y = ((distance_v1v2 + distanceFromv2) * v2.y - distanceFromv2 * v1.y) / distance_v1v2;
        return new AnnoPointF(x, y);
    }

    AnnoPointF afpNormalize(AnnoPointF v) {
        return this.afpMult(v, 1.0f / this.afpLength(v));
    }

    AnnoPointF afpMult(AnnoPointF v, float s) {
        return new AnnoPointF(v.x * s, v.y * s);
    }

    AnnoPointF afpPerp(AnnoPointF v) {
        return new AnnoPointF(-v.y, v.x);
    }

    AnnoPointF afpAdd(AnnoPointF v1, AnnoPointF v2) {
        return new AnnoPointF(v1.x + v2.x, v1.y + v2.y);
    }

    @Override
    public void setToolType(AnnoToolType type) {
        this.m_annoToolType = type;
    }
}

