/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.annotate;

import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.zipow.annotate.AnnoToolType;
import com.zipow.annotate.AnnotateTextData;
import com.zipow.annotate.AnnotateView;
import com.zipow.annotate.ZoomAnnotate;
import com.zipow.annotate.ZoomShareData;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ShareUnit;
import com.zipow.videobox.share.ColorSelectedImage;
import com.zipow.videobox.share.ColorTable;
import com.zipow.videobox.share.IColorChangedListener;
import com.zipow.videobox.share.IDrawingViewListener;
import com.zipow.videobox.share.ShareBaseView;
import com.zipow.videobox.share.ZMDrawObject;
import com.zipow.videobox.view.ToolbarButton;
import java.util.Random;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class AnnotateDrawingView
extends ShareBaseView
implements IColorChangedListener,
IDrawingViewListener,
View.OnClickListener,
ZoomShareData.IZoomShareDataListener {
    private View mView;
    private boolean mbEditModle;
    private AnnotateView mDrawingView;
    private ShareUnit mShareUnit;
    private ImageView mCloseBtn;
    private View mToolbars;
    private View mTextToolbars;
    private int mLineWidth = 2;
    private ColorTable mColorTable;
    private TextView txtLineWidth;
    private PopupWindow mColorTableView;
    private PopupWindow mSaveTableView;
    private SeekBar mLineWidthSeekBar;
    private int mShareSourceHeight = 0;
    private int mTop = 0;
    private int mLeft = 0;
    private float mLocalShareHeight = 0.0f;
    private float mLocalShareWidth = 0.0f;
    private float mOffsetX = 0.0f;
    private float mOffsetY = 0.0f;
    private int mEditTextPosX;
    private int mEditTextPosY;
    private int mEditTextLastX = 0;
    private int mEditTextLastY = 0;
    private int mVideoGalleryWidth = 0;
    private int mVideoGalleryHeight = 0;
    private ToolbarButton mSpotlight;
    private ToolbarButton mHighlight;
    private ToolbarButton mPen;
    private ToolbarButton mErase;
    private ToolbarButton mLine;
    private ToolbarButton mArrow;
    private ToolbarButton mRectangle;
    private ToolbarButton mOval;
    private ToolbarButton mText;
    private ToolbarButton mUndo;
    private ToolbarButton mRedo;
    private ToolbarButton mClear;
    private EditText mEditText;
    private Button mRedBtn;
    private Button mGreenBtn;
    private Button mBlueBtn;
    private Button mPurpleBtn;
    private Button mBlackBtn;
    private ImageView mBoldBtn;
    private ImageView mItalicBtn;
    private Button mPlusBtn;
    private Button mMinusBtn;
    private TextView mFontSize;
    private Button mDoneBtn;
    private AnnotateTextData mTextData;
    private View mColorIndicator;
    private ColorSelectedImage mColorImage;
    private boolean mBPresenter;
    private float mScale = 1.0f;
    private int mTextFontSize = 48;
    private static final int COLOR_SIZE_DEFAULT = 25;
    private static final int COLOR_SIZE_PRESSED = 33;
    private static final int DEFAULT_FONT_SIZE = 48;
    private static final String TAG = AnnotateDrawingView.class.getSimpleName();
    private int mScreenWidth = 0;
    private int mScreenHeight = 0;

    public AnnotateDrawingView(Context context) {
        super(context);
        this.init(context);
    }

    public AnnotateDrawingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AnnotateDrawingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        this.mView = LayoutInflater.from((Context)context).inflate(R.layout.zm_share_draw_view, null, false);
        this.mView.getLayoutParams();
        this.initAnnotateView(context);
        this.initTextBox();
        this.addView(this.mView);
    }

    private void initAnnotateView(Context context) {
        this.mDrawingView = (AnnotateView)this.mView.findViewById(R.id.annotateView);
        this.mDrawingView.registerUpdateListener(this);
        this.mDrawingView.setEnabled(true);
        this.mLineWidth = this.mDrawingView.getCurrentWidth();
        this.mCloseBtn = (ImageView)this.mView.findViewById(R.id.shareEditBtn);
        this.mCloseBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                AnnotateDrawingView.this.closeAnnoToolbar();
            }
        });
        this.mSpotlight = (ToolbarButton)this.mView.findViewById(R.id.btnSpotlight);
        this.mHighlight = (ToolbarButton)this.mView.findViewById(R.id.btnHighlight);
        this.mPen = (ToolbarButton)this.mView.findViewById(R.id.btnPen);
        this.mErase = (ToolbarButton)this.mView.findViewById(R.id.btnErase);
        this.mColorIndicator = this.mView.findViewById(R.id.btnColorIndicator);
        this.mColorImage = (ColorSelectedImage)this.mColorIndicator.findViewById(R.id.colorImage);
        this.mLine = (ToolbarButton)this.mView.findViewById(R.id.btnAutoLine);
        this.mArrow = (ToolbarButton)this.mView.findViewById(R.id.btnArrow);
        this.mRectangle = (ToolbarButton)this.mView.findViewById(R.id.btnRectangle);
        this.mOval = (ToolbarButton)this.mView.findViewById(R.id.btnOval);
        this.mText = (ToolbarButton)this.mView.findViewById(R.id.btnText);
        this.mUndo = (ToolbarButton)this.mView.findViewById(R.id.btnUndo);
        this.mRedo = (ToolbarButton)this.mView.findViewById(R.id.btnRedo);
        this.mClear = (ToolbarButton)this.mView.findViewById(R.id.btnClear);
        int isTablet = UIUtil.isTablet((Context)this.mView.getContext()) ? 0 : 8;
        this.mLine.setVisibility(isTablet);
        this.mRectangle.setVisibility(isTablet);
        this.mOval.setVisibility(isTablet);
        this.mText.setVisibility(isTablet);
        this.mUndo.setVisibility(isTablet);
        this.mRedo.setVisibility(isTablet);
        this.mClear.setVisibility(0);
        this.mArrow.setVisibility(8);
        this.mSpotlight.setVisibility(8);
        this.mSpotlight.setOnClickListener(this);
        this.mHighlight.setOnClickListener(this);
        this.mPen.setOnClickListener(this);
        this.mErase.setOnClickListener(this);
        this.mColorIndicator.setOnClickListener((View.OnClickListener)this);
        this.mLine.setOnClickListener(this);
        this.mArrow.setOnClickListener(this);
        this.mRectangle.setOnClickListener(this);
        this.mOval.setOnClickListener(this);
        this.mText.setOnClickListener(this);
        this.mUndo.setOnClickListener(this);
        this.mRedo.setOnClickListener(this);
        this.mClear.setOnClickListener(this);
        this.mToolbars = this.mView.findViewById(R.id.drawingtools);
        this.mToolbars.setVisibility(8);
        int w = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int h = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        this.mToolbars.measure(w, h);
        View contentView = AnnotateDrawingView.inflate((Context)this.getContext(), (int)R.layout.zm_annocolorlayout, null);
        this.mColorTableView = new PopupWindow(contentView, -1, UIUtil.dip2px((Context)context, (float)100.0f));
        this.mColorTable = (ColorTable)contentView.findViewById(R.id.colorTable);
        this.txtLineWidth = (TextView)contentView.findViewById(R.id.txtLineWidth);
        this.mColorTableView.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.zm_transparent));
        this.mColorTableView.setContentView(contentView);
        this.mColorTableView.setFocusable(true);
        this.mColorTableView.setOutsideTouchable(true);
        this.mColorTable.setOnColorChangedListener(this);
        View saveContentView = AnnotateDrawingView.inflate((Context)this.getContext(), (int)R.layout.zm_share_savebtn, null);
        Button saveButton = (Button)saveContentView.findViewById(R.id.savePhotoBtn);
        this.mSaveTableView = new PopupWindow(saveContentView, -1, UIUtil.dip2px((Context)context, (float)100.0f));
        this.mSaveTableView.setBackgroundDrawable(this.getResources().getDrawable(R.drawable.zm_transparent));
        this.mSaveTableView.setContentView(saveContentView);
        this.mSaveTableView.setFocusable(true);
        this.mSaveTableView.setOutsideTouchable(true);
        saveButton.setOnClickListener((View.OnClickListener)this);
        this.mLineWidthSeekBar = (SeekBar)contentView.findViewById(R.id.seekbar);
        this.mLineWidthSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar arg0) {
                AnnotateDrawingView.this.mDrawingView.setToolWidth(AnnotateDrawingView.this.mLineWidth, true);
            }

            public void onStartTrackingTouch(SeekBar arg0) {
            }

            public void onProgressChanged(SeekBar arg0, int value, boolean arg2) {
                AnnotateDrawingView.this.mLineWidth = value > 0 ? value : 1;
                AnnotateDrawingView.this.updateLineWidthPromt();
            }
        });
        ZoomShareData.getInstance().addListener(this);
        this.updateSelection((View)this.mPen);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.mScreenWidth = right - left;
            this.mScreenHeight = bottom - top;
            this.updateAnnotateWndSize();
        }
    }

    @Override
    public void startAnnotation() {
        this.mArrow.setVisibility(this.mBPresenter ? 8 : 0);
        this.mSpotlight.setVisibility(this.mBPresenter ? 0 : 8);
        ZoomAnnotate mgr = ConfMgr.getInstance().getZoomAnnotateMgr();
        if (null != mgr) {
            int composerVsersion = mgr.getCompserVersion();
            boolean isTablet = UIUtil.isTablet((Context)this.mView.getContext());
            if (composerVsersion >= 410 && isTablet) {
                this.mText.setVisibility(0);
            } else {
                this.mText.setVisibility(8);
            }
        }
        this.updateAnnotateWndSize();
        this.mDrawingView.startAnnotation(false);
        int max = Math.max(UIUtil.getDisplayWidth((Context)this.getContext()), UIUtil.getDisplayHeight((Context)this.getContext()));
        this.mDrawingView.initBackgroundCanvasSize(max, max);
    }

    @Override
    public void stopAnnotation() {
        this.mDrawingView.stopAnnotation();
        this.mLeft = 0;
        this.mTop = 0;
        this.mOffsetX = 0.0f;
        this.mOffsetY = 0.0f;
        this.mLocalShareHeight = 0.0f;
        this.mLocalShareWidth = 0.0f;
        this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_PEN);
        this.updateSelection((View)this.mPen);
    }

    @Override
    public void stop() {
        if (null != this.mColorTableView && this.mColorTableView.isShowing()) {
            this.mColorTableView.dismiss();
        }
        if (null != this.mSaveTableView && this.mSaveTableView.isShowing()) {
            this.mSaveTableView.dismiss();
        }
    }

    private void updateSelection(View v) {
        if (null == v) {
            return;
        }
        this.mLineWidth = this.mDrawingView.getCurrentWidth();
        this.mSpotlight.setSelected(false);
        this.mHighlight.setSelected(false);
        this.mPen.setSelected(false);
        this.mErase.setSelected(false);
        this.mLine.setSelected(false);
        this.mArrow.setSelected(false);
        this.mRectangle.setSelected(false);
        this.mOval.setSelected(false);
        this.mText.setSelected(false);
        v.setSelected(true);
        this.mColorImage.setColor(this.mDrawingView.getCurrentColor());
    }

    private void updateTextColor(Button v, int color) {
        if (null == v) {
            return;
        }
        this.mEditText.setTextColor(color);
        this.setTextColorBtnLayoutParams(this.mRedBtn, 25, R.drawable.zm_anno_red);
        this.setTextColorBtnLayoutParams(this.mGreenBtn, 25, R.drawable.zm_anno_green);
        this.setTextColorBtnLayoutParams(this.mBlueBtn, 25, R.drawable.zm_anno_blue);
        this.setTextColorBtnLayoutParams(this.mPurpleBtn, 25, R.drawable.zm_anno_purple);
        this.setTextColorBtnLayoutParams(this.mBlackBtn, 25, R.drawable.zm_anno_black);
        this.setTextColorBtnLayoutParams(v, 33, 0);
        if (this.mRedBtn == v) {
            v.setBackgroundResource(R.drawable.zm_anno_red_pressed);
        } else if (this.mGreenBtn == v) {
            v.setBackgroundResource(R.drawable.zm_anno_green_pressed);
        } else if (this.mBlueBtn == v) {
            v.setBackgroundResource(R.drawable.zm_anno_blue_pressed);
        } else if (this.mPurpleBtn == v) {
            v.setBackgroundResource(R.drawable.zm_anno_purple_pressed);
        } else if (this.mBlackBtn == v) {
            v.setBackgroundResource(R.drawable.zm_anno_black_pressed);
        }
    }

    private void setTextColorBtnLayoutParams(Button button, int size, int sourceId) {
        ViewGroup.LayoutParams params = button.getLayoutParams();
        params.width = UIUtil.sp2px((Context)this.getContext(), (float)size);
        params.height = UIUtil.sp2px((Context)this.getContext(), (float)size);
        button.setLayoutParams(params);
        if (0 != sourceId) {
            button.setBackgroundResource(sourceId);
        }
    }

    private void setTextBoldAndItalic(ImageView view) {
        if (null == view) {
            return;
        }
        if (view == this.mBoldBtn) {
            this.onSetTextBold();
            int resId = this.mEditText.getTypeface().isBold() ? R.drawable.zm_anno_bold_pressed : R.drawable.zm_anno_bold_normal;
            this.mBoldBtn.setImageResource(resId);
        } else {
            this.onSetTextItalic();
            int resId = this.mEditText.getTypeface().isItalic() ? R.drawable.zm_anno_italic_pressed : R.drawable.zm_anno_italic_normal;
            this.mItalicBtn.setImageResource(resId);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.savePhotoBtn) {
            this.notifySavePhoto();
            this.mSaveTableView.dismiss();
            return;
        }
        if (v == this.mSpotlight) {
            this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_SPOTLIGHT);
        } else if (v == this.mPen) {
            this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_PEN);
        } else if (v == this.mHighlight) {
            this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_HIGHLIGHTER);
        } else if (v == this.mErase) {
            this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_ERASER);
        } else {
            if (v == this.mColorIndicator) {
                if (this.mColorTableView.isShowing()) {
                    this.mColorTableView.dismiss();
                } else {
                    this.mColorTableView.showAsDropDown(this.mToolbars);
                    this.updateLineWidthPromt();
                }
                return;
            }
            if (v == this.mLine) {
                this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_AUTO_LINE);
            } else if (v == this.mArrow) {
                this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_AUTO_ARROW2);
            } else if (v == this.mRectangle) {
                this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_AUTO_RECTANGLE);
            } else if (v == this.mOval) {
                this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_AUTO_ELLIPSE);
            } else if (v == this.mText) {
                this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_TEXTBOX);
            } else {
                if (v == this.mUndo) {
                    this.mDrawingView.undo();
                    return;
                }
                if (v == this.mRedo) {
                    this.mDrawingView.redo();
                    return;
                }
                if (v == this.mClear) {
                    this.mDrawingView.eraserAll();
                    return;
                }
                if (v == this.mRedBtn) {
                    this.updateTextColor(this.mRedBtn, ColorTable.COLOR_RED);
                } else if (v == this.mGreenBtn) {
                    this.updateTextColor(this.mGreenBtn, ColorTable.COLOR_GREEN);
                } else if (v == this.mBlueBtn) {
                    this.updateTextColor(this.mBlueBtn, ColorTable.COLOR_LIGHTBLUE);
                } else if (v == this.mPurpleBtn) {
                    this.updateTextColor(this.mPurpleBtn, ColorTable.COLOR_DARK_RED);
                } else if (v == this.mBlackBtn) {
                    this.updateTextColor(this.mBlackBtn, ColorTable.COLOR_BLACK);
                } else if (v == this.mBoldBtn) {
                    this.setTextBoldAndItalic(this.mBoldBtn);
                } else if (v == this.mItalicBtn) {
                    this.setTextBoldAndItalic(this.mItalicBtn);
                } else if (v == this.mPlusBtn) {
                    this.onSetTextFontSize(true);
                } else if (v == this.mMinusBtn) {
                    this.onSetTextFontSize(false);
                } else if (v == this.mDoneBtn) {
                    this.mDrawingView.doneButtonClicked();
                }
            }
        }
        if (this.mText == v || this.mDrawingView.getCurAnnoToolType() != AnnoToolType.ANNO_TOOL_TYPE_TEXTBOX) {
            this.updateSelection(v);
        }
        this.notifyRefresh();
    }

    private void updateLineWidthPromt() {
        if (this.mColorTableView.isShowing()) {
            this.mLineWidthSeekBar.setProgress(this.mLineWidth);
            this.txtLineWidth.setText((CharSequence)String.valueOf(this.mLineWidth));
        }
    }

    @Override
    public void drawShareContent(Canvas canvas) {
        if (canvas == null) {
            return;
        }
        this.mDrawingView.drawShareContent(canvas);
    }

    @Override
    public int getShareContentWidth() {
        return this.mDrawingView.getWidth();
    }

    @Override
    public int getShareContentHeight() {
        return this.mDrawingView.getHeight();
    }

    @Override
    public void onColorChanged(View view, int newColor) {
    }

    @Override
    public void onColorPicked(View view, int newColor) {
        this.mDrawingView.setToolColor(newColor);
        this.mColorImage.setColor(newColor);
    }

    @Override
    public void onRepaint() {
        this.notifyRefresh();
    }

    @Override
    public void onLongPressed(boolean bLongClicked) {
        if (bLongClicked) {
            this.mSaveTableView.showAsDropDown(this.mToolbars);
        } else {
            this.mSaveTableView.dismiss();
        }
    }

    @Override
    public void onBitmapChanged(Canvas canvas) {
        this.notifyRefresh();
    }

    @Override
    public void closeAnnotateView() {
        if (null != this.mToolbars) {
            this.mToolbars.setVisibility(8);
            this.notifyCloseView();
        }
    }

    @Override
    public void pause() {
        if (AnnoToolType.ANNO_TOOL_TYPE_TEXTBOX == this.mDrawingView.getCurAnnoToolType()) {
            this.onEndEditing();
        }
    }

    @Override
    public void unregisterAnnotateListener() {
        if (null != this.mDrawingView) {
            this.mDrawingView.unRegisterUpdateListener(this);
        }
    }

    @Override
    public void setEidtModel(boolean bEidt) {
        if (null == this.mToolbars || null == this.mDrawingView) {
            return;
        }
        this.mbEditModle = bEidt;
        this.mToolbars.setVisibility(bEidt ? 0 : 8);
        this.mDrawingView.setEditModel(bEidt);
        if (AnnoToolType.ANNO_TOOL_TYPE_TEXTBOX == this.mDrawingView.getCurAnnoToolType()) {
            this.setTextViewVisible(false);
            this.initEditText();
        }
        this.refreshAnnotateWndSize();
    }

    @Override
    public void setIsPresenter(boolean bPresenter) {
        this.mLineWidth = 2;
        this.mDrawingView.setToolWidth(2, false);
        this.mDrawingView.setHighlightToolWidth(12);
        this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_PEN);
        this.setRandomColor();
        this.mTop = 0;
        this.mLeft = 0;
        this.mScale = 1.0f;
        this.updateSelection((View)this.mPen);
        this.mBPresenter = bPresenter;
        this.mDrawingView.setIsPresenter(bPresenter);
        this.closeAnnoToolbar();
    }

    private void closeAnnoToolbar() {
        if (null != this.mToolbars) {
            this.mToolbars.setVisibility(8);
            this.notifyCloseView();
        }
    }

    private void setRandomColor() {
        Random rand = new Random();
        int index = rand.nextInt(9);
        int color = ZMDrawObject.DFT_CLR;
        if (null != this.mColorTable) {
            color = this.mColorTable.getColorByIndex(index);
        }
        this.mDrawingView.setToolColor(color);
        this.mColorImage.setColor(color);
    }

    @Override
    public void closeTableView() {
        if (null != this.mColorTableView && this.mColorTableView.isShowing()) {
            this.mColorTableView.dismiss();
        }
        if (null != this.mSaveTableView && this.mSaveTableView.isShowing()) {
            this.mSaveTableView.dismiss();
        }
    }

    @Override
    public void onShareSourceDataSizeChanged(int width, int height) {
        if (this.mShareSourceHeight != height) {
            this.mShareSourceHeight = height;
            this.refreshAnnotateWndSize();
        }
    }

    @Override
    public void onDestAreaChangedChanged(float x, float y, float width, float height) {
        if (this.mOffsetX != x || this.mOffsetY != y || this.mLocalShareWidth != width || this.mLocalShareHeight != height) {
            this.mOffsetX = Math.abs(x);
            this.mOffsetY = Math.abs(y);
            this.mLocalShareHeight = height;
            this.mLocalShareWidth = width;
            this.refreshAnnotateWndSize();
        }
    }

    @Override
    public void onUpdateUnitShare(ShareUnit unit, int videoGalleryWidth, int videoGalleryHeight) {
        if (null == unit) {
            return;
        }
        this.mVideoGalleryWidth = videoGalleryWidth;
        this.mVideoGalleryHeight = videoGalleryHeight;
        if ((float)unit.getHeight() != this.mLocalShareHeight || (float)unit.getWidth() != this.mLocalShareWidth || unit.getLeft() != this.mLeft || unit.getTop() != this.mTop) {
            this.mShareUnit = unit;
            this.mLeft = unit.getLeft();
            this.mTop = this.mBPresenter ? 0 : unit.getTop();
            this.mLocalShareHeight = unit.getHeight();
            this.mLocalShareWidth = unit.getWidth();
            this.refreshAnnotateWndSize();
        }
    }

    @Override
    public void onBeginEditing(int x, int y) {
        this.setTextViewVisible(true);
        this.initEditText();
        this.checkEditTextPosition(x, y);
    }

    private void checkEditTextPosition(int x, int y) {
        int editTextHeight;
        int displsyHeight;
        int editTextWidth;
        int displayWidth = UIUtil.getDisplayWidth((Context)this.getContext());
        if (displayWidth - x < (editTextWidth = this.mEditText.getWidth() + this.mEditText.getPaddingLeft())) {
            x = displayWidth - editTextWidth;
        }
        int statusBarHeight = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = this.getResources().getDimensionPixelSize(resourceId);
        }
        if ((displsyHeight = UIUtil.getDisplayHeight((Context)this.getContext()) - this.mToolbars.getMeasuredHeight()) - y - statusBarHeight < (editTextHeight = this.mEditText.getHeight() + this.mEditText.getPaddingTop() * 2)) {
            y = displsyHeight - editTextHeight - statusBarHeight;
        }
        this.moveEditText(x + this.mLeft, y + this.mTop);
    }

    @Override
    public void onEndEditing() {
        this.setTextViewVisible(false);
        String text = this.mEditText.getText().toString();
        if (text.isEmpty()) {
            this.mDrawingView.editTextDidEndEditing(new short[1], this.mTextData);
            return;
        }
        char[] cc = text.toCharArray();
        short[] shortArray = new short[cc.length];
        for (int i = 0; i < cc.length; ++i) {
            shortArray[i] = (short)cc[i];
        }
        int fontColor = this.mEditText.getCurrentTextColor();
        fontColor = Color.argb((int)255, (int)Color.blue((int)fontColor), (int)Color.green((int)fontColor), (int)Color.red((int)fontColor));
        this.mTextData.setPadding(this.mEditText.getPaddingLeft());
        this.mTextData.setPosX(this.mEditTextPosX);
        this.mTextData.setPosY(this.mEditTextPosY);
        this.mTextData.setWidth((int)((float)this.mEditText.getWidth() * this.mScale));
        this.mTextData.setHeight((int)((float)this.mEditText.getHeight() * this.mScale));
        this.mTextData.setTextWidth((int)this.mEditText.getPaint().measureText(text));
        this.mTextData.setTextHeight(this.mEditText.getLineHeight() * this.mEditText.getLineCount());
        this.mTextData.setTextAlignment(this.getTextAlignmentAndroid2Anno(this.mEditText.getGravity()).ordinal());
        this.mTextData.setTextSize(this.mTextFontSize);
        this.mTextData.setTextLength(text.length());
        this.mTextData.setBold(this.mEditText.getTypeface().isBold());
        this.mTextData.setItalic(this.mEditText.getTypeface().isItalic());
        this.mTextData.setLineCount(this.mEditText.getLineCount());
        this.mTextData.setFontColor(fontColor);
        this.mDrawingView.editTextDidEndEditing(shortArray, this.mTextData);
        this.setTextViewVisible(false);
    }

    @Override
    public void onAnnotateViewSizeChanged() {
        if (null == this.mDrawingView) {
            return;
        }
        this.refreshAnnotateWndSize();
    }

    private void refreshAnnotateWndSize() {
        ((Activity)this.getContext()).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AnnotateDrawingView.this.updateAnnotateWndSize();
            }
        });
    }

    public void updateAnnotateWndSize() {
        if (null == this.mToolbars || null == this.mDrawingView) {
            return;
        }
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mDrawingView.getLayoutParams();
        params.height = this.getHeight();
        params.width = this.getWidth();
        if (!this.mBPresenter) {
            int right = this.mLeft;
            int bottom = this.mTop - this.mToolbars.getMeasuredHeight();
            bottom += this.mVideoGalleryHeight;
            right += this.mVideoGalleryWidth;
            if (UIUtil.isPortraitMode((Context)this.getContext())) {
                if (bottom < 0 && this.mVideoGalleryWidth == 0 && this.mVideoGalleryHeight == 0) {
                    bottom = 0;
                }
            } else if (bottom < 0) {
                bottom = 0;
            }
            params.setMargins(this.mLeft, this.mTop, right, bottom);
            this.mDrawingView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mScale = (float)this.mShareSourceHeight / this.mLocalShareHeight;
            this.mDrawingView.setScaleAndOffsetValue(this.mScale, this.mOffsetX, this.mOffsetY);
        } else {
            params.setMargins(0, 0, 0, 0);
            this.mDrawingView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mScale = 1.0f;
            this.mDrawingView.setScaleAndOffsetValue(this.mScale, 0.0f, 0.0f);
        }
    }

    private void initTextBox() {
        this.mTextData = new AnnotateTextData();
        this.mTextToolbars = this.mView.findViewById(R.id.drawingTexttools);
        this.mTextToolbars.setVisibility(8);
        this.mEditText = (EditText)this.mView.findViewById(R.id.editText);
        this.mEditText.setVisibility(8);
        this.mRedBtn = (Button)this.mView.findViewById(R.id.btnRed);
        this.mGreenBtn = (Button)this.mView.findViewById(R.id.btnGreen);
        this.mBlueBtn = (Button)this.mView.findViewById(R.id.btnBlue);
        this.mPurpleBtn = (Button)this.mView.findViewById(R.id.btnPurple);
        this.mBlackBtn = (Button)this.mView.findViewById(R.id.btnBlack);
        this.mBoldBtn = (ImageView)this.mView.findViewById(R.id.btnBold);
        this.mItalicBtn = (ImageView)this.mView.findViewById(R.id.btnItalic);
        this.mPlusBtn = (Button)this.mView.findViewById(R.id.btnPlus);
        this.mMinusBtn = (Button)this.mView.findViewById(R.id.btnMinus);
        this.mFontSize = (TextView)this.mView.findViewById(R.id.textSizeEditText);
        this.mDoneBtn = (Button)this.mView.findViewById(R.id.btnDone);
        String sizeStr = String.valueOf(this.mEditText.getTextSize());
        this.mFontSize.setText((CharSequence)sizeStr.substring(0, sizeStr.length() - 2));
        this.mRedBtn.setOnClickListener((View.OnClickListener)this);
        this.mGreenBtn.setOnClickListener((View.OnClickListener)this);
        this.mBlueBtn.setOnClickListener((View.OnClickListener)this);
        this.mBlueBtn.setSelected(true);
        this.mPurpleBtn.setOnClickListener((View.OnClickListener)this);
        this.mBlackBtn.setOnClickListener((View.OnClickListener)this);
        this.mBoldBtn.setOnClickListener((View.OnClickListener)this);
        this.mItalicBtn.setOnClickListener((View.OnClickListener)this);
        this.mPlusBtn.setOnClickListener((View.OnClickListener)this);
        this.mMinusBtn.setOnClickListener((View.OnClickListener)this);
        this.mDoneBtn.setOnClickListener((View.OnClickListener)this);
        this.initEditText();
        this.mEditText.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                AnnotateDrawingView.this.onEditTextTouch(v, event);
                return false;
            }
        });
    }

    private void onEditTextTouch(View v, MotionEvent event) {
        v.getParent().requestDisallowInterceptTouchEvent(true);
        switch (event.getAction()) {
            case 0: {
                this.mEditTextLastX = (int)event.getRawX();
                this.mEditTextLastY = (int)event.getRawY();
                break;
            }
            case 2: {
                float bottom;
                int dx = (int)event.getRawX() - this.mEditTextLastX;
                int dy = (int)event.getRawY() - this.mEditTextLastY;
                int l = v.getLeft() + dx;
                int b = v.getBottom() + dy;
                int r = v.getRight() + dx;
                int t = v.getTop() + dy;
                if (l < this.mLeft) {
                    l = this.mLeft;
                    r = l + v.getWidth();
                }
                if (t < this.mTop) {
                    t = this.mTop;
                    b = t + v.getHeight();
                }
                if (r > this.mScreenWidth - this.mLeft - this.mVideoGalleryWidth) {
                    r = this.mScreenWidth - this.mLeft - this.mVideoGalleryWidth;
                    l = r - v.getWidth();
                }
                float f = bottom = this.mBPresenter ? (float)(this.mScreenHeight - this.mTop - this.mToolbars.getMeasuredHeight()) : this.mLocalShareHeight + (float)this.mTop;
                if ((float)b > bottom) {
                    b = (int)bottom;
                    t = b - v.getHeight();
                }
                this.moveEditText(l, t);
                this.mEditTextLastX = (int)event.getRawX();
                this.mEditTextLastY = (int)event.getRawY();
            }
        }
    }

    private void initEditText() {
        this.updateTextColor(this.mBlueBtn, ColorTable.COLOR_LIGHTBLUE);
        this.mBoldBtn.setVisibility(0);
        this.mItalicBtn.setVisibility(0);
        this.mTextFontSize = 48;
        this.mFontSize.setText((CharSequence)String.valueOf(48));
        this.mEditText.setText((CharSequence)"");
        this.mEditText.setTypeface(Typeface.defaultFromStyle((int)0));
        this.mBoldBtn.setSelected(false);
        this.mItalicBtn.setSelected(false);
        float fontSize = 48.0f;
        if (!this.mBPresenter && this.mShareSourceHeight > 0) {
            fontSize = 48.0f * (this.mLocalShareHeight / (float)this.mShareSourceHeight);
        }
        this.mEditText.setTextSize(0, fontSize);
    }

    private void moveEditText(int x, int y) {
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mEditText.getLayoutParams();
        params.setMargins(x, y, 0, 0);
        this.mEditText.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mEditTextPosX = (int)(((float)(x - this.mLeft) + this.mOffsetX) * this.mScale);
        this.mEditTextPosY = (int)(((float)(y - this.mTop) + this.mOffsetY) * this.mScale);
    }

    private void setTextViewVisible(boolean visible) {
        if (null == this.mToolbars || null == this.mTextToolbars || null == this.mEditText) {
            return;
        }
        this.mToolbars.setVisibility(this.mbEditModle && !visible ? 0 : 8);
        this.mTextToolbars.setVisibility(visible && this.mbEditModle ? 0 : 8);
        this.mEditText.setVisibility(visible && this.mbEditModle ? 0 : 8);
        InputMethodManager imm = (InputMethodManager)this.mEditText.getContext().getSystemService("input_method");
        if (imm != null) {
            if (visible) {
                this.mEditText.requestFocus();
                imm.toggleSoftInput(0, 2);
            } else {
                imm.hideSoftInputFromWindow(this.mEditText.getWindowToken(), 0);
            }
        }
    }

    private void onSetTextBold() {
        Typeface typeface = this.mEditText.getTypeface();
        if (!typeface.isBold() && typeface.isItalic()) {
            this.mEditText.setTypeface(Typeface.defaultFromStyle((int)3));
        } else if (typeface.isBold() && typeface.isItalic()) {
            this.mEditText.setTypeface(Typeface.defaultFromStyle((int)2));
        } else if (typeface.isBold()) {
            this.mEditText.setTypeface(Typeface.defaultFromStyle((int)0));
        } else {
            this.mEditText.setTypeface(Typeface.defaultFromStyle((int)1));
        }
    }

    private void onSetTextItalic() {
        Typeface typeface = this.mEditText.getTypeface();
        if (typeface.isBold() && !typeface.isItalic()) {
            this.mEditText.setTypeface(Typeface.defaultFromStyle((int)3));
        } else if (typeface.isBold() && typeface.isItalic()) {
            this.mEditText.setTypeface(Typeface.defaultFromStyle((int)1));
        } else if (typeface.isItalic()) {
            this.mEditText.setTypeface(Typeface.defaultFromStyle((int)0));
        } else {
            this.mEditText.setTypeface(Typeface.defaultFromStyle((int)2));
        }
    }

    private void onSetTextFontSize(boolean isPlus) {
        this.mTextFontSize = isPlus ? ++this.mTextFontSize : --this.mTextFontSize;
        this.mFontSize.setText((CharSequence)String.valueOf(this.mTextFontSize));
        float fontSize = this.mTextFontSize;
        if (!this.mBPresenter && this.mShareSourceHeight > 0) {
            fontSize = (float)this.mTextFontSize * (this.mLocalShareHeight / (float)this.mShareSourceHeight);
        }
        this.mEditText.setTextSize(0, fontSize);
    }

    private AnnoParagraphAlignment getTextAlignmentAndroid2Anno(int wAlignment) {
        AnnoParagraphAlignment annoAlignment = AnnoParagraphAlignment.ANNO_PARAGRAPH_ALIGNMENT_LEFT;
        switch (wAlignment) {
            case 3: {
                annoAlignment = AnnoParagraphAlignment.ANNO_PARAGRAPH_ALIGNMENT_LEFT;
                break;
            }
            case 17: {
                annoAlignment = AnnoParagraphAlignment.ANNO_PARAGRAPH_ALIGNMENT_CENTER;
                break;
            }
            case 5: {
                annoAlignment = AnnoParagraphAlignment.ANNO_PARAGRAPH_ALIGNMENT_RIGHT;
                break;
            }
            default: {
                annoAlignment = AnnoParagraphAlignment.ANNO_PARAGRAPH_ALIGNMENT_LEFT;
            }
        }
        return annoAlignment;
    }

    static enum AnnoParagraphAlignment {
        ANNO_PARAGRAPH_ALIGNMENT_LEFT,
        ANNO_PARAGRAPH_ALIGNMENT_CENTER,
        ANNO_PARAGRAPH_ALIGNMENT_RIGHT,
        ANNO_PARAGRAPH_ALIGNMENT_JUSTIFY,
        ANNO_PARAGRAPH_ALIGNMENT_JUSTIFY_LOW,
        ANNO_PARAGRAPH_ALIGNMENT_NATURAL,
        ANNO_PARAGRAPH_ALIGNMENT_DISTRIBUTE,
        ANNO_PARAGRAPH_ALIGNMENT_THAI_DISTRIBUTE;

    }
}

