/*
 * Decompiled with CFR 0.152.
 */
package com.revolverobotics.kubisdk;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.revolverobotics.kubisdk.GattInterface;
import com.revolverobotics.kubisdk.KubiManager;
import java.util.Date;
import java.util.UUID;

public class Kubi
extends GattInterface {
    public static final int DIRECTION_TILT_NONE = 2;
    public static final int DIRECTION_TILT_STOP = 0;
    public static final int DIRECTION_TILT_UP = 1;
    public static final int DIRECTION_TILT_DOWN = -1;
    public static final int DIRECTION_PAN_NONE = 2;
    public static final int DIRECTION_PAN_STOP = 0;
    public static final int DIRECTION_PAN_LEFT = 1;
    public static final int DIRECTION_PAN_RIGHT = -1;
    public static final int GESTURE_BOW = 0;
    public static final int GESTURE_NOD = 1;
    public static final int GESTURE_SHAKE = 2;
    public static final int GESTURE_SCAN = 3;
    private static final float SERVO_SPEED_COEFF = 0.6686217f;
    private static final byte SERVO_SPEED_REGISTER = 32;
    private static final int RSSI_REQUEST_INTERVAL = 3000;
    private final UUID SERVO_SERVICE_UUID = UUID.fromString("2A001800-2803-2801-2800-1D9FF2D5C442");
    private final UUID KUBI_SERVICE_UUID = UUID.fromString("0000E001-0000-1000-8000-00805F9B34FB");
    private final UUID REGISTER_WRITE1P_UUID = UUID.fromString("00009141-0000-1000-8000-00805F9B34FB");
    private final UUID REGISTER_WRITE2P_UUID = UUID.fromString("00009142-0000-1000-8000-00805F9B34FB");
    private final UUID SERVO_HORIZONTAL_UUID = UUID.fromString("00009145-0000-1000-8000-00805F9B34FB");
    private final UUID SERVO_VERTICAL_UUID = UUID.fromString("00009146-0000-1000-8000-00805F9B34FB");
    private final UUID BATTERY_UUID = UUID.fromString("0000E101-0000-1000-8000-00805F9B34FB");
    private final UUID SERVO_ERROR_UUID = UUID.fromString("0000E102-0000-1000-8000-00805F9B34FB");
    private final UUID SERVO_ERROR_ID_UUID = UUID.fromString("0000E103-0000-1000-8000-00805F9B34FB");
    private final UUID LED_COLOR_UUID = UUID.fromString("0000E104-0000-1000-8000-00805F9B34FB");
    private final UUID BATTERY_STATUS_UUID = UUID.fromString("0000E105-0000-1000-8000-00805F9B34FB");
    private final UUID BUTTON_UUID = UUID.fromString("0000E10A-0000-1000-8000-00805F9B34FB");
    public static final float DEFAULT_SPEED = 52.3f;
    public static final float MAX_SPEED = 100.0f;
    public static final int MIN_SPEED_VAL = 1;
    public static final int SPEED_MIN = 2;
    public static final int SPEED_PAN_DEFAULT = 78;
    public static final int SPEED_PAN_MIN = 2;
    public static final int SPEED_PAN_MAX = 150;
    public static final int SPEED_TILT_DEFAULT = 47;
    public static final int SPEED_TILT_MIN = 2;
    public static final int SPEED_TILT_MAX = 105;
    public static final int ANGLE_PAN_ZERO = 0;
    public static final int ANGLE_PAN_MIN = -150;
    public static final int ANGLE_PAN_MAX = 150;
    public static final int ANGLE_TILT_ZERO = 0;
    public static final int ANGLE_TILT_MIN = -45;
    public static final int ANGLE_TILT_MAX = 45;
    BluetoothDevice mDevice;
    KubiManager mKubiManager;
    int mRSSI;
    private BluetoothGattService servoService;
    private BluetoothGattService kubiService;
    private Handler mHandler;
    private BluetoothGattCharacteristic registerWrite1p;
    private BluetoothGattCharacteristic registerWrite2p;
    private BluetoothGattCharacteristic servoHorizontal;
    private BluetoothGattCharacteristic servoVertical;
    private BluetoothGattCharacteristic battery;
    private BluetoothGattCharacteristic servoError;
    private BluetoothGattCharacteristic servoErrorID;
    private BluetoothGattCharacteristic ledColor;
    private BluetoothGattCharacteristic batteryStatus;
    private BluetoothGattCharacteristic button;
    private int tiltSpeed = 0;
    private float tiltAngle = 0.0f;
    private float previousPanAngle = 0.0f;
    private float panVelocity = 0.0f;
    private long panStartTime = 0L;
    private long panFinishTime = 0L;
    private int panDirection = 0;
    private int panSpeed = 0;
    private float panAngle = 0.0f;
    private float previousTiltAngle = 0.0f;
    private float tiltVelocity = 0.0f;
    private long tiltStartTime = 0L;
    private long tiltFinishTime = 0L;
    private int tiltDirection = 0;
    private float nodTemp = 0.0f;
    private float shakeTemp = 0.0f;
    private Context mContext;

    public Kubi(Context context, KubiManager manager, BluetoothDevice device) {
        this.mDevice = device;
        this.mKubiManager = manager;
        this.mHandler = new Handler();
        this.mContext = context;
        this.connect();
    }

    public void connect() {
        this.mGatt = this.mDevice.connectGatt(this.mContext, true, (BluetoothGattCallback)this);
    }

    public static int servoAngle(float angle) {
        return (int)((angle + 150.0f) * 1023.0f / 300.0f);
    }

    public static int servoSpeed(float speed) {
        return (int)Math.min((double)speed * 1.53, 100.0);
    }

    public float getPan() {
        return this.previousPanAngle;
    }

    public float getTilt() {
        return this.previousTiltAngle;
    }

    public int getRSSI() {
        return this.mRSSI;
    }

    public String getName() {
        return this.mDevice.getName();
    }

    public void moveTo(float pan, float tilt) {
        this.moveTo(pan, tilt, 52.3f, true);
    }

    public void moveTo(float pan, float tilt, float speed) {
        this.moveTo(pan, tilt, speed, true);
    }

    public void moveTo(float pan, float tilt, float speed, boolean smooth) {
        if (this.servoHorizontal != null && this.servoVertical != null) {
            int panSpeed;
            int tiltSpeed;
            int panVal = Kubi.servoAngle(pan);
            int tiltVal = Kubi.servoAngle(tilt);
            if (!smooth) {
                panSpeed = tiltSpeed = Kubi.servoSpeed(speed);
            } else {
                int tiltArc;
                int panArc = (int)Math.abs(pan - this.previousPanAngle);
                if (panArc > (tiltArc = (int)Math.abs(tilt - this.previousTiltAngle))) {
                    panSpeed = Kubi.servoSpeed(speed);
                    tiltSpeed = (int)((float)tiltArc / (float)panArc * (float)panSpeed);
                } else if (tiltArc > panArc) {
                    tiltSpeed = Kubi.servoSpeed(speed);
                    panSpeed = (int)((float)panArc / (float)tiltArc * (float)tiltSpeed);
                } else {
                    panSpeed = tiltSpeed = Kubi.servoSpeed(speed);
                }
            }
            if (tiltSpeed < 1) {
                tiltSpeed = 1;
            }
            if (panSpeed < 1) {
                panSpeed = 1;
            }
            byte[] buff = new byte[]{1, 32, (byte)panSpeed, (byte)(panSpeed >> 8)};
            super.enqueueWrite(this.registerWrite2p, buff);
            buff = new byte[]{2, 32, (byte)tiltSpeed, (byte)(tiltSpeed >> 8)};
            super.enqueueWrite(this.registerWrite2p, buff);
            buff = new byte[]{(byte)(panVal >> 8), (byte)panVal};
            super.enqueueWrite(this.servoHorizontal, buff);
            buff = new byte[]{(byte)(tiltVal >> 8), (byte)tiltVal};
            super.enqueueWrite(this.servoVertical, buff);
            this.previousPanAngle = pan;
            this.previousTiltAngle = tilt;
        }
    }

    public void moveTo(float pan, float tilt, float speed, boolean smooth, float panSpeedBeforeServo, float tiltSpeedBeforeServo) {
        if (this.servoHorizontal != null && this.servoVertical != null) {
            int tiltSpeed;
            int panSpeed;
            int panVal = Kubi.servoAngle(pan);
            int tiltVal = Kubi.servoAngle(tilt);
            if (!smooth) {
                panSpeed = Kubi.servoSpeed(panSpeedBeforeServo);
                tiltSpeed = Kubi.servoSpeed(tiltSpeedBeforeServo);
            } else {
                int tiltArc;
                int panArc = (int)Math.abs(pan - this.previousPanAngle);
                if (panArc > (tiltArc = (int)Math.abs(tilt - this.previousTiltAngle))) {
                    panSpeed = Kubi.servoSpeed(speed);
                    tiltSpeed = (int)((float)tiltArc / (float)panArc * (float)panSpeed);
                } else if (tiltArc > panArc) {
                    tiltSpeed = Kubi.servoSpeed(speed);
                    panSpeed = (int)((float)panArc / (float)tiltArc * (float)tiltSpeed);
                } else {
                    panSpeed = tiltSpeed = Kubi.servoSpeed(speed);
                }
            }
            if (tiltSpeed < 1) {
                tiltSpeed = 1;
            }
            if (panSpeed < 1) {
                panSpeed = 1;
            }
            byte[] buff = new byte[]{1, 32, (byte)panSpeed, (byte)(panSpeed >> 8)};
            super.enqueueWrite(this.registerWrite2p, buff);
            buff = new byte[]{2, 32, (byte)tiltSpeed, (byte)(tiltSpeed >> 8)};
            super.enqueueWrite(this.registerWrite2p, buff);
            buff = new byte[]{(byte)(panVal >> 8), (byte)panVal};
            super.enqueueWrite(this.servoHorizontal, buff);
            buff = new byte[]{(byte)(tiltVal >> 8), (byte)tiltVal};
            super.enqueueWrite(this.servoVertical, buff);
            this.previousPanAngle = pan;
            this.previousTiltAngle = tilt;
        }
    }

    public void unlockDevice() {
        int[] unlockPanCommand = new int[]{1, 24, 0};
        byte[] unlockPanByteArray = new byte[]{(byte)unlockPanCommand[0], (byte)unlockPanCommand[1], (byte)unlockPanCommand[2]};
        super.enqueueWrite(this.registerWrite1p, unlockPanByteArray);
        int[] unlockTiltCommand = new int[]{2, 24, 0};
        byte[] unlockTiltByteArray = new byte[]{(byte)unlockTiltCommand[0], (byte)unlockTiltCommand[1], (byte)unlockTiltCommand[2]};
        super.enqueueWrite(this.registerWrite1p, unlockTiltByteArray);
    }

    public void lockDevice() {
        int[] lockPanCommand = new int[]{1, 24, 1};
        byte[] lockPanByteArray = new byte[]{(byte)lockPanCommand[0], (byte)lockPanCommand[1], (byte)lockPanCommand[2]};
        super.enqueueWrite(this.registerWrite1p, lockPanByteArray);
        int[] lockTiltCommand = new int[]{2, 24, 1};
        byte[] lockTiltByteArray = new byte[]{(byte)lockTiltCommand[0], (byte)lockTiltCommand[1], (byte)lockTiltCommand[2]};
        super.enqueueWrite(this.registerWrite1p, lockTiltByteArray);
    }

    public void disconnect() {
        this.mGatt.close();
        this.mKubiManager.onKubiDisconnect(this);
    }

    public void setIndicatorColor(byte red, byte green, byte blue) {
        byte[] buff = new byte[]{red, green, blue};
        super.enqueueWrite(this.ledColor, buff);
    }

    public String getKubiID() {
        String name = this.mDevice.getName();
        return name.substring(name.length() - 6);
    }

    public void performGesture(int gesture) {
        switch (gesture) {
            case 0: {
                this.bow();
                break;
            }
            case 1: {
                this.nod();
                break;
            }
            case 2: {
                this.shake();
                break;
            }
            case 3: {
                this.scan();
            }
        }
    }

    private void bow() {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(Kubi.this.previousPanAngle, 10.0f, 52.3f, false);
            }
        }, 200L);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(Kubi.this.previousPanAngle, -27.0f, 52.3f, false);
            }
        }, 700L);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(Kubi.this.previousPanAngle, 0.0f, 52.3f, false);
            }
        }, 1650L);
    }

    private void shake() {
        this.shakeTemp = this.previousPanAngle;
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(Kubi.this.shakeTemp - 15.0f, Kubi.this.previousTiltAngle, 52.3f, false);
            }
        }, 200L);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(Kubi.this.shakeTemp + 15.0f, Kubi.this.previousTiltAngle, 52.3f, false);
            }
        }, 500L);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(Kubi.this.shakeTemp, Kubi.this.previousTiltAngle, 52.3f, false);
            }
        }, 1250L);
    }

    private void nod() {
        this.nodTemp = this.previousTiltAngle;
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(Kubi.this.previousPanAngle, -15.0f, 52.3f, false);
            }
        }, 200L);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(Kubi.this.previousPanAngle, 0.0f, 52.3f, false);
            }
        }, 500L);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(Kubi.this.previousPanAngle, -15.0f, 52.3f, false);
            }
        }, 800L);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(Kubi.this.previousPanAngle, Kubi.this.nodTemp);
            }
        }, 1100L);
    }

    private void scan() {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(-120.0f, 0.0f, 52.3f, false);
            }
        }, 200L);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(-60.0f, 0.0f, 52.3f, false);
            }
        }, 3000L);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(0.0f, 0.0f, 52.3f, false);
            }
        }, 5000L);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(60.0f, 0.0f, 52.3f, false);
            }
        }, 7000L);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(120.0f, 0.0f, 52.3f, false);
            }
        }, 9000L);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                Kubi.this.moveTo(0.0f, 0.0f, 52.3f, false);
            }
        }, 11000L);
    }

    private void requestRSSI() {
        this.mGatt.readRemoteRssi();
    }

    private void sendOnReady() {
        if (this.mKubiManager != null) {
            this.mKubiManager.onKubiReady(this);
        }
    }

    public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
        if (newState == 2) {
            Log.i((String)"Kubi", (String)"Kubi connected.");
            this.mGatt = gatt;
            gatt.discoverServices();
        } else if (newState == 0) {
            this.mKubiManager.onKubiDisconnect(this);
            Log.i((String)"Kubi", (String)"Kubi disconnected.");
        }
    }

    public void onServicesDiscovered(BluetoothGatt gatt, int status) {
        if (status == 0) {
            this.servoService = gatt.getService(this.SERVO_SERVICE_UUID);
            this.kubiService = gatt.getService(this.KUBI_SERVICE_UUID);
            if (this.servoService != null && this.kubiService != null) {
                this.registerWrite1p = this.servoService.getCharacteristic(this.REGISTER_WRITE1P_UUID);
                this.registerWrite2p = this.servoService.getCharacteristic(this.REGISTER_WRITE2P_UUID);
                this.servoHorizontal = this.servoService.getCharacteristic(this.SERVO_HORIZONTAL_UUID);
                this.servoVertical = this.servoService.getCharacteristic(this.SERVO_VERTICAL_UUID);
                this.battery = this.kubiService.getCharacteristic(this.BATTERY_UUID);
                this.servoError = this.kubiService.getCharacteristic(this.SERVO_ERROR_UUID);
                this.servoErrorID = this.kubiService.getCharacteristic(this.SERVO_ERROR_ID_UUID);
                this.ledColor = this.kubiService.getCharacteristic(this.LED_COLOR_UUID);
                this.batteryStatus = this.kubiService.getCharacteristic(this.BATTERY_STATUS_UUID);
                this.button = this.kubiService.getCharacteristic(this.BUTTON_UUID);
                if (this.mKubiManager != null) {
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            Kubi.this.sendOnReady();
                        }
                    });
                    this.requestRSSI();
                }
            } else {
                this.mKubiManager.disconnect();
            }
        } else {
            Log.e((String)"Kubi", (String)"Unable to discover services.");
        }
    }

    public void onReadRemoteRssi(BluetoothGatt gatt, int rssi, int status) {
        if (status == 0) {
            this.mRSSI = rssi;
            this.mKubiManager.onKubiUpdateRSSI(this, rssi);
        }
    }

    @Override
    protected void characteristicValueRead(BluetoothGattCharacteristic c) {
    }

    public void sendPanData(float angle, int speed) {
        if (this.registerWrite2p != null && this.servoHorizontal != null) {
            int panAngle = Kubi.servoAngle(angle);
            int panSpeed = speed;
            byte[] buff = new byte[]{1, 32, (byte)panSpeed, (byte)(panSpeed >> 8)};
            super.enqueueWrite(this.registerWrite2p, buff);
            buff = new byte[]{(byte)(panAngle >> 8), (byte)panAngle};
            super.enqueueWrite(this.servoHorizontal, buff);
        }
    }

    public void sendTiltData(float angle, int speed) {
        if (this.registerWrite2p != null && this.servoVertical != null) {
            int tiltAngle = Kubi.servoAngle(angle);
            int tiltSpeed = speed;
            byte[] buff = new byte[]{2, 32, (byte)tiltSpeed, (byte)(tiltSpeed >> 8)};
            super.enqueueWrite(this.registerWrite2p, buff);
            buff = new byte[]{(byte)(tiltAngle >> 8), (byte)tiltAngle};
            super.enqueueWrite(this.servoVertical, buff);
        }
    }

    public void moveToPan(float angle, int speed) {
        this.previousPanAngle = this.getCurrentPanAngle();
        if (Float.isNaN(this.previousPanAngle)) {
            this.previousPanAngle = this.panAngle;
        }
        if (angle > 150.0f) {
            angle = 150.0f;
        }
        if (angle < -150.0f) {
            angle = -150.0f;
        }
        if (speed > 150) {
            speed = 150;
        }
        if (speed < 2) {
            speed = 2;
        }
        this.panVelocity = (float)speed * 0.6686217f;
        if (angle < this.previousPanAngle) {
            this.panVelocity = -this.panVelocity;
        }
        this.sendPanData(angle, speed);
        Date currentDate = new Date();
        this.panStartTime = currentDate.getTime();
        this.panAngle = angle;
        this.panSpeed = speed;
        this.panDirection = this.panVelocity >= 0.0f ? 1 : -1;
    }

    public void moveToTilt(float angle, int speed) {
        this.previousTiltAngle = this.getCurrentTiltAngle();
        if (Float.isNaN(this.previousTiltAngle)) {
            this.previousTiltAngle = this.tiltAngle;
        }
        if (angle > 45.0f) {
            angle = 45.0f;
        }
        if (angle < -45.0f) {
            angle = -45.0f;
        }
        if (speed > 105) {
            speed = 105;
        }
        if (speed < 2) {
            speed = 2;
        }
        this.tiltVelocity = (float)speed * 0.6686217f;
        if (angle < this.previousTiltAngle) {
            this.tiltVelocity = -this.tiltVelocity;
        }
        this.sendTiltData(angle, speed);
        Date currentDate = new Date();
        this.tiltStartTime = currentDate.getTime();
        this.tiltAngle = angle;
        this.tiltSpeed = speed;
        this.tiltDirection = this.tiltVelocity >= 0.0f ? 1 : -1;
    }

    private float getCurrentPanAngle() {
        if (!Float.isNaN(this.previousPanAngle) && !Float.isNaN(this.panAngle) && this.panStartTime > 0L) {
            float timeDiffInSec;
            Date currentDate = new Date();
            long currentTime = currentDate.getTime();
            long timeDiffInMs = currentTime - this.panStartTime;
            float panTime = timeDiffInSec = (float)timeDiffInMs / 1000.0f;
            float panAngleEstimate = this.previousPanAngle + panTime * this.panVelocity;
            if (this.panVelocity > 0.0f && panAngleEstimate < this.panAngle || this.panVelocity < 0.0f && panAngleEstimate > this.panAngle) {
                return panAngleEstimate;
            }
            return this.panAngle;
        }
        return Float.NaN;
    }

    private float getCurrentTiltAngle() {
        if (!Float.isNaN(this.previousTiltAngle) && !Float.isNaN(this.tiltAngle) && this.tiltStartTime > 0L) {
            float timeDiffInSec;
            Date currentDate = new Date();
            long currentTime = currentDate.getTime();
            long timeDiffInMs = currentTime - this.tiltStartTime;
            float tiltTime = timeDiffInSec = (float)timeDiffInMs / 1000.0f;
            float tiltAngleEstimate = this.previousTiltAngle + tiltTime * this.tiltVelocity;
            if (this.tiltVelocity > 0.0f && tiltAngleEstimate < this.tiltAngle || this.tiltVelocity < 0.0f && tiltAngleEstimate > this.tiltAngle) {
                return tiltAngleEstimate;
            }
            return this.tiltAngle;
        }
        return Float.NaN;
    }

    public void moveInPanDirectionWithSpeed(int direction, int speed) {
        if (direction == 2) {
            return;
        }
        if (speed < 2 || speed > 150) {
            speed = 78;
        }
        speed = Math.abs(speed);
        this.setPanDirectionAndSpeed(direction, speed);
    }

    public void moveInTiltDirectionWithSpeed(int direction, int speed) {
        if (direction == 2) {
            return;
        }
        if (speed < 2 || speed > 105) {
            speed = 47;
        }
        speed = Math.abs(speed);
        this.setTiltDirectionAndSpeed(direction, speed);
    }

    public void setPanDirectionAndSpeed(int direction, int speed) {
        switch (direction) {
            case 0: {
                this.stopPanMove();
                break;
            }
            case 1: {
                this.moveToPan(150.0f, speed);
                break;
            }
            case -1: {
                this.moveToPan(-150.0f, speed);
                break;
            }
        }
    }

    public void setTiltDirectionAndSpeed(int direction, int speed) {
        switch (direction) {
            case 0: {
                this.stopTiltMove();
                break;
            }
            case 1: {
                this.moveToTilt(45.0f, speed);
                break;
            }
            case -1: {
                this.moveToTilt(-45.0f, speed);
                break;
            }
        }
    }

    public void stopPanMove() {
        float currentPanAngle = this.getCurrentPanAngle();
        if (Float.isNaN(currentPanAngle)) {
            return;
        }
        this.moveToPan(currentPanAngle, this.panSpeed);
        this.panDirection = 0;
    }

    public void stopTiltMove() {
        float currentTiltAngle = this.getCurrentTiltAngle();
        if (Float.isNaN(currentTiltAngle)) {
            return;
        }
        this.moveToTilt(currentTiltAngle, this.tiltSpeed);
        this.panDirection = 0;
    }
}

