/*
 * Decompiled with CFR 0.152.
 */
package com.revolverobotics.kubisdk;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.os.Handler;
import android.util.Log;
import java.util.LinkedList;
import java.util.Queue;

public abstract class GattInterface
extends BluetoothGattCallback {
    private Queue<BluetoothGattCharacteristic> writeQueue = new LinkedList<BluetoothGattCharacteristic>();
    private Queue<BluetoothGattCharacteristic> readQueue = new LinkedList<BluetoothGattCharacteristic>();
    private Queue<byte[]> dataQueue = new LinkedList<byte[]>();
    private boolean idle = true;
    public BluetoothGatt mGatt = null;
    protected Handler mHandler = new Handler();

    protected void enqueueWrite(BluetoothGattCharacteristic c, byte[] data) {
        if (this.mGatt != null) {
            this.writeQueue.add(c);
            this.dataQueue.add(data);
            if (this.idle) {
                this.idle = false;
                this.executeNextWrite();
            }
        }
    }

    protected void enqueueRead(BluetoothGattCharacteristic c) {
        if (this.mGatt != null) {
            this.readQueue.add(c);
            if (this.idle) {
                this.idle = false;
                this.executeNextRead();
            }
        }
    }

    protected abstract void characteristicValueRead(BluetoothGattCharacteristic var1);

    private void executeNextWrite() {
        BluetoothGattCharacteristic c;
        if (this.mGatt != null && (c = this.writeQueue.peek()) != null) {
            byte[] data = this.dataQueue.peek();
            c.setValue(data);
            if (!this.mGatt.writeCharacteristic(c)) {
                Log.e((String)"GattWriter", (String)("Unable to write to characteristic " + c.getUuid().toString()));
            }
        }
    }

    private void executeNextRead() {
        BluetoothGattCharacteristic c;
        if (this.mGatt != null && (c = this.readQueue.peek()) != null && !this.mGatt.readCharacteristic(c)) {
            Log.e((String)"GattWriter", (String)("Unable to write to characteristic " + c.getUuid().toString()));
        }
    }

    private void performNextAction() {
        if (this.writeQueue.size() > 0) {
            this.executeNextWrite();
        } else if (this.readQueue.size() > 0) {
            this.executeNextRead();
        } else {
            this.idle = true;
        }
    }

    public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        BluetoothGattCharacteristic c = this.writeQueue.peek();
        if (characteristic == c && status == 0) {
            this.writeQueue.poll();
            this.dataQueue.poll();
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GattInterface.this.performNextAction();
            }
        });
    }

    public void onCharacteristicRead(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        BluetoothGattCharacteristic c = this.readQueue.peek();
        if (characteristic == c && status == 0) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    GattInterface.this.characteristicValueRead((BluetoothGattCharacteristic)GattInterface.this.readQueue.poll());
                }
            };
            this.mHandler.post(r);
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GattInterface.this.performNextAction();
            }
        });
    }
}

