/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.template;

import java.util.Map;
import us.zoom.template.IStatement;
import us.zoom.template.Template;

class IfStatement
implements IStatement {
    private String mConditionVariable;
    private boolean mIsNegative = false;
    private Template mIfTemplate;
    private Template mElseTemplate;

    public IfStatement(String conditionVariable, Template ifTemplate, Template elseTemplate) {
        if (conditionVariable.startsWith("!")) {
            this.mIsNegative = true;
            this.mConditionVariable = conditionVariable.substring(1);
        } else {
            this.mConditionVariable = conditionVariable;
        }
        this.mIfTemplate = ifTemplate;
        this.mElseTemplate = elseTemplate;
    }

    @Override
    public String format(Map<String, String> config) {
        boolean bVal;
        String val = config == null ? null : config.get(this.mConditionVariable);
        boolean bl = bVal = val != null && !"false".equals(val);
        if (this.mIsNegative) {
            boolean bl2 = bVal = !bVal;
        }
        if (bVal) {
            return this.mIfTemplate.format(config);
        }
        if (this.mElseTemplate != null) {
            return this.mElseTemplate.format(config);
        }
        return "";
    }
}

