/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget.recyclerview;

import android.graphics.Bitmap;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.StringRes;
import android.support.v7.widget.RecyclerView;
import android.text.util.Linkify;
import android.util.SparseArray;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.TextView;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import us.zoom.androidlib.widget.recyclerview.ZMBaseRecyclerViewAdapter;

public class ZMBaseRecyclerViewItemHolder
extends RecyclerView.ViewHolder {
    private final SparseArray<View> views = new SparseArray();
    private final HashSet<Integer> nestViews;
    private final LinkedHashSet<Integer> childClickViewIds = new LinkedHashSet();
    private final LinkedHashSet<Integer> itemChildLongClickViewIds = new LinkedHashSet();
    private ZMBaseRecyclerViewAdapter adapter;
    @Deprecated
    public View convertView;
    Object associatedObject;

    public Set<Integer> getNestViews() {
        return this.nestViews;
    }

    public ZMBaseRecyclerViewItemHolder(View view) {
        super(view);
        this.nestViews = new HashSet();
        this.convertView = view;
    }

    private int getClickPosition() {
        if (this.getLayoutPosition() >= this.adapter.getHeaderLayoutCount()) {
            return this.getLayoutPosition() - this.adapter.getHeaderLayoutCount();
        }
        return 0;
    }

    public HashSet<Integer> getItemChildLongClickViewIds() {
        return this.itemChildLongClickViewIds;
    }

    public HashSet<Integer> getChildClickViewIds() {
        return this.childClickViewIds;
    }

    @Deprecated
    public View getConvertView() {
        return this.convertView;
    }

    public ZMBaseRecyclerViewItemHolder setText(@IdRes int viewId, CharSequence value) {
        TextView view = (TextView)this.getView(viewId);
        view.setText(value);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setText(@IdRes int viewId, @StringRes int strId) {
        TextView view = (TextView)this.getView(viewId);
        view.setText(strId);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setImageResource(@IdRes int viewId, @DrawableRes int imageResId) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageResource(imageResId);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setBackgroundColor(@IdRes int viewId, @ColorInt int color2) {
        Object view = this.getView(viewId);
        view.setBackgroundColor(color2);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setBackgroundRes(@IdRes int viewId, @DrawableRes int backgroundRes) {
        Object view = this.getView(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setTextColor(@IdRes int viewId, @ColorInt int textColor) {
        TextView view = (TextView)this.getView(viewId);
        view.setTextColor(textColor);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setImageDrawable(@IdRes int viewId, Drawable drawable2) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageDrawable(drawable2);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setImageBitmap(@IdRes int viewId, Bitmap bitmap) {
        ImageView view = (ImageView)this.getView(viewId);
        view.setImageBitmap(bitmap);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setAlpha(@IdRes int viewId, float value) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.getView(viewId).setAlpha(value);
        } else {
            AlphaAnimation alpha = new AlphaAnimation(value, value);
            alpha.setDuration(0L);
            alpha.setFillAfter(true);
            this.getView(viewId).startAnimation((Animation)alpha);
        }
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setGone(@IdRes int viewId, boolean visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible ? 0 : 8);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setVisible(@IdRes int viewId, boolean visible) {
        Object view = this.getView(viewId);
        view.setVisibility(visible ? 0 : 4);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder linkify(@IdRes int viewId) {
        TextView view = (TextView)this.getView(viewId);
        Linkify.addLinks((TextView)view, (int)15);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setTypeface(@IdRes int viewId, Typeface typeface) {
        TextView view = (TextView)this.getView(viewId);
        view.setTypeface(typeface);
        view.setPaintFlags(view.getPaintFlags() | 0x80);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setTypeface(Typeface typeface, int ... viewIds) {
        for (int viewId : viewIds) {
            TextView view = (TextView)this.getView(viewId);
            view.setTypeface(typeface);
            view.setPaintFlags(view.getPaintFlags() | 0x80);
        }
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setProgress(@IdRes int viewId, int progress) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setProgress(progress);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setProgress(@IdRes int viewId, int progress, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        view.setProgress(progress);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setMax(@IdRes int viewId, int max) {
        ProgressBar view = (ProgressBar)this.getView(viewId);
        view.setMax(max);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setRating(@IdRes int viewId, float rating) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setRating(rating);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setRating(@IdRes int viewId, float rating, int max) {
        RatingBar view = (RatingBar)this.getView(viewId);
        view.setMax(max);
        view.setRating(rating);
        return this;
    }

    @Deprecated
    public ZMBaseRecyclerViewItemHolder setOnClickListener(@IdRes int viewId, View.OnClickListener listener) {
        Object view = this.getView(viewId);
        view.setOnClickListener(listener);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder addOnClickListener(@IdRes int viewId) {
        this.childClickViewIds.add(viewId);
        Object view = this.getView(viewId);
        if (view != null) {
            if (!view.isClickable()) {
                view.setClickable(true);
            }
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ZMBaseRecyclerViewItemHolder.this.adapter.getOnItemChildClickListener() != null) {
                        ZMBaseRecyclerViewItemHolder.this.adapter.getOnItemChildClickListener().onItemChildClick(ZMBaseRecyclerViewItemHolder.this.adapter, v, ZMBaseRecyclerViewItemHolder.this.getClickPosition());
                    }
                }
            });
        }
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setNestView(@IdRes int viewId) {
        this.addOnClickListener(viewId);
        this.addOnLongClickListener(viewId);
        this.nestViews.add(viewId);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder addOnLongClickListener(@IdRes int viewId) {
        this.itemChildLongClickViewIds.add(viewId);
        Object view = this.getView(viewId);
        if (view != null) {
            if (!view.isLongClickable()) {
                view.setLongClickable(true);
            }
            view.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return ZMBaseRecyclerViewItemHolder.this.adapter.getOnItemChildLongClickListener() != null && ZMBaseRecyclerViewItemHolder.this.adapter.getOnItemChildLongClickListener().onItemChildLongClick(ZMBaseRecyclerViewItemHolder.this.adapter, v, ZMBaseRecyclerViewItemHolder.this.getClickPosition());
                }
            });
        }
        return this;
    }

    @Deprecated
    public ZMBaseRecyclerViewItemHolder setOnTouchListener(@IdRes int viewId, View.OnTouchListener listener) {
        Object view = this.getView(viewId);
        view.setOnTouchListener(listener);
        return this;
    }

    @Deprecated
    public ZMBaseRecyclerViewItemHolder setOnLongClickListener(@IdRes int viewId, View.OnLongClickListener listener) {
        Object view = this.getView(viewId);
        view.setOnLongClickListener(listener);
        return this;
    }

    @Deprecated
    public ZMBaseRecyclerViewItemHolder setOnItemClickListener(@IdRes int viewId, AdapterView.OnItemClickListener listener) {
        AdapterView view = (AdapterView)this.getView(viewId);
        view.setOnItemClickListener(listener);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setOnItemLongClickListener(@IdRes int viewId, AdapterView.OnItemLongClickListener listener) {
        AdapterView view = (AdapterView)this.getView(viewId);
        view.setOnItemLongClickListener(listener);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setOnItemSelectedClickListener(@IdRes int viewId, AdapterView.OnItemSelectedListener listener) {
        AdapterView view = (AdapterView)this.getView(viewId);
        view.setOnItemSelectedListener(listener);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setOnCheckedChangeListener(@IdRes int viewId, CompoundButton.OnCheckedChangeListener listener) {
        CompoundButton view = (CompoundButton)this.getView(viewId);
        view.setOnCheckedChangeListener(listener);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setTag(@IdRes int viewId, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(tag);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setTag(@IdRes int viewId, int key, Object tag) {
        Object view = this.getView(viewId);
        view.setTag(key, tag);
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setChecked(@IdRes int viewId, boolean checked) {
        Object view = this.getView(viewId);
        if (view instanceof Checkable) {
            ((Checkable)view).setChecked(checked);
        }
        return this;
    }

    public ZMBaseRecyclerViewItemHolder setAdapter(@IdRes int viewId, Adapter adapter) {
        AdapterView view = (AdapterView)this.getView(viewId);
        view.setAdapter(adapter);
        return this;
    }

    protected ZMBaseRecyclerViewItemHolder setAdapter(ZMBaseRecyclerViewAdapter adapter) {
        this.adapter = adapter;
        return this;
    }

    public <T extends View> T getView(@IdRes int viewId) {
        View view = (View)this.views.get(viewId);
        if (view == null) {
            view = this.itemView.findViewById(viewId);
            this.views.put(viewId, (Object)view);
        }
        return (T)view;
    }

    public Object getAssociatedObject() {
        return this.associatedObject;
    }

    public void setAssociatedObject(Object associatedObject) {
        this.associatedObject = associatedObject;
    }
}

