/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget.recyclerview;

import android.support.annotation.IntRange;
import android.support.annotation.LayoutRes;
import android.util.SparseIntArray;
import android.view.ViewGroup;
import java.util.List;
import us.zoom.androidlib.widget.recyclerview.ZMBaseRecyclerViewAdapter;
import us.zoom.androidlib.widget.recyclerview.ZMBaseRecyclerViewItemHolder;
import us.zoom.androidlib.widget.recyclerview.ZMMultiItemEntity;

public abstract class ZMBaseMultiItemRecyclerViewAdapter<T extends ZMMultiItemEntity, K extends ZMBaseRecyclerViewItemHolder>
extends ZMBaseRecyclerViewAdapter<T, K> {
    private SparseIntArray layouts;
    private static final int DEFAULT_VIEW_TYPE = -255;
    public static final int TYPE_NOT_FOUND = -404;

    public ZMBaseMultiItemRecyclerViewAdapter(List<T> data) {
        super(data);
    }

    @Override
    protected int getDefItemViewType(int position) {
        ZMMultiItemEntity item = (ZMMultiItemEntity)this.mData.get(position);
        if (item != null) {
            return item.getItemType();
        }
        return -255;
    }

    protected void setDefaultViewTypeLayout(@LayoutRes int layoutResId) {
        this.addItemType(-255, layoutResId);
    }

    @Override
    protected K onCreateDefViewHolder(ViewGroup parent, int viewType) {
        return this.createBaseViewHolder(parent, this.getLayoutId(viewType));
    }

    private int getLayoutId(int viewType) {
        return this.layouts.get(viewType, -404);
    }

    protected void addItemType(int type, @LayoutRes int layoutResId) {
        if (this.layouts == null) {
            this.layouts = new SparseIntArray();
        }
        this.layouts.put(type, layoutResId);
    }

    @Override
    public void remove(@IntRange(from=0L) int position) {
        if (this.mData == null || position < 0 || position >= this.mData.size()) {
            return;
        }
        ZMMultiItemEntity entity = (ZMMultiItemEntity)this.mData.get(position);
        super.remove(position);
    }
}

