/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMTip;

public class ZMTipLayer
extends FrameLayout {
    public ZMTipLayer(Context context) {
        super(context);
        this.initView();
    }

    public ZMTipLayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ZMTipLayer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    private void initView() {
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof ZMTip)) continue;
            this.layoutTip((ZMTip)child, this.getWidth(), this.getHeight());
        }
    }

    private boolean isNonPositionedTip(ZMTip tip) {
        if (tip == null) {
            return false;
        }
        return tip instanceof ZMTip && tip.getAnchor() == null && !tip.isPreferredPositionSetted() && tip.getLayoutGravity() == -1;
    }

    private void layoutTip(ZMTip tip, int width, int height) {
        View anchor = tip.getAnchor();
        if (anchor != null) {
            Rect rcAnchor = this.getAbsoluteRect(anchor);
            int l = 0;
            int t = 0;
            int r = 0;
            int b = 0;
            switch (tip.getArrowDirection()) {
                case 0: 
                case 2: {
                    b = rcAnchor.centerY() + tip.getMeasuredHeight() / 2;
                    if (b > height) {
                        b = height;
                    }
                    if ((t = b - tip.getMeasuredHeight()) < 0) {
                        b -= t;
                        t = 0;
                    }
                    l = tip.getArrowDirection() == 0 ? rcAnchor.right + tip.getDistanceToAnchor() : rcAnchor.left - tip.getMeasuredWidth() - tip.getDistanceToAnchor();
                    r = l + tip.getMeasuredWidth();
                    break;
                }
                case 1: 
                case 3: {
                    r = rcAnchor.centerX() + tip.getMeasuredWidth() / 2;
                    if (r > width) {
                        r = width;
                    }
                    if ((l = r - tip.getMeasuredWidth()) < 0) {
                        r -= l;
                        l = 0;
                    }
                    t = tip.getArrowDirection() == 1 ? rcAnchor.bottom + tip.getDistanceToAnchor() : rcAnchor.top - tip.getMeasuredHeight() - tip.getDistanceToAnchor();
                    b = t + tip.getMeasuredHeight();
                }
            }
            tip.layout(l, t, r, b);
        } else if (tip.isPreferredPositionSetted()) {
            int l = tip.getPreferredX();
            int t = tip.getPreferredY();
            int r = l + tip.getMeasuredWidth();
            int b = t + tip.getMeasuredHeight();
            tip.layout(l, t, r, b);
        } else if (tip.getLayoutGravity() != -1) {
            int parentWidth = this.getMeasuredWidth();
            int parentHeight = this.getMeasuredHeight();
            int childWidth = tip.getMeasuredWidth();
            int childHeight = tip.getMeasuredHeight();
            int padding = tip.getLayoutGravityPadding();
            int l = 0;
            int t = 0;
            switch (tip.getLayoutGravity()) {
                case 3: {
                    l = (parentWidth - childWidth) / 2;
                    t = parentHeight - padding - childHeight;
                    break;
                }
                case 0: {
                    l = padding;
                    t = (parentHeight - childHeight) / 2;
                    break;
                }
                case 1: {
                    l = parentWidth - padding - childWidth;
                    t = (parentHeight - childHeight) / 2;
                    break;
                }
                case 2: {
                    l = (parentWidth - childWidth) / 2;
                    t = padding;
                    break;
                }
            }
            int r = l + tip.getMeasuredWidth();
            int b = t + tip.getMeasuredHeight();
            tip.layout(l, t, r, b);
        } else {
            Rect rc;
            switch (tip.getOverlyingType()) {
                case 1: {
                    rc = this.getPreferredRectForNonPositionedTipFromBottom(tip, width, height);
                    break;
                }
                case 0: {
                    rc = this.getPreferredRectForNonPositionedTipFromCenter(tip, width, height);
                    break;
                }
                default: {
                    rc = this.getPreferredRectForNonPositionedTipFromCenter(tip, width, height);
                }
            }
            tip.layout(rc.left, rc.top, rc.right, rc.bottom);
        }
    }

    private Rect getPreferredRectForNonPositionedTipFromBottom(ZMTip tip, int width, int height) {
        int b = height - tip.getMeasuredHeight() / 2;
        int gap = UIUtil.dip2px(this.getContext(), 2.0f);
        int childCount = this.getChildCount();
        boolean foundThisTip = false;
        if (this.isNonPositionedTip(tip)) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (child == tip) {
                    foundThisTip = true;
                    continue;
                }
                if (!foundThisTip || !(child instanceof ZMTip) || !this.isNonPositionedTip((ZMTip)child)) continue;
                b -= child.getMeasuredHeight() + gap;
            }
        }
        int l = (width - tip.getMeasuredWidth()) / 2;
        if (b < 0) {
            b = tip.getMeasuredHeight();
        }
        int r = l + tip.getMeasuredWidth();
        int t = b - tip.getMeasuredHeight();
        return new Rect(l, t, r, b);
    }

    private Rect getPreferredRectForNonPositionedTipFromCenter(ZMTip tip, int width, int height) {
        int t = height * 2 / 3 - tip.getMeasuredHeight();
        int gap = UIUtil.dip2px(this.getContext(), 2.0f);
        int childCount = this.getChildCount();
        boolean foundThisTip = false;
        if (this.isNonPositionedTip(tip)) {
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (child == tip) {
                    foundThisTip = true;
                    continue;
                }
                if (!foundThisTip || !(child instanceof ZMTip) || !this.isNonPositionedTip((ZMTip)child)) continue;
                t -= child.getMeasuredHeight() + gap;
            }
        }
        int l = (width - tip.getMeasuredWidth()) / 2;
        if (t < 0) {
            t = 0;
        }
        int r = l + tip.getMeasuredWidth();
        int b = t + tip.getMeasuredHeight();
        return new Rect(l, t, r, b);
    }

    private Rect getAbsoluteRect(View v) {
        Rect rectV = UIUtil.getAbsoluteRect(v);
        Rect rectSelf = UIUtil.getAbsoluteRect((View)this);
        rectV.offset(-rectSelf.left, -rectSelf.top);
        return rectV;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof ZMTip)) continue;
            this.measureTip((ZMTip)child, width, height);
        }
    }

    private void measureTip(ZMTip tip, int width, int height) {
        View child;
        ViewGroup.LayoutParams params;
        View anchor = tip.getAnchor();
        int maxWidth = width;
        int maxHeight = height;
        if (anchor != null) {
            Rect rcAnchor = this.getAbsoluteRect(anchor);
            switch (tip.getArrowDirection()) {
                case 0: {
                    maxWidth = width - rcAnchor.right;
                    maxHeight = height;
                    break;
                }
                case 1: {
                    maxWidth = width;
                    maxHeight = height - rcAnchor.bottom;
                    break;
                }
                case 2: {
                    maxWidth = rcAnchor.left;
                    maxHeight = height;
                    break;
                }
                case 3: {
                    maxWidth = width;
                    maxHeight = rcAnchor.top;
                }
            }
        } else if (tip.isPreferredPositionSetted()) {
            int posX = tip.getPreferredX();
            int posY = tip.getPreferredY();
            maxHeight = height - posY;
            maxWidth = width - posX;
        } else {
            maxWidth = width;
            maxHeight = height;
        }
        boolean matchParentVertical = false;
        boolean matchParentHorizontal = false;
        if (tip.getChildCount() == 1 && (params = (child = tip.getChildAt(0)).getLayoutParams()) != null) {
            matchParentHorizontal = params.width == -1;
            matchParentVertical = params.height == -1;
        }
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)(matchParentHorizontal ? 0x40000000 : Integer.MIN_VALUE));
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)maxHeight, (int)(matchParentVertical ? 0x40000000 : Integer.MIN_VALUE));
        tip.measure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean dismissAllTips() {
        boolean ret = false;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (!(child instanceof ZMTip)) continue;
            ((ZMTip)child).dismiss();
            ret = true;
        }
        return ret;
    }
}

