/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.text.Spannable;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.widget.TextView;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZMTextViewWithImages
extends TextView {
    private static final Spannable.Factory spannableFactory = Spannable.Factory.getInstance();

    public ZMTextViewWithImages(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public ZMTextViewWithImages(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ZMTextViewWithImages(Context context) {
        super(context);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        Spannable s = ZMTextViewWithImages.getTextWithImages(this.getContext(), text);
        super.setText((CharSequence)s, TextView.BufferType.SPANNABLE);
    }

    private static boolean addImages(Context context, Spannable spannable) {
        Pattern refImg = Pattern.compile("\\Q[img src=\\E([a-zA-Z0-9_]+?)\\Q/]\\E");
        boolean hasChanges = false;
        Matcher matcher = refImg.matcher((CharSequence)spannable);
        while (matcher.find()) {
            boolean set = true;
            for (ImageSpan span : (ImageSpan[])spannable.getSpans(matcher.start(), matcher.end(), ImageSpan.class)) {
                if (spannable.getSpanStart((Object)span) < matcher.start() || spannable.getSpanEnd((Object)span) > matcher.end()) {
                    set = false;
                    break;
                }
                spannable.removeSpan((Object)span);
            }
            String resName = spannable.subSequence(matcher.start(1), matcher.end(1)).toString().trim();
            int id2 = context.getResources().getIdentifier(resName, "drawable", context.getPackageName());
            if (!set) continue;
            hasChanges = true;
            spannable.setSpan((Object)new ImageSpan(context, id2), matcher.start(), matcher.end(), 33);
        }
        return hasChanges;
    }

    private static Spannable getTextWithImages(Context context, CharSequence text) {
        Spannable spannable = spannableFactory.newSpannable(text);
        ZMTextViewWithImages.addImages(context, spannable);
        return spannable;
    }
}

