/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import us.zoom.androidlib.R;

public class ZMSettingsCategory
extends LinearLayout {
    private boolean mbShowTopDivider = true;
    private boolean mbShowBottomDivider = true;
    private boolean mbShowCenterDivider = true;
    private Drawable mDrawableTopDivider = null;
    private Drawable mDrawableCenterDivider = null;
    private Drawable mDrawableBottomDivider = null;
    private Drawable mBackground = null;
    private int mBackgroundColor = 0;
    private boolean mHasBackground = false;
    private int mTopDividerHeight = 1;
    private int mCenterDividerHeight = 1;
    private int mBottomDividerHeight = 1;
    private int mMinItemHeight = 0;
    private int mResDrawableSettingsItemSelector = R.drawable.zm_setting_option_item_no_line;

    public ZMSettingsCategory(Context context) {
        super(context);
        this.initView(context, null, 0);
    }

    public ZMSettingsCategory(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0);
    }

    @SuppressLint(value={"NewApi"})
    public ZMSettingsCategory(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context, attrs, defStyle);
    }

    private void initView(Context context, AttributeSet attrs, int defStyle) {
        Drawable drawable2;
        TypedArray attrFromStyle;
        if (context == null) {
            return;
        }
        int dividerHeight = -1;
        Resources.Theme theme = context.getTheme();
        TypedArray defAttrs = theme.obtainStyledAttributes(attrs, R.styleable.ZMSettingsCategory, R.attr.zm_settingsCategoryAppearance, 0);
        if (defAttrs != null) {
            this.mbShowTopDivider = defAttrs.getBoolean(R.styleable.ZMSettingsCategory_zm_showTopDivider, this.mbShowTopDivider);
            this.mbShowBottomDivider = defAttrs.getBoolean(R.styleable.ZMSettingsCategory_zm_showBottomDivider, this.mbShowBottomDivider);
            this.mbShowCenterDivider = defAttrs.getBoolean(R.styleable.ZMSettingsCategory_zm_showCenterDivider, this.mbShowCenterDivider);
            this.mResDrawableSettingsItemSelector = defAttrs.getResourceId(R.styleable.ZMSettingsCategory_zm_settingsItemSelector, this.mResDrawableSettingsItemSelector);
            this.mDrawableTopDivider = defAttrs.getDrawable(R.styleable.ZMSettingsCategory_zm_topDivider);
            this.mDrawableCenterDivider = defAttrs.getDrawable(R.styleable.ZMSettingsCategory_zm_centerDivider);
            this.mDrawableBottomDivider = defAttrs.getDrawable(R.styleable.ZMSettingsCategory_zm_bottomDivider);
            this.mMinItemHeight = defAttrs.getDimensionPixelSize(R.styleable.ZMSettingsCategory_zm_seetingsItemMinHeight, this.mMinItemHeight);
            if (defAttrs.hasValue(R.styleable.ZMSettingsCategory_zm_settingsCategoryBackground)) {
                this.mHasBackground = true;
                this.mBackground = defAttrs.getDrawable(R.styleable.ZMSettingsCategory_zm_settingsCategoryBackground);
                this.mBackgroundColor = defAttrs.getColor(R.styleable.ZMSettingsCategory_zm_settingsCategoryBackground, this.mBackgroundColor);
            }
            dividerHeight = defAttrs.getDimensionPixelSize(R.styleable.ZMSettingsCategory_zm_dividerHeight, dividerHeight);
            defAttrs.recycle();
            defAttrs = null;
        }
        if (defStyle > 0 && (attrFromStyle = context.obtainStyledAttributes(attrs, R.styleable.ZMSettingsCategory, defStyle, 0)) != null) {
            this.mbShowTopDivider = attrFromStyle.getBoolean(R.styleable.ZMSettingsCategory_zm_showTopDivider, this.mbShowTopDivider);
            this.mbShowBottomDivider = attrFromStyle.getBoolean(R.styleable.ZMSettingsCategory_zm_showBottomDivider, this.mbShowBottomDivider);
            this.mbShowCenterDivider = attrFromStyle.getBoolean(R.styleable.ZMSettingsCategory_zm_showCenterDivider, this.mbShowCenterDivider);
            this.mResDrawableSettingsItemSelector = attrFromStyle.getResourceId(R.styleable.ZMSettingsCategory_zm_settingsItemSelector, this.mResDrawableSettingsItemSelector);
            this.mMinItemHeight = attrFromStyle.getDimensionPixelSize(R.styleable.ZMSettingsCategory_zm_seetingsItemMinHeight, this.mMinItemHeight);
            if (attrFromStyle.hasValue(R.styleable.ZMSettingsCategory_zm_settingsCategoryBackground)) {
                this.mHasBackground = true;
                this.mBackground = attrFromStyle.getDrawable(R.styleable.ZMSettingsCategory_zm_settingsCategoryBackground);
                this.mBackgroundColor = attrFromStyle.getColor(R.styleable.ZMSettingsCategory_zm_settingsCategoryBackground, this.mBackgroundColor);
            }
            dividerHeight = attrFromStyle.getDimensionPixelSize(R.styleable.ZMSettingsCategory_zm_dividerHeight, dividerHeight);
            drawable2 = attrFromStyle.getDrawable(R.styleable.ZMSettingsCategory_zm_topDivider);
            if (drawable2 != null) {
                this.mDrawableTopDivider = drawable2;
            }
            if ((drawable2 = attrFromStyle.getDrawable(R.styleable.ZMSettingsCategory_zm_centerDivider)) != null) {
                this.mDrawableCenterDivider = drawable2;
            }
            if ((drawable2 = attrFromStyle.getDrawable(R.styleable.ZMSettingsCategory_zm_bottomDivider)) != null) {
                this.mDrawableBottomDivider = drawable2;
            }
            attrFromStyle.recycle();
        }
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ZMSettingsCategory);
            this.mbShowTopDivider = a.getBoolean(R.styleable.ZMSettingsCategory_zm_showTopDivider, this.mbShowTopDivider);
            this.mbShowBottomDivider = a.getBoolean(R.styleable.ZMSettingsCategory_zm_showBottomDivider, this.mbShowBottomDivider);
            this.mbShowCenterDivider = a.getBoolean(R.styleable.ZMSettingsCategory_zm_showCenterDivider, this.mbShowCenterDivider);
            this.mResDrawableSettingsItemSelector = a.getResourceId(R.styleable.ZMSettingsCategory_zm_settingsItemSelector, this.mResDrawableSettingsItemSelector);
            this.mMinItemHeight = a.getDimensionPixelSize(R.styleable.ZMSettingsCategory_zm_seetingsItemMinHeight, this.mMinItemHeight);
            if (a.hasValue(R.styleable.ZMSettingsCategory_zm_settingsCategoryBackground)) {
                this.mHasBackground = true;
                this.mBackground = a.getDrawable(R.styleable.ZMSettingsCategory_zm_settingsCategoryBackground);
                this.mBackgroundColor = a.getColor(R.styleable.ZMSettingsCategory_zm_settingsCategoryBackground, this.mBackgroundColor);
            }
            dividerHeight = a.getDimensionPixelSize(R.styleable.ZMSettingsCategory_zm_dividerHeight, dividerHeight);
            drawable2 = a.getDrawable(R.styleable.ZMSettingsCategory_zm_topDivider);
            if (drawable2 != null) {
                this.mDrawableTopDivider = drawable2;
            }
            if ((drawable2 = a.getDrawable(R.styleable.ZMSettingsCategory_zm_centerDivider)) != null) {
                this.mDrawableCenterDivider = drawable2;
            }
            if ((drawable2 = a.getDrawable(R.styleable.ZMSettingsCategory_zm_bottomDivider)) != null) {
                this.mDrawableBottomDivider = drawable2;
            }
            a.recycle();
        }
        if (this.mDrawableTopDivider == null) {
            this.mDrawableTopDivider = this.getResources().getDrawable(R.drawable.zm_settings_top_divider);
        }
        if (this.mDrawableCenterDivider == null) {
            this.mDrawableCenterDivider = this.getResources().getDrawable(R.drawable.zm_settings_center_divider);
        }
        if (this.mDrawableBottomDivider == null) {
            this.mDrawableBottomDivider = this.getResources().getDrawable(R.drawable.zm_settings_bottom_divider);
        }
        if (dividerHeight == 0) {
            this.mbShowTopDivider = false;
            this.mbShowCenterDivider = false;
            this.mbShowBottomDivider = false;
        } else if (dividerHeight > 0) {
            this.mTopDividerHeight = dividerHeight;
            this.mCenterDividerHeight = dividerHeight;
            this.mBottomDividerHeight = dividerHeight;
        } else {
            if (this.mDrawableTopDivider != null) {
                this.mTopDividerHeight = this.mDrawableTopDivider.getIntrinsicHeight();
            }
            if (this.mDrawableCenterDivider != null) {
                this.mCenterDividerHeight = this.mDrawableCenterDivider.getIntrinsicHeight();
            }
            if (this.mDrawableBottomDivider != null) {
                this.mBottomDividerHeight = this.mDrawableBottomDivider.getIntrinsicHeight();
            }
        }
        if (this.isInEditMode()) {
            if (this.mTopDividerHeight < 2 && this.mDrawableTopDivider != null) {
                this.mTopDividerHeight = 2;
            }
            if (this.mCenterDividerHeight < 2 && this.mDrawableCenterDivider != null) {
                this.mCenterDividerHeight = 2;
            }
            if (this.mBottomDividerHeight < 2 && this.mDrawableBottomDivider != null) {
                this.mBottomDividerHeight = 2;
            }
        }
        if (this.mHasBackground) {
            if (this.mBackground != null) {
                this.setBackgroundDrawable(this.mBackground);
            } else {
                this.setBackgroundColor(this.mBackgroundColor);
            }
            this.setPadding(0, 0, 0, 0);
        }
        this.setWillNotDraw(false);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int itemCount = 0;
        int count = this.getChildCount();
        View lastChild = null;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0) continue;
            if (lastChild != null) {
                int paddingLeft = lastChild.getPaddingLeft();
                int paddingTop = lastChild.getPaddingTop();
                int paddingRight = lastChild.getPaddingRight();
                int paddingBottom = lastChild.getPaddingBottom();
                lastChild.setBackgroundResource(this.mResDrawableSettingsItemSelector);
                lastChild.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
                LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)lastChild.getLayoutParams();
                params.topMargin = itemCount == 1 && this.mbShowTopDivider && this.mDrawableTopDivider != null ? this.mTopDividerHeight : (itemCount > 1 && this.mbShowCenterDivider && this.mDrawableCenterDivider != null ? this.mCenterDividerHeight : 0);
                lastChild.setLayoutParams((ViewGroup.LayoutParams)params);
                lastChild.setMinimumHeight(this.mMinItemHeight);
            }
            ++itemCount;
            lastChild = child;
        }
        if (lastChild != null) {
            int paddingLeft = lastChild.getPaddingLeft();
            int paddingTop = lastChild.getPaddingTop();
            int paddingRight = lastChild.getPaddingRight();
            int paddingBottom = lastChild.getPaddingBottom();
            lastChild.setBackgroundResource(this.mResDrawableSettingsItemSelector);
            lastChild.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)lastChild.getLayoutParams();
            params.topMargin = itemCount == 1 && this.mbShowTopDivider && this.mDrawableTopDivider != null ? this.mTopDividerHeight : (itemCount > 1 && this.mbShowCenterDivider && this.mDrawableCenterDivider != null ? this.mCenterDividerHeight : 0);
            params.bottomMargin = this.mbShowBottomDivider && this.mDrawableBottomDivider != null ? this.mBottomDividerHeight : 0;
            lastChild.setLayoutParams((ViewGroup.LayoutParams)params);
            lastChild.setMinimumHeight(this.mMinItemHeight);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int itemCount = 0;
        int count = this.getChildCount();
        View lastChild = null;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0) continue;
            if (lastChild != null) {
                LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)lastChild.getLayoutParams();
                int l = lastChild.getLeft();
                int r = lastChild.getRight();
                int b = lastChild.getTop();
                int t = b - params.topMargin;
                if (itemCount == 1 && this.mbShowTopDivider) {
                    this.drawTopDivider(canvas, l, t, r, b);
                } else if (itemCount > 1 && this.mbShowCenterDivider) {
                    this.drawCenterDivider(canvas, l, t, r, b);
                }
            }
            ++itemCount;
            lastChild = child;
        }
        if (lastChild != null) {
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)lastChild.getLayoutParams();
            int l = lastChild.getLeft();
            int r = lastChild.getRight();
            int b = lastChild.getTop();
            int t = b - params.topMargin;
            if (itemCount == 1 && this.mbShowTopDivider) {
                this.drawTopDivider(canvas, l, t, r, b);
            } else if (itemCount > 1 && this.mbShowCenterDivider) {
                this.drawCenterDivider(canvas, l, t, r, b);
            }
            if (this.mbShowBottomDivider) {
                t = lastChild.getBottom();
                b = t + params.bottomMargin;
                this.drawBottomDivider(canvas, l, t, r, b);
            }
        }
    }

    private void drawTopDivider(Canvas canvas, int left, int top, int right, int bottom) {
        if (this.mDrawableTopDivider != null) {
            this.mDrawableTopDivider.setBounds(left, top, right, bottom);
            this.mDrawableTopDivider.draw(canvas);
        }
    }

    private void drawCenterDivider(Canvas canvas, int left, int top, int right, int bottom) {
        if (this.mDrawableCenterDivider != null) {
            this.mDrawableCenterDivider.setBounds(left, top, right, bottom);
            this.mDrawableCenterDivider.draw(canvas);
        }
    }

    private void drawBottomDivider(Canvas canvas, int left, int top, int right, int bottom) {
        if (this.mDrawableBottomDivider != null) {
            this.mDrawableBottomDivider.setBounds(left, top, right, bottom);
            this.mDrawableBottomDivider.draw(canvas);
        }
    }
}

