/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.PopupWindow;

public class ZMPopupWindow
extends PopupWindow {
    private boolean mbDismissOnTouchOutside = false;

    public ZMPopupWindow() {
        this.init();
    }

    public ZMPopupWindow(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    public ZMPopupWindow(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public ZMPopupWindow(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ZMPopupWindow(Context context) {
        super(context);
        this.init();
    }

    public ZMPopupWindow(int width, int height) {
        super(width, height);
        this.init();
    }

    public ZMPopupWindow(View contentView, int width, int height, boolean focusable) {
        super(contentView, width, height, focusable);
        this.init();
    }

    public ZMPopupWindow(View contentView, int width, int height) {
        super(contentView, width, height);
        this.init();
    }

    public ZMPopupWindow(View contentView) {
        super(contentView);
        this.init();
    }

    private void init() {
        this.setOutsideTouchable(true);
        this.setFocusable(true);
        this.setBackgroundDrawable((Drawable)new BitmapDrawable());
        this.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (ZMPopupWindow.this.mbDismissOnTouchOutside && ZMPopupWindow.this.isOutside(event)) {
                    ZMPopupWindow.this.dismiss();
                }
                return false;
            }
        });
    }

    public void setDismissOnTouchOutside(boolean dismiss) {
        this.mbDismissOnTouchOutside = dismiss;
    }

    private boolean isOutside(MotionEvent event) {
        if (event == null) {
            return false;
        }
        View contentView = this.getContentView();
        if (contentView == null) {
            return false;
        }
        float x = event.getX();
        float y = event.getY();
        float w = contentView.getWidth();
        float h = contentView.getHeight();
        return x < 0.0f || x > w || y < 0.0f || y > h;
    }
}

