/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import us.zoom.androidlib.R;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMMenuListView;
import us.zoom.androidlib.widget.ZMPopupWindow;

public class ZMPopupMenu {
    private OnMenuItemClickListener mMenuItemClickListener;
    private OnDismissListener mDismissListener;
    private Context mContext;
    private View mAnchor;
    private ZMMenuAdapter<?> mMenuAdapter;
    private ZMPopupWindow mPopup;
    private View mContentView;
    private ZMMenuListView mMenuListView;

    public ZMPopupMenu(Context context, ZMMenuAdapter<?> menuAdapter, View anchor, int maxWith) {
        this.mContext = context;
        this.mAnchor = anchor;
        this.mMenuAdapter = menuAdapter;
        LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
        this.mContentView = inflater.inflate(R.layout.zm_popup_menu, null);
        this.mMenuListView = (ZMMenuListView)this.mContentView.findViewById(R.id.menuListView);
        if (this.mMenuAdapter != null) {
            this.mMenuListView.setAdapter((ListAdapter)this.mMenuAdapter);
        }
        this.mMenuListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Object oItem = ZMPopupMenu.this.mMenuAdapter.getItem(position);
                if (oItem instanceof IZMMenuItem) {
                    IZMMenuItem item = (IZMMenuItem)oItem;
                    ZMPopupMenu.this.onMenuItemClick(item);
                }
            }
        });
        int width = 0;
        if (this.mMenuAdapter != null) {
            width = ZMPopupMenu.getWidestView(this.mContext, this.mMenuAdapter) + this.mMenuListView.getPaddingLeft() + this.mMenuListView.getPaddingRight() + this.mContentView.getPaddingLeft() + this.mContentView.getPaddingRight();
        }
        if (maxWith > 0 && width > maxWith) {
            width = maxWith;
        }
        this.mPopup = new ZMPopupWindow(this.mContentView, width, -2, false);
        this.mPopup.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (ZMPopupMenu.this.mDismissListener != null) {
                    ZMPopupMenu.this.mDismissListener.onDismiss(ZMPopupMenu.this);
                }
            }
        });
    }

    public ZMPopupMenu(Context context, ZMMenuAdapter<?> menuAdapter, View anchor) {
        this(context, menuAdapter, anchor, -1);
    }

    private static int getWidestView(Context context, Adapter adapter) {
        int maxWidth = 0;
        View view = null;
        FrameLayout fakeParent = new FrameLayout(context);
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            view = adapter.getView(i, view, (ViewGroup)fakeParent);
            view.measure(0, 0);
            int width = view.getMeasuredWidth();
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    public void show() {
        this.mPopup.showAsDropDown(this.mAnchor);
    }

    public void dismiss() {
        this.mPopup.dismiss();
    }

    public void setOnMenuItemClickListener(OnMenuItemClickListener listener) {
        this.mMenuItemClickListener = listener;
    }

    public void setOnDismissListener(OnDismissListener listener) {
        this.mDismissListener = listener;
    }

    private void onMenuItemClick(IZMMenuItem item) {
        if (this.mMenuItemClickListener != null) {
            this.mMenuItemClickListener.onMenuItemClick(item);
        }
        this.dismiss();
    }

    public static interface OnMenuItemClickListener {
        public void onMenuItemClick(IZMMenuItem var1);
    }

    public static interface OnDismissListener {
        public void onDismiss(ZMPopupMenu var1);
    }
}

