/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import us.zoom.androidlib.util.UIUtil;

public class ZMMenuLayout
extends ViewGroup {
    public ZMMenuLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public ZMMenuLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ZMMenuLayout(Context context) {
        super(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View child;
        int i;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthParent = View.MeasureSpec.getSize((int)widthMeasureSpec) - paddingLeft - paddingRight;
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightParent = View.MeasureSpec.getSize((int)heightMeasureSpec) - paddingTop - paddingBottom;
        if (heightParent == 0) {
            heightParent = UIUtil.getDisplayHeight(this.getContext());
        }
        int count = this.getChildCount();
        int maxWidth = 0;
        int totalHeight = 0;
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            ViewGroup.LayoutParams params = child.getLayoutParams();
            int widthSpec = 0;
            int heightSpec = 0;
            widthSpec = params.width == -2 ? View.MeasureSpec.makeMeasureSpec((int)widthParent, (int)Integer.MIN_VALUE) : (params.width == -1 ? View.MeasureSpec.makeMeasureSpec((int)widthParent, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)params.width, (int)0x40000000));
            heightSpec = params.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)heightParent, (int)Integer.MIN_VALUE) : (params.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)heightParent, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)params.height, (int)0x40000000));
            this.measureChild(child, widthSpec, heightSpec);
            int width = child.getMeasuredWidth();
            maxWidth = maxWidth > width ? maxWidth : width;
        }
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            child.measure(View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000));
            int height = child.getMeasuredHeight();
            totalHeight += height;
        }
        this.setMeasuredDimension((widthMode == 0x40000000 ? widthParent : maxWidth) + paddingLeft + paddingRight, (heightMode == 0x40000000 ? heightParent : totalHeight) + paddingTop + paddingBottom);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int yOffset = this.getPaddingTop();
        int left = this.getPaddingLeft();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int top = yOffset;
            int right = left + child.getMeasuredWidth();
            int bottom = top + child.getMeasuredHeight();
            child.layout(left, top, right, bottom);
            yOffset = bottom;
        }
    }
}

