/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.CheckedTextView;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.R;
import us.zoom.androidlib.widget.IZMMenuItem;

public class ZMMenuAdapter<MenuItemType extends IZMMenuItem>
extends BaseAdapter {
    private Context mContext;
    private List<MenuItemType> mList = new ArrayList<MenuItemType>();
    private boolean mShowIcon = false;
    private boolean mShowSelectStatus = false;

    public ZMMenuAdapter(Context context, boolean showIcon) {
        this.mContext = context;
        this.mShowIcon = showIcon;
    }

    public void setShowSelectedStatus(boolean show) {
        this.mShowSelectStatus = show;
    }

    public int getCount() {
        return this.mList.size();
    }

    public Object getItem(int position) {
        return this.mList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void addAll(MenuItemType ... items) {
        for (MenuItemType item : items) {
            this.addItem(item);
        }
    }

    public void addAll(List<MenuItemType> items) {
        for (IZMMenuItem item : items) {
            this.addItem(item);
        }
    }

    public void addItem(MenuItemType item) {
        this.mList.add(item);
    }

    public void clear() {
        this.mList.clear();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            convertView = inflater.inflate(R.layout.zm_menu_item, parent, false);
        }
        CheckedTextView check = (CheckedTextView)convertView.findViewById(R.id.check);
        ImageView imgIcon = (ImageView)convertView.findViewById(R.id.imgIcon);
        TextView txtLabel = (TextView)convertView.findViewById(R.id.txtLabel);
        IZMMenuItem item = (IZMMenuItem)this.mList.get(position);
        if (item == null) {
            return null;
        }
        txtLabel.setText((CharSequence)item.getLabel());
        if (this.mShowIcon) {
            imgIcon.setVisibility(0);
            Drawable drawable2 = item.getIcon();
            imgIcon.setImageDrawable(drawable2);
        } else {
            imgIcon.setVisibility(8);
        }
        if (this.mShowSelectStatus) {
            check.setVisibility(0);
            check.setChecked(item.isSelected());
        } else {
            check.setVisibility(8);
        }
        return convertView;
    }
}

