/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import us.zoom.androidlib.util.UIUtil;

public class ZMKeyboardDetector
extends View {
    private KeyboardListener mListener;
    private boolean mKeyboardOpen = false;
    private boolean mbFirstMeasure = true;
    private int mKeyboardHeight = 0;

    public ZMKeyboardDetector(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public ZMKeyboardDetector(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ZMKeyboardDetector(Context context) {
        super(context);
    }

    public boolean isKeyboardOpen() {
        return this.mKeyboardOpen;
    }

    public void setKeyboardListener(KeyboardListener l) {
        this.mListener = l;
    }

    public int getKeyboardHeight() {
        if (!this.mKeyboardOpen || this.mKeyboardHeight == 0) {
            return 0;
        }
        return this.mKeyboardHeight;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int displayHeight;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mListener == null) {
            return;
        }
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (height < (displayHeight = this.getResources().getDisplayMetrics().heightPixels) - UIUtil.dip2px(this.getContext(), 100.0f)) {
            if (!this.mKeyboardOpen || this.mbFirstMeasure) {
                Rect rect = new Rect();
                this.getGlobalVisibleRect(rect);
                this.mKeyboardHeight = displayHeight - rect.bottom;
                if (this.mKeyboardHeight == 0) {
                    this.mKeyboardHeight = displayHeight - height - rect.top;
                }
                this.mKeyboardOpen = true;
                this.mListener.onKeyboardOpen();
            }
        } else if (this.mKeyboardOpen || this.mbFirstMeasure) {
            this.mKeyboardOpen = false;
            this.mListener.onKeyboardClosed();
        }
        this.mbFirstMeasure = false;
    }

    public static interface KeyboardListener {
        public void onKeyboardOpen();

        public void onKeyboardClosed();
    }
}

