/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageButton;

public class ZMImageButton
extends ImageButton {
    private View.OnClickListener mOnClickListener;

    public ZMImageButton(Context context) {
        super(context);
    }

    public ZMImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ZMImageButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        super.setOnClickListener(new View.OnClickListener(){
            private long mLastClickTime = 0L;

            public void onClick(View view) {
                if (ZMImageButton.this.mOnClickListener == null) {
                    return;
                }
                long curTime = SystemClock.elapsedRealtime();
                if (curTime - this.mLastClickTime > 500L) {
                    ZMImageButton.this.mOnClickListener.onClick(view);
                }
                this.mLastClickTime = curTime;
            }
        });
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.mOnClickListener = l;
    }
}

