/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import us.zoom.androidlib.util.UIUtil;

public class ZMIgnoreKeyboardLayout
extends LinearLayout {
    private int mLastHeight = 0;
    private boolean mbIgnoreKeyboardOpen = true;

    public ZMIgnoreKeyboardLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ZMIgnoreKeyboardLayout(Context context) {
        super(context);
    }

    public void setIgnoreKeyboardOpen(boolean ignore) {
        this.mbIgnoreKeyboardOpen = ignore;
    }

    public boolean getIsIgnoreKeyboardOpen() {
        return this.mbIgnoreKeyboardOpen;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int displayHeight;
        if (!this.getIsIgnoreKeyboardOpen()) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (height < (displayHeight = this.getResources().getDisplayMetrics().heightPixels) - UIUtil.dip2px(this.getContext(), 100.0f)) {
            height = this.mLastHeight;
            if (this.mLastHeight == 0) {
                height = displayHeight;
            }
        } else {
            this.mLastHeight = height;
        }
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)mode);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

