/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.Scroller;
import java.util.LinkedList;
import java.util.Queue;

public class ZMHorizontalListView
extends AdapterView<ListAdapter> {
    public boolean mAlwaysOverrideTouch = true;
    protected ListAdapter mAdapter;
    private int mLeftViewIndex = -1;
    private int mRightViewIndex = 0;
    protected int mCurrentX;
    protected int mNextX;
    private int mMaxX = Integer.MAX_VALUE;
    private int mDisplayOffset = 0;
    protected Scroller mScroller;
    private GestureDetector mGesture;
    private Queue<View> mRemovedViewQueue = new LinkedList<View>();
    private AdapterView.OnItemSelectedListener mOnItemSelected;
    private AdapterView.OnItemClickListener mOnItemClicked;
    private boolean mDataChanged = false;
    private DataSetObserver mDataObserver = new DataSetObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChanged() {
            ZMHorizontalListView zMHorizontalListView = ZMHorizontalListView.this;
            synchronized (zMHorizontalListView) {
                ZMHorizontalListView.this.mDataChanged = true;
            }
            ZMHorizontalListView.this.invalidate();
            ZMHorizontalListView.this.requestLayout();
        }

        public void onInvalidated() {
            ZMHorizontalListView.this.reset();
            ZMHorizontalListView.this.invalidate();
            ZMHorizontalListView.this.requestLayout();
        }
    };
    private Runnable mRelayoutRunnable = new Runnable(){

        @Override
        public void run() {
            ZMHorizontalListView.this.requestLayout();
        }
    };
    private GestureDetector.OnGestureListener mOnGesture = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent e) {
            return ZMHorizontalListView.this.onDown(e);
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return ZMHorizontalListView.this.onFling(e1, e2, velocityX, velocityY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            ZMHorizontalListView zMHorizontalListView = ZMHorizontalListView.this;
            synchronized (zMHorizontalListView) {
                ZMHorizontalListView.this.mNextX += (int)distanceX;
            }
            ZMHorizontalListView.this.requestLayout();
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            Rect viewRect = new Rect();
            for (int i = 0; i < ZMHorizontalListView.this.getChildCount(); ++i) {
                View child = ZMHorizontalListView.this.getChildAt(i);
                int left = child.getLeft();
                int right = child.getRight();
                int top = child.getTop();
                int bottom = child.getBottom();
                viewRect.set(left, top, right, bottom);
                if (!viewRect.contains((int)e.getX(), (int)e.getY())) continue;
                if (ZMHorizontalListView.this.mOnItemClicked != null) {
                    ZMHorizontalListView.this.mOnItemClicked.onItemClick((AdapterView)ZMHorizontalListView.this, child, ZMHorizontalListView.this.mLeftViewIndex + 1 + i, ZMHorizontalListView.this.mAdapter.getItemId(ZMHorizontalListView.this.mLeftViewIndex + 1 + i));
                }
                if (ZMHorizontalListView.this.mOnItemSelected == null) break;
                ZMHorizontalListView.this.mOnItemSelected.onItemSelected((AdapterView)ZMHorizontalListView.this, child, ZMHorizontalListView.this.mLeftViewIndex + 1 + i, ZMHorizontalListView.this.mAdapter.getItemId(ZMHorizontalListView.this.mLeftViewIndex + 1 + i));
                break;
            }
            return true;
        }
    };

    public ZMHorizontalListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    private synchronized void initView() {
        this.mLeftViewIndex = -1;
        this.mRightViewIndex = 0;
        this.mDisplayOffset = 0;
        this.mCurrentX = 0;
        this.mNextX = 0;
        this.mMaxX = Integer.MAX_VALUE;
        this.mScroller = new Scroller(this.getContext());
        if (!this.isInEditMode()) {
            this.mGesture = new GestureDetector(this.getContext(), this.mOnGesture);
        }
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
        this.mOnItemSelected = listener;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mOnItemClicked = listener;
    }

    public ListAdapter getAdapter() {
        return this.mAdapter;
    }

    public View getSelectedView() {
        return null;
    }

    public void setAdapter(ListAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataObserver);
        }
        this.mAdapter = adapter;
        this.mAdapter.registerDataSetObserver(this.mDataObserver);
        this.reset();
    }

    private synchronized void reset() {
        this.initView();
        this.removeAllViewsInLayout();
        this.requestLayout();
    }

    public void setSelection(int position) {
    }

    private void addAndMeasureChild(View child, int viewPos) {
        ViewGroup.LayoutParams params = child.getLayoutParams();
        if (params == null) {
            params = new ViewGroup.LayoutParams(-1, -1);
        }
        this.addViewInLayout(child, viewPos, params, true);
        int widthMeasureSpec = 0;
        int heightMeasureSpec = 0;
        widthMeasureSpec = params.width == -1 || params.width == -2 ? View.MeasureSpec.makeMeasureSpec((int)this.getWidth(), (int)Integer.MIN_VALUE) : View.MeasureSpec.makeMeasureSpec((int)params.width, (int)0x40000000);
        heightMeasureSpec = params.height == -2 ? View.MeasureSpec.makeMeasureSpec((int)this.getHeight(), (int)Integer.MIN_VALUE) : (params.height == -1 ? View.MeasureSpec.makeMeasureSpec((int)this.getHeight(), (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)params.height, (int)0x40000000));
        child.measure(widthMeasureSpec, heightMeasureSpec);
    }

    protected synchronized void onLayout(boolean changed, int left, int top, int right, int bottom) {
        boolean needRelayout;
        super.onLayout(changed, left, top, right, bottom);
        if (this.mAdapter == null) {
            return;
        }
        if (this.mDataChanged) {
            int oldCurrentX = this.mCurrentX;
            this.initView();
            this.removeAllViewsInLayout();
            this.mNextX = oldCurrentX;
            this.mDataChanged = false;
        }
        if (this.mScroller.computeScrollOffset()) {
            int scrollx;
            this.mNextX = scrollx = this.mScroller.getCurrX();
        }
        if (this.mNextX < 0) {
            this.mNextX = 0;
            this.mScroller.forceFinished(true);
        }
        if (this.mNextX > this.mMaxX && this.mMaxX > 0) {
            this.mNextX = this.mMaxX;
            this.mScroller.forceFinished(true);
        }
        int dx = this.mCurrentX - this.mNextX;
        this.removeNonVisibleItems(dx);
        this.fillList(dx);
        this.positionItems(dx);
        this.mCurrentX = this.mNextX;
        boolean bl = needRelayout = this.mNextX > this.mMaxX && this.mMaxX > 0;
        if (!this.mScroller.isFinished() || needRelayout) {
            this.post(this.mRelayoutRunnable);
        }
    }

    private void fillList(int dx) {
        int edge = 0;
        View child = this.getChildAt(this.getChildCount() - 1);
        if (child != null) {
            edge = child.getRight();
        }
        this.fillListRight(edge, dx);
        edge = 0;
        child = this.getChildAt(0);
        if (child != null) {
            edge = child.getLeft();
        }
        this.fillListLeft(edge, dx);
    }

    private void fillListRight(int rightEdge, int dx) {
        while (rightEdge + dx < this.getWidth() && this.mRightViewIndex < this.mAdapter.getCount()) {
            View child = this.mAdapter.getView(this.mRightViewIndex, this.mRemovedViewQueue.poll(), (ViewGroup)this);
            this.addAndMeasureChild(child, -1);
            rightEdge += child.getMeasuredWidth();
            if (this.mRightViewIndex == this.mAdapter.getCount() - 1) {
                this.mMaxX = this.mCurrentX + rightEdge - this.getWidth();
            }
            ++this.mRightViewIndex;
        }
    }

    private void fillListLeft(int leftEdge, int dx) {
        while (leftEdge + dx > 0 && this.mLeftViewIndex >= 0) {
            View child = this.mAdapter.getView(this.mLeftViewIndex, this.mRemovedViewQueue.poll(), (ViewGroup)this);
            this.addAndMeasureChild(child, 0);
            leftEdge -= child.getMeasuredWidth();
            --this.mLeftViewIndex;
            this.mDisplayOffset -= child.getMeasuredWidth();
        }
    }

    private void removeNonVisibleItems(int dx) {
        View child = this.getChildAt(0);
        while (child != null && child.getRight() + dx <= 0) {
            this.mDisplayOffset += child.getMeasuredWidth();
            this.mRemovedViewQueue.offer(child);
            this.removeViewInLayout(child);
            ++this.mLeftViewIndex;
            child = this.getChildAt(0);
        }
        child = this.getChildAt(this.getChildCount() - 1);
        while (child != null && child.getLeft() + dx >= this.getWidth()) {
            this.mRemovedViewQueue.offer(child);
            this.removeViewInLayout(child);
            --this.mRightViewIndex;
            child = this.getChildAt(this.getChildCount() - 1);
        }
    }

    private void positionItems(int dx) {
        if (this.getChildCount() > 0) {
            this.mDisplayOffset += dx;
            int left = this.mDisplayOffset;
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                int childWidth = child.getMeasuredWidth();
                child.layout(left, 0, left + childWidth, child.getMeasuredHeight());
                left += childWidth;
            }
        }
    }

    public synchronized void scrollTo(int x) {
        this.mScroller.startScroll(this.mNextX, 0, x - this.mNextX, 0);
        this.requestLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchTouchEvent(MotionEvent ev) {
        boolean handled = this.mGesture.onTouchEvent(ev);
        if (!handled && ev.getAction() == 1) {
            if (this.mCurrentX > 0) {
                ZMHorizontalListView zMHorizontalListView = this;
                synchronized (zMHorizontalListView) {
                    this.mScroller.fling(this.mCurrentX, 0, -100, 0, 0, this.mMaxX, 0, 0);
                }
                this.requestLayout();
            }
            return true;
        }
        return handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        ZMHorizontalListView zMHorizontalListView = this;
        synchronized (zMHorizontalListView) {
            this.mScroller.fling(this.mNextX, 0, (int)(-velocityX), 0, 0, this.mMaxX, 0, 0);
        }
        this.requestLayout();
        return true;
    }

    protected boolean onDown(MotionEvent e) {
        this.mScroller.forceFinished(true);
        return true;
    }
}

