/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

public class ZMFillFixRatioImageView
extends ImageView {
    public ZMFillFixRatioImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public ZMFillFixRatioImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public ZMFillFixRatioImageView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == Integer.MIN_VALUE && heightMode == Integer.MIN_VALUE || widthMode == 0x40000000 && heightMode == 0x40000000) {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (widthMode == 0x40000000 && heightMode != 0x40000000) {
            this.setScaleType(ImageView.ScaleType.FIT_XY);
            int imageWidth = drawable2.getIntrinsicWidth();
            int imageHeight = drawable2.getIntrinsicHeight();
            double ratio = (double)imageWidth * 1.0 / (double)imageHeight;
            height = (int)((double)width / ratio);
            this.setMeasuredDimension(width, height);
        } else if (widthMode != 0x40000000 && heightMode == 0x40000000) {
            this.setScaleType(ImageView.ScaleType.FIT_XY);
            int imageWidth = drawable2.getIntrinsicWidth();
            int imageHeight = drawable2.getIntrinsicHeight();
            double ratio = (double)imageWidth * 1.0 / (double)imageHeight;
            width = (int)((double)height * ratio);
            this.setMeasuredDimension(width, height);
        } else {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

