/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.R;
import us.zoom.androidlib.widget.IZMMenuItem;

public class ZMChoiceAdapter<MenuItemType extends IZMMenuItem>
extends BaseAdapter {
    private Context mContext;
    private int mDrawableChoiceResId;
    private String mDrawableContentDescription;
    private List<MenuItemType> mList = new ArrayList<MenuItemType>();

    public ZMChoiceAdapter(Context context, int drawableChoiceResId, String drawableContentDescription) {
        this.mContext = context;
        this.mDrawableChoiceResId = drawableChoiceResId;
        this.mDrawableContentDescription = drawableContentDescription;
    }

    public int getCount() {
        return this.mList.size();
    }

    public Object getItem(int position) {
        return this.mList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void addAll(MenuItemType ... items) {
        for (MenuItemType item : items) {
            this.addItem(item);
        }
    }

    public void addAll(List<MenuItemType> items) {
        for (IZMMenuItem item : items) {
            this.addItem(item);
        }
    }

    public void addItem(MenuItemType item) {
        this.mList.add(item);
    }

    public void clear() {
        this.mList.clear();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            convertView = inflater.inflate(R.layout.zm_item_with_choice, null);
        }
        TextView txtTitle = (TextView)convertView.findViewById(R.id.txtTitle);
        ImageView imgChoice = (ImageView)convertView.findViewById(R.id.imgIcon);
        imgChoice.setImageResource(this.mDrawableChoiceResId);
        imgChoice.setContentDescription((CharSequence)this.mDrawableContentDescription);
        IZMMenuItem item = (IZMMenuItem)this.mList.get(position);
        if (item == null) {
            return null;
        }
        txtTitle.setText((CharSequence)item.getLabel());
        imgChoice.setVisibility(item.isSelected() ? 0 : 8);
        return convertView;
    }
}

