/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;
import java.lang.ref.WeakReference;
import us.zoom.androidlib.R;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.SingleItemAdapter;
import us.zoom.androidlib.widget.ZMAlertHolder;

public class ZMAlertDialog
extends Dialog
implements DialogInterface {
    private ZMAlertHolder holder;
    private TextView msg;
    private TextView title;
    private LinearLayout contentPanel;
    private LinearLayout mTopPanel;
    private LayoutInflater mInflater;
    private ScrollView mScrollView;
    private LinearLayout buttonPanel;
    private Button mButtonPositive;
    private FrameLayout customFrame;
    private Message mButtonPositiveMessage;
    private Button mButtonNegative;
    private Message mButtonNegativeMessage;
    private Button mButtonNeutral;
    private Message mButtonNeutralMessage;
    private View mCustomPanelBottomGap;
    private ImageView mAlertIcon;
    private Handler mHandler;
    protected Context mContext;
    View.OnClickListener mButtonHandler = new View.OnClickListener(){

        public void onClick(View v) {
            Message m = null;
            if (v == ZMAlertDialog.this.mButtonPositive && ZMAlertDialog.this.mButtonPositiveMessage != null) {
                m = Message.obtain((Message)ZMAlertDialog.this.mButtonPositiveMessage);
            } else if (v == ZMAlertDialog.this.mButtonNegative && ZMAlertDialog.this.mButtonNegativeMessage != null) {
                m = Message.obtain((Message)ZMAlertDialog.this.mButtonNegativeMessage);
            } else if (v == ZMAlertDialog.this.mButtonNeutral && ZMAlertDialog.this.mButtonNeutralMessage != null) {
                m = Message.obtain((Message)ZMAlertDialog.this.mButtonNeutralMessage);
            }
            if (m != null) {
                m.sendToTarget();
            }
            ZMAlertDialog.this.mHandler.obtainMessage(1, (Object)ZMAlertDialog.this).sendToTarget();
        }
    };

    public ZMAlertDialog(ZMAlertHolder holder) {
        this(holder, R.style.ZMDialog_Material);
    }

    public ZMAlertDialog(ZMAlertHolder holder, int theme) {
        super(holder.getContext(), theme);
        this.holder = holder;
        this.mContext = holder.getContext();
        this.mHandler = new ButtonHandler(this);
    }

    public ZMAlertDialog(Context context, int theme) {
        super(context, R.style.ZMDialog_Material);
        this.holder = new ZMAlertHolder(context);
        this.mContext = context;
        this.mHandler = new ButtonHandler(this);
    }

    public Button getButton(int whichButton) {
        switch (whichButton) {
            case -1: {
                return this.mButtonPositive;
            }
            case -2: {
                return this.mButtonNegative;
            }
            case -3: {
                return this.mButtonNeutral;
            }
        }
        return null;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().requestFeature(1);
        if (this.holder.getmView() == null || !ZMAlertDialog.canTextInput(this.holder.getmView())) {
            this.getWindow().setFlags(131072, 131072);
        }
        this.setContentView(R.layout.zm_alert_layout);
        this.customFrame = (FrameLayout)this.findViewById(R.id.customPanel);
        this.mInflater = (LayoutInflater)this.holder.getContext().getSystemService("layout_inflater");
        this.contentPanel = (LinearLayout)this.findViewById(R.id.contentPanel);
        this.mScrollView = (ScrollView)this.findViewById(R.id.scrollView);
        this.buttonPanel = (LinearLayout)this.findViewById(R.id.buttonPanel);
        this.mTopPanel = (LinearLayout)this.findViewById(R.id.topPanel);
        if (17 == Build.VERSION.SDK_INT) {
            this.setupLayoutBackground();
        }
        if (this.holder.getType() == 0 && !TextUtils.isEmpty((CharSequence)this.holder.getTitle()) && TextUtils.isEmpty((CharSequence)this.holder.getMsg())) {
            String message = this.holder.getTitle();
            this.holder.setTitle(null);
            this.holder.setMsg(message);
        }
        if (null == this.holder.getTitle()) {
            this.mTopPanel.setVisibility(8);
            View titleView = this.holder.getTitleView();
            if (titleView != null) {
                LinearLayout customTopPanel = (LinearLayout)this.findViewById(R.id.customTopPanel);
                customTopPanel.addView(titleView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
                customTopPanel.setVisibility(0);
                this.contentPanel.setPadding(0, 0, 0, this.contentPanel.getPaddingBottom());
            }
        } else {
            this.title = (TextView)this.findViewById(R.id.alertTitle);
            this.title.setText((CharSequence)this.holder.getTitle());
        }
        this.msg = (TextView)this.findViewById(R.id.alertdialogmsg);
        this.mCustomPanelBottomGap = this.findViewById(R.id.customPanelBottomGap);
        this.mAlertIcon = (ImageView)this.findViewById(R.id.alertIcon);
        if (Build.MANUFACTURER != null && Build.MANUFACTURER.toLowerCase().contains("blu")) {
            this.mAlertIcon.setImageResource(R.drawable.ic_dialog_alert);
        } else {
            this.mAlertIcon.setImageResource(17301543);
        }
        this.setupButtons();
        this.setupContent();
        super.setCancelable(this.holder.isCancelable());
    }

    private void setupLayoutBackground() {
        View rootLayout = this.findViewById(R.id.dialog_root_layout);
        TypedValue a = new TypedValue();
        this.getContext().getTheme().resolveAttribute(16842836, a, true);
        rootLayout.setBackgroundResource(a.resourceId);
        this.getWindow().setBackgroundDrawableResource(17170445);
    }

    static boolean canTextInput(View v) {
        if (v.onCheckIsTextEditor()) {
            return true;
        }
        if (!(v instanceof ViewGroup)) {
            return false;
        }
        ViewGroup vg = (ViewGroup)v;
        int i = vg.getChildCount();
        while (i > 0) {
            if (!ZMAlertDialog.canTextInput(v = vg.getChildAt(--i))) continue;
            return true;
        }
        return false;
    }

    private boolean setupButtons() {
        Button defaultButton = null;
        int BIT_BUTTON_POSITIVE = 1;
        int BIT_BUTTON_NEGATIVE = 2;
        int BIT_BUTTON_NEUTRAL = 4;
        int whichButtons = 0;
        this.mButtonPositive = (Button)this.findViewById(R.id.button1);
        this.mButtonPositive.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty((CharSequence)this.holder.getmPositiveButtonText())) {
            this.mButtonPositive.setVisibility(8);
        } else {
            this.mButtonPositive.setText((CharSequence)this.holder.getmPositiveButtonText());
            this.mButtonPositive.setVisibility(0);
            defaultButton = this.mButtonPositive;
            whichButtons |= BIT_BUTTON_POSITIVE;
        }
        this.mButtonNegative = (Button)this.findViewById(R.id.button2);
        this.mButtonNegative.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty((CharSequence)this.holder.getmNegativeButtonText())) {
            this.mButtonNegative.setVisibility(8);
        } else {
            this.mButtonNegative.setText((CharSequence)this.holder.getmNegativeButtonText());
            this.mButtonNegative.setVisibility(0);
            if (defaultButton == null) {
                defaultButton = this.mButtonNegative;
            }
            whichButtons |= BIT_BUTTON_NEGATIVE;
        }
        this.mButtonNeutral = (Button)this.findViewById(R.id.button3);
        this.mButtonNeutral.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty((CharSequence)this.holder.getmNeutralButtonText())) {
            this.mButtonNeutral.setVisibility(8);
        } else {
            this.mButtonNeutral.setText((CharSequence)this.holder.getmNeutralButtonText());
            this.mButtonNeutral.setVisibility(0);
            if (defaultButton == null) {
                defaultButton = this.mButtonNeutral;
            }
            whichButtons |= BIT_BUTTON_NEUTRAL;
        }
        if (whichButtons != 0) {
            if (this.holder.getmPositiveButtonText() != null) {
                this.setButtonMessage(-1, this.holder.getmPositiveButtonText(), this.holder.getPositiveButtonListener(), null);
            }
            if (this.holder.getmNegativeButtonText() != null) {
                this.setButtonMessage(-2, this.holder.getmNegativeButtonText(), this.holder.getNegativeButtonListener(), null);
            }
            if (this.holder.getmNeutralButtonText() != null) {
                this.setButtonMessage(-3, this.holder.getmNeutralButtonText(), this.holder.getNeutralButtonListener(), null);
            }
            for (int i = this.buttonPanel.getChildCount() - 1; i >= 0; --i) {
                View child = this.buttonPanel.getChildAt(i);
                if (child.getVisibility() != 0) continue;
                ((LinearLayout.LayoutParams)child.getLayoutParams()).rightMargin = 0;
                break;
            }
        } else {
            this.buttonPanel.setVisibility(8);
        }
        return whichButtons != 0;
    }

    private void setButtonMessage(int whichButton, CharSequence text, DialogInterface.OnClickListener listener, Message msg) {
        if (msg == null && listener != null) {
            msg = this.mHandler.obtainMessage(whichButton, (Object)listener);
        }
        switch (whichButton) {
            case -1: {
                this.mButtonPositiveMessage = msg;
                break;
            }
            case -2: {
                this.mButtonNegativeMessage = msg;
                break;
            }
            case -3: {
                this.mButtonNeutralMessage = msg;
                break;
            }
            default: {
                throw new IllegalArgumentException("Button does not exist");
            }
        }
    }

    public void setButton(int whichButton, CharSequence text, DialogInterface.OnClickListener listener) {
        switch (whichButton) {
            case -1: {
                this.holder.setmPositiveButtonText(text.toString());
                this.holder.setPositiveButtonListener(listener);
                break;
            }
            case -2: {
                this.holder.setmNegativeButtonText(text.toString());
                this.holder.setNegativeButtonListener(listener);
                break;
            }
            case -3: {
                this.holder.setmNeutralButtonText(text.toString());
                this.holder.setNeutralButtonListener(listener);
                break;
            }
            default: {
                throw new IllegalArgumentException("Button does not exist");
            }
        }
    }

    private void hideContentPanel() {
        this.msg.setVisibility(8);
        this.mScrollView.setVisibility(8);
        this.contentPanel.removeView((View)this.mScrollView);
        this.contentPanel.setVisibility(8);
    }

    private void setupContent() {
        this.mScrollView.setFocusable(false);
        if (this.holder.getType() == 0) {
            this.hideContentPanel();
        } else if (this.holder.getType() == 1) {
            String message = this.holder.getMsg();
            Drawable icon = this.holder.getIcon();
            if (message == null && icon == null) {
                this.hideContentPanel();
            } else {
                if (message == null) {
                    message = "";
                }
                this.msg.setText((CharSequence)message);
                if (this.holder.getTitle() == null) {
                    this.msg.setPadding(0, UIUtil.dip2px(this.mContext, 20.0f), 0, 0);
                    this.msg.setTextAppearance(this.mContext, R.style.ZMTextView_Medium_DialogMsg);
                }
                if (icon == null) {
                    this.mAlertIcon.setVisibility(8);
                } else {
                    this.mAlertIcon.setVisibility(0);
                    this.mAlertIcon.setImageDrawable(icon);
                }
            }
        } else if (this.holder.getType() == 2 || this.holder.getType() == 3) {
            this.msg.setVisibility(8);
            this.mScrollView.setVisibility(8);
            this.contentPanel.removeView((View)this.mScrollView);
            this.mScrollView = null;
            ListView listView = this.createListView();
            this.contentPanel.addView((View)listView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
            this.contentPanel.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
            this.mCustomPanelBottomGap.setVisibility(8);
            if (this.holder.getTitle() != null) {
                this.title.setVisibility(8);
                TextView alertOptionTitle = (TextView)this.findViewById(R.id.alertOptionTitle);
                alertOptionTitle.setText((CharSequence)this.holder.getTitle());
                alertOptionTitle.setVisibility(0);
                this.mTopPanel.setPadding(0, 0, 0, 0);
            }
        } else if (this.holder.getType() == 5) {
            this.hideContentPanel();
            this.customFrame.setVisibility(0);
            FrameLayout custom = (FrameLayout)this.findViewById(R.id.customView);
            if (this.holder.ismViewSpacingSpecified()) {
                // empty if block
            }
            this.mCustomPanelBottomGap.setVisibility(this.holder.isHideBottomGap() ? 8 : 0);
            custom.addView(this.holder.getmView(), new ViewGroup.LayoutParams(-1, -1));
        }
    }

    public void setCancelable(boolean cancelable) {
        this.holder.setCancelable(cancelable);
        super.setCancelable(cancelable);
    }

    public void setView(View view) {
        this.holder.setmView(view);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mScrollView != null && this.mScrollView.executeKeyEvent(event)) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mScrollView != null && this.mScrollView.executeKeyEvent(event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private ListView createListView() {
        final ListView listView = (ListView)this.mInflater.inflate(R.layout.zm_select_dialog, null);
        if (this.holder.getAdater() == null && this.holder.getType() == 3) {
            SingleItemAdapter adapter = new SingleItemAdapter(this.holder.getItems(), this.holder.getContext());
            adapter.setIndex(this.holder.getCheckIndex());
            listView.setAdapter((ListAdapter)adapter);
        } else if (this.holder.getAdater() != null) {
            listView.setAdapter(this.holder.getAdater());
        } else if (this.holder.getType() == 1) {
            return null;
        }
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                ZMAlertDialog.this.holder.getListListener().onClick((DialogInterface)ZMAlertDialog.this, position);
                if (ZMAlertDialog.this.holder.getType() == 3) {
                    ((SingleItemAdapter)listView.getAdapter()).setIndex(position);
                    ((SingleItemAdapter)listView.getAdapter()).notifyDataSetChanged();
                } else if (ZMAlertDialog.this.holder.getType() == 2) {
                    ZMAlertDialog.this.dismiss();
                }
            }
        });
        int dividerHeight = this.holder.getListDividerHeight();
        if (dividerHeight >= 0) {
            listView.setDividerHeight(dividerHeight);
        }
        return listView;
    }

    public void setTitle(CharSequence title) {
        this.holder.setTitle(title.toString());
        if (this.title != null) {
            this.title.setText(title);
        }
    }

    public static class Builder {
        private ZMAlertHolder holder;

        public Builder(Context context) {
            this.holder = new ZMAlertHolder(context);
        }

        public ZMAlertDialog create() {
            ZMAlertDialog zmAlerDialog = new ZMAlertDialog(this.holder, this.holder.getTheme());
            this.holder.setDialog(zmAlerDialog);
            zmAlerDialog.setCancelable(this.holder.isCancelable());
            return zmAlerDialog;
        }

        public Builder setMessage(String msg) {
            this.holder.setMsg(msg);
            return this;
        }

        public Builder setTheme(int theme) {
            this.holder.setTheme(theme);
            return this;
        }

        public Builder setTitleView(View titleView) {
            this.holder.setTitleView(titleView);
            return this;
        }

        public Builder setMessage(int res) {
            if (res > 0) {
                this.holder.setType(1);
                this.holder.setMsg(this.holder.getContext().getString(res));
            } else {
                this.holder.setMsg(null);
            }
            return this;
        }

        public Builder setTitle(String title) {
            this.holder.setTitle(title);
            return this;
        }

        public Builder setTitle(int res) {
            if (res > 0) {
                this.holder.setTitle(this.holder.getContext().getString(res));
            } else {
                this.holder.setTitle(null);
            }
            return this;
        }

        public Builder setListDividerHeight(int height) {
            this.holder.setListDividerHeight(height);
            return this;
        }

        public Builder setIcon(Drawable icon) {
            this.holder.setIcon(icon);
            return this;
        }

        public Builder setIcon(int resId) {
            this.holder.setIcon(resId);
            return this;
        }

        public Builder setNegativeButton(int res, DialogInterface.OnClickListener listener) {
            this.holder.setmNegativeButtonText(this.holder.getContext().getString(res));
            this.holder.setNegativeButtonListener(listener);
            return this;
        }

        public Builder setNeutralButton(int res, DialogInterface.OnClickListener listener) {
            this.holder.setmNeutralButtonText(this.holder.getContext().getString(res));
            this.holder.setNeutralButtonListener(listener);
            return this;
        }

        public Builder setPositiveButton(int res, DialogInterface.OnClickListener listener) {
            this.holder.setPositiveButtonListener(listener);
            this.holder.setmPositiveButtonText(this.holder.getContext().getString(res));
            return this;
        }

        public Builder setNegativeButton(String res, DialogInterface.OnClickListener listener) {
            this.holder.setmNegativeButtonText(res);
            this.holder.setNegativeButtonListener(listener);
            return this;
        }

        public Builder setNeutralButton(String res, DialogInterface.OnClickListener listener) {
            this.holder.setmNeutralButtonText(res);
            this.holder.setNeutralButtonListener(listener);
            return this;
        }

        public Builder setPositiveButton(String res, DialogInterface.OnClickListener listener) {
            this.holder.setPositiveButtonListener(listener);
            this.holder.setmPositiveButtonText(res);
            return this;
        }

        public Builder setCancelable(boolean b) {
            this.holder.setCancelable(b);
            return this;
        }

        public Builder setView(@NonNull View view) {
            this.holder.setmView(view);
            this.holder.setmViewSpacingSpecified(false);
            return this;
        }

        public Builder setView(View view, boolean isHideBottomGap) {
            this.holder.setmView(view);
            this.holder.setmViewSpacingSpecified(false);
            this.holder.setHideBottomGap(isHideBottomGap);
            return this;
        }

        public Button getButton(int whichButton) {
            return this.holder.getDialog().getButton(whichButton);
        }

        public void show() {
            if (this.holder.getDialog() == null) {
                this.create();
            }
            this.holder.getDialog().show();
        }

        public Builder setAdapter(ListAdapter adapter, DialogInterface.OnClickListener listener) {
            this.holder.setType(2);
            this.holder.setAdater(adapter);
            this.holder.setListListener(listener);
            return this;
        }

        public Builder setSingleChoiceItems(CharSequence[] items, int checkedItem, DialogInterface.OnClickListener listener) {
            this.holder.setType(3);
            this.holder.setSingleChoice(true);
            this.holder.setMultiChoice(false);
            this.holder.setItems(items);
            this.holder.setCheckIndex(checkedItem);
            this.holder.setListListener(listener);
            return this;
        }

        public Builder setMultiChoiceItems(CharSequence[] items, int checkedItem, DialogInterface.OnClickListener listener) {
            this.holder.setType(3);
            this.holder.setMultiChoice(true);
            this.holder.setListListener(listener);
            return this;
        }

        public Builder setSingleChoiceItems(ListAdapter mAdapter, int checkedItem, DialogInterface.OnClickListener listener) {
            this.holder.setSingleChoice(true);
            this.holder.setType(2);
            this.holder.setAdater(mAdapter);
            this.holder.setListListener(listener);
            return this;
        }
    }

    private static final class ButtonHandler
    extends Handler {
        private static final int MSG_DISMISS_DIALOG = 1;
        private WeakReference<DialogInterface> mDialog;

        public ButtonHandler(DialogInterface dialog) {
            this.mDialog = new WeakReference<DialogInterface>(dialog);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case -3: 
                case -2: 
                case -1: {
                    ((DialogInterface.OnClickListener)msg.obj).onClick((DialogInterface)this.mDialog.get(), msg.what);
                    break;
                }
                case 1: {
                    ((DialogInterface)msg.obj).dismiss();
                }
            }
        }
    }
}

