/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.ZMLog;

public class WaitingDialog
extends ZMDialogFragment {
    private static final String TAG = WaitingDialog.class.getName();
    public static final String ARG_MESSAGE = "message";
    public static final String ARG_TITLE = "title";
    public static final String ARG_MESSAGE_ID = "messageId";
    public static final String ARG_TITLE_ID = "titleId";
    public static final String ARG_FINISH_ACTIVITY_ON_CANCEL = "finishActivityOnCancel";
    private Activity mActivity = null;
    private ProgressDialog mProgressDialog = null;

    public WaitingDialog() {
        this("<message not defined>", null);
    }

    public WaitingDialog(String message) {
        this(message, null, false);
    }

    public WaitingDialog(String message, boolean finishActivityOnCancel) {
        this(message, null, finishActivityOnCancel);
    }

    public WaitingDialog(String message, String title) {
        this(message, title, false);
    }

    public WaitingDialog(String message, String title, boolean finishActivityOnCancel) {
        this.setCancelable(finishActivityOnCancel);
        Bundle args = new Bundle();
        args.putString(ARG_MESSAGE, message);
        args.putString(ARG_TITLE, title);
        args.putBoolean(ARG_FINISH_ACTIVITY_ON_CANCEL, finishActivityOnCancel);
        this.setArguments(args);
    }

    public WaitingDialog(int messageId) {
        this(messageId, 0, false);
    }

    public WaitingDialog(int messageId, boolean finishActivityOnCancel) {
        this(messageId, 0, finishActivityOnCancel);
    }

    public WaitingDialog(int messageId, int titleId) {
        this(messageId, titleId, false);
    }

    public WaitingDialog(int messageId, int titleId, boolean finishActivityOnCancel) {
        this.setCancelable(finishActivityOnCancel);
        Bundle args = new Bundle();
        args.putInt(ARG_MESSAGE_ID, messageId);
        args.putInt(ARG_TITLE_ID, titleId);
        args.putBoolean(ARG_FINISH_ACTIVITY_ON_CANCEL, finishActivityOnCancel);
        this.setArguments(args);
    }

    @Override
    public void onStart() {
        super.onStart();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        int titleId;
        int messageId;
        this.mActivity = this.getActivity();
        if (this.mActivity == null) {
            return null;
        }
        Bundle args = this.getArguments();
        String message = args.getString(ARG_MESSAGE);
        String title = args.getString(ARG_TITLE);
        if (message == null && (messageId = args.getInt(ARG_MESSAGE_ID)) > 0) {
            message = this.mActivity.getString(messageId);
        }
        if (title == null && (titleId = args.getInt(ARG_TITLE_ID)) > 0) {
            title = this.mActivity.getString(titleId);
        }
        ZMProgressDialog dialog = new ZMProgressDialog((Context)this.mActivity);
        dialog.requestWindowFeature(1);
        dialog.setMessage(message);
        dialog.setTitle(title);
        dialog.setCanceledOnTouchOutside(false);
        this.mProgressDialog = dialog;
        return dialog;
    }

    public void setDialogMessage(String message) {
        if (this.mProgressDialog != null) {
            this.mProgressDialog.setMessage((CharSequence)message);
        }
    }

    public void onCancel(DialogInterface dialog) {
        Bundle args = this.getArguments();
        if (args == null) {
            return;
        }
        boolean finishActivityOnCancel = args.getBoolean(ARG_FINISH_ACTIVITY_ON_CANCEL, false);
        if (finishActivityOnCancel && this.mActivity != null) {
            this.mActivity.finish();
        }
    }

    static class ZMProgressDialog
    extends ProgressDialog {
        public ZMProgressDialog(Context context, int theme) {
            super(context, theme);
        }

        public ZMProgressDialog(Context context) {
            super(context);
        }

        public void show() {
            ZMActivity activity = (ZMActivity)this.getOwnerActivity();
            if (activity == null || !activity.isActive()) {
                ZMLog.e(TAG, "ZMProgressDialog.show(), activity is not in foreground", new Object[0]);
                return;
            }
            try {
                super.show();
            }
            catch (Exception e) {
                ZMLog.e(TAG, e, "ZMProgressDialog.show(), exception", new Object[0]);
                return;
            }
        }
    }
}

