/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import us.zoom.androidlib.R;
import us.zoom.androidlib.util.HashMapComparator;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeZoneUtil;

public class TimeZoneListAdapter
extends BaseAdapter {
    private Context mContext;
    private List<HashMap<String, Object>> mZones;

    public TimeZoneListAdapter(Context context, boolean sortedByName) {
        assert (context != null);
        this.mContext = context;
        this.mZones = TimeZoneUtil.getZones(context);
        String sortKey = sortedByName ? "name" : "offset";
        HashMapComparator comparator = new HashMapComparator(sortKey);
        Collections.sort(this.mZones, comparator);
    }

    public int getCount() {
        return this.mZones.size();
    }

    public Object getItem(int position) {
        if (position < 0 || position > this.getCount()) {
            return null;
        }
        return this.mZones.get(position).get("id");
    }

    private HashMap<String, Object> getItemMap(int position) {
        if (position < 0 || position > this.getCount()) {
            return null;
        }
        return this.mZones.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View view;
        if (convertView != null && "TimeZoneListAdapter".equals(convertView.getTag())) {
            view = convertView;
        } else {
            view = View.inflate((Context)this.mContext, (int)R.layout.zm_time_zone_list_item, null);
            view.setTag((Object)"TimeZoneListAdapter");
        }
        TextView cityView = (TextView)view.findViewById(R.id.txtCity);
        TextView gmtView = (TextView)view.findViewById(R.id.txtGMT);
        HashMap<String, Object> item = this.getItemMap(position);
        if (item != null) {
            String name = (String)item.get("name");
            String gmt = (String)item.get("gmt");
            if (view.isInEditMode()) {
                cityView.setText((CharSequence)"ShangHai");
                gmtView.setText((CharSequence)"GMT+08:00");
            } else {
                cityView.setText((CharSequence)name);
                gmtView.setText((CharSequence)gmt);
            }
        }
        return view;
    }

    public String getItemDisplayName(String id2) {
        if (StringUtil.isEmptyOrNull(id2)) {
            return "";
        }
        return TimeZoneUtil.getFullName(id2);
    }
}

