/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import us.zoom.androidlib.R;
import us.zoom.androidlib.util.CaptionStyleCompat;
import us.zoom.androidlib.util.CaptionUtil;
import us.zoom.androidlib.widget.CaptionTextView;

public class CaptionView
extends LinearLayout {
    private CaptionTextView mContent;
    private View mWindow;

    public CaptionView(Context context) {
        super(context);
        this.initView(context);
    }

    public CaptionView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public CaptionView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    @SuppressLint(value={"NewApi"})
    public CaptionView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_caption_view, (ViewGroup)this);
        this.mContent = (CaptionTextView)this.findViewById(R.id.content);
        this.mWindow = this.findViewById(R.id.window);
    }

    private void refresh() {
        if (this.mWindow != null) {
            CaptionStyleCompat style2 = CaptionUtil.getCaptionStyle(this.getContext());
            this.mWindow.setBackgroundColor(style2.windowColor);
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (!this.isInEditMode()) {
            this.refresh();
        }
    }

    public void setText(String text) {
        if (this.mContent == null) {
            return;
        }
        this.mContent.setText(text);
    }
}

