/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.app.UiModeManager;
import android.content.Context;
import android.content.res.Configuration;

public class UiModeUtil {
    public static boolean isInDesktopMode(Context context) {
        if (context == null) {
            return false;
        }
        if (UiModeUtil.isSamsungDesktopModeEnable(context)) {
            return true;
        }
        UiModeManager uiModeMgr = (UiModeManager)context.getSystemService("uimode");
        if (uiModeMgr == null) {
            return false;
        }
        int mode = uiModeMgr.getCurrentModeType();
        return mode == 2;
    }

    private static boolean isSamsungDesktopModeEnable(Context context) {
        Configuration config = context.getResources().getConfiguration();
        if (config == null) {
            return false;
        }
        try {
            Class<?> configClass = config.getClass();
            if (configClass.getField("SEM_DESKTOP_MODE_ENABLED").getInt(configClass) == configClass.getField("semDesktopModeEnabled").getInt(config)) {
                return true;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }
}

