/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.content.Context;
import android.content.res.XmlResourceParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.xmlpull.v1.XmlPullParserException;
import us.zoom.androidlib.R;
import us.zoom.androidlib.util.StringUtil;

public class TimeZoneUtil {
    public static final String KEY_ID = "id";
    public static final String KEY_CITY_DISPLAYNAME = "name";
    public static final String KEY_GMT = "gmt";
    public static final String KEY_OFFSET = "offset";
    public static final String XMLTAG_TIMEZONE = "timezone";
    private static final int HOURS_1 = 3600000;

    public static List<HashMap<String, Object>> getZones(Context context) {
        ArrayList<HashMap<String, Object>> myData = new ArrayList<HashMap<String, Object>>();
        long date = Calendar.getInstance().getTimeInMillis();
        try {
            XmlResourceParser xrp = context.getResources().getXml(R.xml.timezones);
            while (xrp.next() != 2) {
            }
            xrp.next();
            while (xrp.getEventType() != 3) {
                while (xrp.getEventType() != 2) {
                    if (xrp.getEventType() == 1) {
                        return myData;
                    }
                    xrp.next();
                }
                if (xrp.getName().equals(XMLTAG_TIMEZONE)) {
                    String id2 = xrp.getAttributeValue(0);
                    String displayName = xrp.nextText();
                    TimeZoneUtil.addItem(myData, id2, displayName, date);
                }
                while (xrp.getEventType() != 3) {
                    xrp.next();
                }
                xrp.next();
            }
            xrp.close();
        }
        catch (XmlPullParserException xmlPullParserException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return myData;
    }

    private static void addItem(List<HashMap<String, Object>> myData, String id2, String displayName, long date) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_ID, id2);
        map.put(KEY_CITY_DISPLAYNAME, displayName);
        int offset = TimeZoneUtil.getOffset(id2);
        map.put(KEY_GMT, TimeZoneUtil.getGMT(offset));
        map.put(KEY_OFFSET, offset);
        myData.add(map);
    }

    public static String getFullName(String id2) {
        if (StringUtil.isEmptyOrNull(id2)) {
            return "";
        }
        TimeZone timezone = TimeZone.getTimeZone(id2);
        if (timezone == null) {
            return "";
        }
        return TimeZoneUtil.getGMT(id2) + ", " + timezone.getDisplayName();
    }

    public static String getCityName(List<HashMap<String, Object>> zones, String id2) {
        if (zones == null || StringUtil.isEmptyOrNull(id2)) {
            return "";
        }
        for (HashMap<String, Object> item : zones) {
            if (!id2.equals(item.get(KEY_ID))) continue;
            return (String)item.get(KEY_CITY_DISPLAYNAME);
        }
        return "";
    }

    public static String getGMT(String id2) {
        int offset = TimeZoneUtil.getOffset(id2);
        return TimeZoneUtil.getGMT(offset);
    }

    public static String getGMT(int offset) {
        int p = Math.abs(offset);
        StringBuilder name = new StringBuilder();
        name.append("GMT");
        if (offset < 0) {
            name.append('-');
        } else {
            name.append('+');
        }
        name.append(p / 3600000);
        name.append(':');
        int min = p / 60000;
        if ((min %= 60) < 10) {
            name.append('0');
        }
        name.append(min);
        return name.toString();
    }

    public static int getOffset(String id2) {
        long date = Calendar.getInstance().getTimeInMillis();
        TimeZone tz = TimeZone.getTimeZone(id2);
        return tz.getOffset(date);
    }

    public static TimeZone getTimeZoneById(String id2) {
        if (StringUtil.isEmptyOrNull(id2)) {
            return TimeZone.getDefault();
        }
        TimeZone timezone = TimeZone.getDefault();
        try {
            timezone = TimeZone.getTimeZone(id2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timezone;
    }
}

