/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String TAG = StringUtil.class.getSimpleName();
    public static final int MID_FORMAT_TYPE_DEFAULT = 0;
    public static final int MID_FORMAT_TYPE_34X = 1;
    public static final int MID_FORMAT_TYPE_43X = 2;

    public static boolean isEmptyOrNull(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isSameString(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        if (str1 != null && str2 == null) {
            return false;
        }
        if (str1 == null && str2 != null) {
            return false;
        }
        if (str1 == null || str2 == null) {
            return false;
        }
        return str1.equals(str2);
    }

    public static boolean isSameStringForNotAllowNull(String str1, String str2) {
        boolean isNull1 = StringUtil.isEmptyOrNull(str1);
        boolean isNull2 = StringUtil.isEmptyOrNull(str2);
        if (isNull1 || isNull2) {
            return false;
        }
        return str1.equals(str2);
    }

    public static Map<String, String> parseNameValues(String str) {
        String[] pairs;
        if (str == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : pairs = str.split("\\s*;\\s*")) {
            String[] parts = pair.split("=");
            if (parts.length != 2) continue;
            map.put(parts[0], parts[1]);
        }
        return map;
    }

    public static Object bytes2String(byte[] data) {
        String str = null;
        try {
            str = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.w((String)TAG, (String)"bytes2String failed!", (Throwable)e);
        }
        return str;
    }

    public static String formatConfNumber(String confNumber) {
        return StringUtil.formatConfNumber(confNumber, 0);
    }

    public static String formatConfNumber(String confNumber, int formatType) {
        return StringUtil.formatConfNumber(confNumber, '-', formatType);
    }

    public static String formatConfNumber(String confNumber, char sectionChar) {
        return StringUtil.formatConfNumber(confNumber, sectionChar, 0);
    }

    public static String formatConfNumber(String confNumber, char sectionChar, int formatType) {
        StringBuilder str = new StringBuilder(confNumber);
        if (str.length() < 9) {
            return confNumber;
        }
        switch (formatType) {
            case 1: {
                str.insert(7, sectionChar);
                str.insert(3, sectionChar);
                break;
            }
            case 2: {
                str.insert(7, sectionChar);
                str.insert(4, sectionChar);
                break;
            }
            default: {
                if (str.length() <= 10) {
                    str.insert(6, sectionChar);
                    str.insert(3, sectionChar);
                    break;
                }
                str.insert(7, sectionChar);
                str.insert(3, sectionChar);
            }
        }
        return str.toString();
    }

    public static String formatConfNumber(long confNumber) {
        return StringUtil.formatConfNumber(confNumber, 0);
    }

    public static String formatConfNumber(long confNumber, int formatType) {
        return StringUtil.formatConfNumber(confNumber, '-', formatType);
    }

    public static String formatConfNumber(long confNumber, char sectionChar) {
        return StringUtil.formatConfNumber(confNumber, sectionChar, 0);
    }

    public static String formatConfNumber(long confNumber, char sectionChar, int formatType) {
        return StringUtil.formatConfNumber(String.valueOf(confNumber), sectionChar, formatType);
    }

    public static String ellipseString(String str, int maxWidth, TextPaint paint) {
        while (paint.measureText(str) > (float)maxWidth) {
            if (str.length() <= 3) {
                return str;
            }
            str = str.substring(0, str.length() - 4);
            str = str + "...";
        }
        return str;
    }

    public static boolean isValidEmailAddress(String email) {
        if (email == null) {
            return false;
        }
        return email.matches("^[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+(\\.[A-Za-z0-9!#$%&'*+/=?^_`{|}~-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$");
    }

    public static boolean isValidDomain(String domain) {
        if (TextUtils.isEmpty((CharSequence)domain)) {
            return false;
        }
        return (domain = domain.trim()).contains(".") && !domain.startsWith(".") && !domain.endsWith(".") && !domain.contains("..");
    }

    public static boolean containsAsianCharacter(String str) {
        if (str == null) {
            return false;
        }
        try {
            if (str.length() != str.getBytes("UTF-8").length) {
                return true;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return false;
    }

    public static boolean endsWithAsianCharacter(String str) {
        return StringUtil.containsAsianCharacter(str.substring(str.length() - 1));
    }

    public static boolean startsWithAsianCharacter(String str) {
        return StringUtil.containsAsianCharacter(str.substring(0, 1));
    }

    public static String formatPersonName(String firstName, String lastName) {
        return StringUtil.formatPersonName(firstName, lastName, null);
    }

    public static String formatPersonName(String firstName, String lastName, String regionCode) {
        String first = firstName == null ? "" : firstName;
        String last = lastName == null ? "" : lastName;
        first = first.trim();
        if ((last = last.trim()).length() == 0) {
            return first;
        }
        if (first.length() == 0) {
            return last;
        }
        if (Locale.CHINA.getCountry().equalsIgnoreCase(regionCode)) {
            if (StringUtil.containsAsianCharacter(first) || StringUtil.containsAsianCharacter(last)) {
                if (StringUtil.endsWithAsianCharacter(lastName) || StringUtil.startsWithAsianCharacter(firstName)) {
                    return last + first;
                }
                return last + " " + first;
            }
            return first + " " + last;
        }
        return first + " " + last;
    }

    public static String safeString(String str) {
        return str == null ? "" : str;
    }

    public static boolean isAllAssii(String s) {
        char[] array;
        for (char c : array = s.toCharArray()) {
            if (c >= '\u0000' && c <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public static List<String> getUrls(CharSequence src) {
        if (src == null) {
            return null;
        }
        ArrayList<String> urls = new ArrayList<String>();
        String regex = "\\b(https?://|www\\.)[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        Pattern p = Pattern.compile(regex, 2);
        Matcher m = p.matcher(src);
        while (m.find()) {
            urls.add(m.group());
        }
        return urls;
    }

    public static <T> T[] getSortedSpans(Spanned spanned, Class<T> type) {
        if (spanned == null || type == null) {
            return null;
        }
        Object[] spans = spanned.getSpans(0, spanned.length(), type);
        if (spanned == null) {
            return null;
        }
        Arrays.sort(spans, new SpanCompare(spanned));
        return spans;
    }

    public static CharSequence compatNewLineForAllOS(CharSequence source) {
        if (source == null) {
            return null;
        }
        SpannableStringBuilder builder = new SpannableStringBuilder(source);
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == '\u2028') {
                builder.replace(i, i + 1, (CharSequence)"\n");
                continue;
            }
            if (c != '\r' || i != source.length() - 1 && source.charAt(i + 1) == '\n') continue;
            builder.replace(i, i + 1, (CharSequence)"\n");
        }
        return builder;
    }

    static class SpanCompare<T>
    implements Comparator<T> {
        private Spanned mSpanned;

        public SpanCompare(Spanned spanned) {
            this.mSpanned = spanned;
        }

        @Override
        public int compare(T o1, T o2) {
            if (this.mSpanned == null) {
                return 0;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int start1 = this.mSpanned.getSpanStart(o1);
            int start2 = this.mSpanned.getSpanStart(o2);
            return start1 - start2;
        }
    }
}

