/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.content.Context;
import us.zoom.androidlib.util.CountryCodeUtil;
import us.zoom.androidlib.util.StringUtil;

public class PhoneNumberUtil {
    public static String formatNumber(Context context, String phoneNumber) {
        String isoCountryCode = CountryCodeUtil.getIsoCountryCode(context);
        String phoneCountryCode = CountryCodeUtil.isoCountryCode2PhoneCountryCode(isoCountryCode);
        String formattedNumber = PhoneNumberUtil.formatNumber(phoneNumber, phoneCountryCode);
        return formattedNumber;
    }

    public static String formatNumber(String phoneNumber, String phoneCountryCode) {
        String formattedNumber;
        if (phoneCountryCode == null) {
            phoneCountryCode = "";
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < phoneNumber.length(); ++i) {
            char c = phoneNumber.charAt(i);
            if (c >= '0' && c <= '9') {
                builder.append(c);
                continue;
            }
            if (c == '+' && builder.length() == 0) {
                builder.append(c);
                continue;
            }
            if (c == ',' || c == ';') break;
        }
        if ((formattedNumber = builder.toString()).startsWith("+")) {
            formattedNumber = PhoneNumberUtil.trimZeroAfterCountryCode(formattedNumber);
            return formattedNumber;
        }
        if (formattedNumber.startsWith("000")) {
            return formattedNumber;
        }
        boolean bNeedReplacePrefix = false;
        int replaceCount = 0;
        if (phoneCountryCode.equals("65") && formattedNumber.startsWith("0011")) {
            bNeedReplacePrefix = true;
            replaceCount = 4;
        } else if (phoneCountryCode.equals("7") && formattedNumber.startsWith("810")) {
            bNeedReplacePrefix = true;
            replaceCount = 3;
        } else if (phoneCountryCode.equals("234") && formattedNumber.startsWith("009")) {
            bNeedReplacePrefix = true;
            replaceCount = 3;
        } else if (phoneCountryCode.equals("1") && formattedNumber.startsWith("011")) {
            bNeedReplacePrefix = true;
            replaceCount = 3;
        } else if (phoneCountryCode.equals("47") && formattedNumber.startsWith("095")) {
            bNeedReplacePrefix = true;
            replaceCount = 3;
        } else if (phoneCountryCode.equals("886") && formattedNumber.startsWith("002")) {
            bNeedReplacePrefix = true;
            replaceCount = 3;
        } else if (phoneCountryCode.equals("81") && formattedNumber.startsWith("010")) {
            bNeedReplacePrefix = true;
            replaceCount = 3;
        } else if (phoneCountryCode.equals("82") && (formattedNumber.startsWith("001") || formattedNumber.startsWith("002"))) {
            bNeedReplacePrefix = true;
            replaceCount = 3;
        } else if (phoneCountryCode.equals("381") && formattedNumber.startsWith("99")) {
            bNeedReplacePrefix = true;
            replaceCount = 2;
        } else if (phoneCountryCode.equals("237") && formattedNumber.startsWith("11")) {
            bNeedReplacePrefix = true;
            replaceCount = 2;
        } else if (phoneCountryCode.equals("27") && formattedNumber.startsWith("09")) {
            bNeedReplacePrefix = true;
            replaceCount = 2;
        } else if (phoneCountryCode.equals("57") && formattedNumber.startsWith("60")) {
            bNeedReplacePrefix = true;
            replaceCount = 2;
        } else if (phoneCountryCode.equals("679") && formattedNumber.startsWith("05")) {
            bNeedReplacePrefix = true;
            replaceCount = 2;
        } else if (phoneCountryCode.equals("673") && formattedNumber.startsWith("01")) {
            bNeedReplacePrefix = true;
            replaceCount = 2;
        } else if (formattedNumber.startsWith("00")) {
            bNeedReplacePrefix = true;
            replaceCount = 2;
        }
        if (bNeedReplacePrefix) {
            String number = formattedNumber.substring(replaceCount);
            if (number.startsWith("0")) {
                number = number.substring(1);
            }
            formattedNumber = "+" + number;
            formattedNumber = PhoneNumberUtil.trimZeroAfterCountryCode(formattedNumber);
            return formattedNumber;
        }
        if (StringUtil.isEmptyOrNull(phoneCountryCode)) {
            return formattedNumber;
        }
        if (formattedNumber.startsWith("0")) {
            formattedNumber = phoneCountryCode.equals("39") || phoneCountryCode.equals("378") ? "+" + phoneCountryCode + formattedNumber : "+" + phoneCountryCode + formattedNumber.substring(1);
            return formattedNumber;
        }
        if ("39".equals(phoneCountryCode)) {
            if (formattedNumber.startsWith("3939")) {
                formattedNumber = formattedNumber.substring(2);
            }
        } else if ("48".equals(phoneCountryCode)) {
            if (formattedNumber.startsWith("4848")) {
                formattedNumber = formattedNumber.substring(2);
            }
        } else if ("46".equals(phoneCountryCode)) {
            if (formattedNumber.startsWith("4646")) {
                formattedNumber = formattedNumber.substring(2);
            }
        } else if ("41".equals(phoneCountryCode)) {
            if (formattedNumber.startsWith("4141")) {
                formattedNumber = formattedNumber.substring(2);
            }
        } else if ("36".equals(phoneCountryCode)) {
            if (formattedNumber.startsWith("3636")) {
                formattedNumber = formattedNumber.substring(2);
            }
        } else if ("43".equals(phoneCountryCode)) {
            if (formattedNumber.startsWith("43") && !formattedNumber.startsWith("4352")) {
                formattedNumber = formattedNumber.substring(2);
            }
            if (formattedNumber.startsWith("0")) {
                formattedNumber = formattedNumber.substring(1);
            }
        } else if ("91".equals(phoneCountryCode)) {
            if (formattedNumber.startsWith("9191")) {
                formattedNumber = formattedNumber.substring(2);
            }
        } else if ("63".equals(phoneCountryCode)) {
            if (formattedNumber.startsWith("6363")) {
                formattedNumber = formattedNumber.substring(2);
            }
        } else if ("880".equals(phoneCountryCode)) {
            if (formattedNumber.startsWith("880880")) {
                formattedNumber = formattedNumber.substring(3);
            }
        } else if ("7".equals(phoneCountryCode)) {
            if (formattedNumber.startsWith("7") && !formattedNumber.startsWith("71") && !formattedNumber.startsWith("72") && !formattedNumber.startsWith("73")) {
                formattedNumber = formattedNumber.substring(1);
            }
            if (formattedNumber.startsWith("0")) {
                formattedNumber = formattedNumber.substring(1);
            }
        } else if (formattedNumber.startsWith(phoneCountryCode)) {
            formattedNumber = formattedNumber.substring(phoneCountryCode.length());
            if (!phoneCountryCode.equals("378") && formattedNumber.startsWith("0")) {
                formattedNumber = formattedNumber.substring(1);
            }
        }
        StringBuilder builder2 = new StringBuilder();
        builder2.append('+').append(phoneCountryCode).append(formattedNumber);
        formattedNumber = builder2.toString();
        return formattedNumber;
    }

    public static String getCountryCodeFromFormatedPhoneNumber(String phoneNumber) {
        if (phoneNumber == null || !phoneNumber.startsWith("+")) {
            return null;
        }
        String tmp = phoneNumber.substring(1);
        for (int i = 0; i < CountryCodeUtil.countryCodeTable.length; ++i) {
            String code = String.valueOf(CountryCodeUtil.countryCodeTable[i][1]);
            if (!tmp.startsWith(code)) continue;
            return code;
        }
        return null;
    }

    private static String trimZeroAfterCountryCode(String formatedNumber) {
        String countryCode = PhoneNumberUtil.getCountryCodeFromFormatedPhoneNumber(formatedNumber);
        if (countryCode == null || countryCode.length() == 0) {
            return formatedNumber;
        }
        String number = formatedNumber.substring(countryCode.length() + 1);
        if (number.startsWith("0") && !countryCode.equals("39") && !countryCode.equals("378")) {
            number = number.substring(1);
        }
        return "+" + countryCode + number;
    }

    public static String formatDisplayPhoneNumber(String countryCode, String phoneNum) {
        if (StringUtil.isEmptyOrNull(phoneNum)) {
            return null;
        }
        String formattedNumber = !StringUtil.isEmptyOrNull(countryCode) ? "+" + countryCode + " " + phoneNum : phoneNum;
        if (!StringUtil.isEmptyOrNull(countryCode) && !StringUtil.isEmptyOrNull(phoneNum)) {
            int length = phoneNum.length();
            if (countryCode.equals("1") && (length == 10 || length == 11)) {
                formattedNumber = String.format("+1 (%s) %s-%s", phoneNum.substring(0, 3), length == 11 ? phoneNum.substring(3, 7) : phoneNum.substring(3, 6), length == 11 ? phoneNum.substring(7) : phoneNum.substring(6));
            } else if (countryCode.equals("86") && length == 11) {
                formattedNumber = String.format("+1 (%s) %s-%s", phoneNum.substring(0, 3), phoneNum.substring(3, 7), phoneNum.substring(7));
            }
        }
        return formattedNumber;
    }
}

