/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.text.format.Time;
import android.util.TimeFormatException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.Event;
import us.zoom.androidlib.util.EventLoader;
import us.zoom.androidlib.util.EventRecurrence;

@TargetApi(value=14)
public class MeetingEventLoader {
    private static final String TAG = MeetingEventLoader.class.getSimpleName();
    private EventLoader mEventLoader = null;
    private Context mContext = null;

    public MeetingEventLoader(Context context) {
        if (context == null) {
            throw new RuntimeException("context is null");
        }
        this.mContext = context;
        this.mEventLoader = new EventLoader(context);
    }

    public void startBackgroundThread() {
        this.mEventLoader.startBackgroundThread();
    }

    public void stopBackgroundThread() {
        this.mEventLoader.stopBackgroundThread();
    }

    public void queryMeetingsByDate(int numDays, final ArrayList<MeetingCalendarEvent> meetingEvents, long startDayInMillis, final MeetingDomainFilter filter, final Runnable successCallback, Runnable cancelCallback) {
        if (this.mContext == null) {
            return;
        }
        Time baseDate = new Time(Time.getCurrentTimezone());
        baseDate.set(startDayInMillis);
        int startJulianDay = Time.getJulianDay((long)startDayInMillis, (long)baseDate.gmtoff);
        final ArrayList<Event> events = new ArrayList<Event>();
        this.mEventLoader.loadEventsInBackground(numDays, events, startJulianDay, new Runnable(){

            @Override
            public void run() {
                MeetingEventLoader.this.parseMeetingEvents(meetingEvents, events, filter, successCallback);
            }
        }, cancelCallback);
    }

    private void parseMeetingEvents(ArrayList<MeetingCalendarEvent> meetingEvents, ArrayList<Event> events, MeetingDomainFilter filter, Runnable successCallback) {
        String meetingUrlPattern = "https://.+/j/([0-9]+)([?&]pwd=(\\S[^&\\s\\n<]+))*";
        for (Event event : events) {
            Uri uri;
            String sLocation = event.location != null ? event.location.toString() : null;
            String sDescription = event.description != null ? event.description.toString() : null;
            String sDomain = null;
            String sUrl = null;
            String sId = null;
            String sPassword = null;
            if (sLocation != null && sLocation.matches("https://.+/j/([0-9]+)([?&]pwd=(\\S[^&\\s\\n<]+))*")) {
                sUrl = sLocation;
            } else if (sDescription != null) {
                Pattern pattern = Pattern.compile("https://.+/j/([0-9]+)([?&]pwd=(\\S[^&\\s\\n<]+))*");
                if (pattern == null) continue;
                Matcher matcher = pattern.matcher(sDescription);
                if (matcher != null && matcher.find()) {
                    sUrl = matcher.group(0);
                    sId = matcher.group(1);
                    sPassword = matcher.group(3);
                }
            }
            if (sUrl == null || !filter.isAccepted(sDomain = (uri = Uri.parse((String)sUrl)).getHost())) continue;
            MeetingCalendarEvent meetingEvent = new MeetingCalendarEvent();
            meetingEvent.eventId = event.id;
            meetingEvent.meetingUri = sUrl;
            meetingEvent.meetingPwd = sPassword;
            try {
                meetingEvent.meetingID = Long.parseLong(sId);
            }
            catch (Exception e) {
                continue;
            }
            meetingEvent.beginTime = event.startMillis;
            meetingEvent.endTime = event.endMillis;
            meetingEvent.location = event.location.toString();
            meetingEvent.topic = event.title != null ? event.title.toString() : null;
            meetingEvent.rrule = event.rrule;
            if (event.rrule != null) {
                EventRecurrence er = new EventRecurrence();
                er.parse(event.rrule);
                switch (er.freq) {
                    case 4: {
                        meetingEvent.repeatType = AndroidAppUtil.EventRepeatType.DAILY;
                        this.parseRepeatCountAndUntil(meetingEvent, er);
                        break;
                    }
                    case 5: {
                        if (er.wkst != 0) {
                            meetingEvent.repeatType = AndroidAppUtil.EventRepeatType.UNKNOWN;
                            break;
                        }
                        if (er.interval > 2) {
                            meetingEvent.repeatType = AndroidAppUtil.EventRepeatType.UNKNOWN;
                            break;
                        }
                        if (er.interval == 2) {
                            meetingEvent.repeatType = AndroidAppUtil.EventRepeatType.BIWEEKLY;
                            this.parseRepeatCountAndUntil(meetingEvent, er);
                            break;
                        }
                        meetingEvent.repeatType = AndroidAppUtil.EventRepeatType.WEEKLY;
                        this.parseRepeatCountAndUntil(meetingEvent, er);
                        break;
                    }
                    case 6: {
                        meetingEvent.repeatType = AndroidAppUtil.EventRepeatType.MONTHLY;
                        this.parseRepeatCountAndUntil(meetingEvent, er);
                        break;
                    }
                    case 7: {
                        meetingEvent.repeatType = AndroidAppUtil.EventRepeatType.YEARLY;
                        this.parseRepeatCountAndUntil(meetingEvent, er);
                        break;
                    }
                    default: {
                        meetingEvent.repeatType = AndroidAppUtil.EventRepeatType.UNKNOWN;
                    }
                }
            }
            meetingEvents.add(meetingEvent);
        }
        successCallback.run();
    }

    private void parseRepeatCountAndUntil(MeetingCalendarEvent meetingEvent, EventRecurrence er) {
        meetingEvent.repeatCount = er.count;
        if (er.until != null) {
            try {
                Time until = new Time();
                until.parse(er.until);
                meetingEvent.untilTime = until.toMillis(false);
            }
            catch (TimeFormatException timeFormatException) {
                // empty catch block
            }
        }
    }

    public static interface MeetingDomainFilter {
        public boolean isAccepted(String var1);
    }

    public static class MeetingCalendarEvent {
        public String topic;
        public String location;
        public long meetingID = 0L;
        public String meetingPwd = null;
        public String meetingUri = null;
        public long beginTime = 0L;
        public long endTime = 0L;
        public AndroidAppUtil.EventRepeatType repeatType = AndroidAppUtil.EventRepeatType.NONE;
        public int repeatCount = 0;
        public long untilTime = 0L;
        public String rrule;
        public long eventId = -1L;
    }
}

