/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.support.v4.util.LruCache;
import us.zoom.androidlib.util.StringUtil;

public class ImageCache
implements ComponentCallbacks2 {
    private static ImageCache cache;
    private LruCache<Key, Bitmap> mCaches;

    public static synchronized ImageCache getInstance() {
        if (cache == null) {
            cache = new ImageCache();
        }
        return cache;
    }

    private ImageCache() {
        int MAXMEMONRY = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        this.mCaches = new LruCache<Key, Bitmap>(MAXMEMONRY / 8){

            protected int sizeOf(Key key, Bitmap value) {
                return value.getByteCount() / 1024;
            }

            protected void entryRemoved(boolean evicted, Key key, Bitmap oldValue, Bitmap newValue) {
                super.entryRemoved(evicted, (Object)key, (Object)oldValue, (Object)newValue);
            }
        };
    }

    public void putBitmap(Key key, Bitmap bitmap) {
        if (key == null || bitmap == null) {
            return;
        }
        this.mCaches.put((Object)key, (Object)bitmap);
    }

    public Bitmap getBitmap(Key key) {
        if (key == null) {
            return null;
        }
        Bitmap map = (Bitmap)this.mCaches.get((Object)key);
        if (map != null && map.isRecycled()) {
            this.mCaches.remove((Object)key);
            return null;
        }
        return map;
    }

    public void onConfigurationChanged(Configuration newConfig) {
    }

    public void onLowMemory() {
    }

    public void onTrimMemory(int level) {
        if (level >= 60) {
            this.mCaches.evictAll();
        } else if (level >= 40) {
            this.mCaches.trimToSize(this.mCaches.size() / 2);
        }
    }

    public static class Key {
        private static Key flyWeightInstance = new Key(null, null, 0L);
        String path;
        String subKey;
        long timestamp = 0L;

        public Key(String path, String subKey, long timestamp) {
            this.path = path;
            this.subKey = subKey;
            this.timestamp = timestamp;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key1 = (Key)obj;
            return StringUtil.isSameString(this.path, key1.path) && StringUtil.isSameString(this.subKey, key1.subKey) && this.timestamp == key1.timestamp;
        }

        public int hashCode() {
            return (int)this.timestamp;
        }

        public static Key getFlyweightInstance(String path, String subKey, long timestamp) {
            Key.flyWeightInstance.path = path;
            Key.flyWeightInstance.subKey = subKey;
            Key.flyWeightInstance.timestamp = timestamp;
            return flyWeightInstance;
        }
    }
}

