/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import java.lang.reflect.Field;
import java.util.List;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;

public class HeadsetUtil
extends BroadcastReceiver {
    public static final String TAG = HeadsetUtil.class.getSimpleName();
    private static final String A2DP_ACTION_CONNECTION_STATE_CHANGED = HeadsetUtil.getStaticStringField("android.bluetooth.BluetoothA2dp", "ACTION_CONNECTION_STATE_CHANGED");
    private static final String A2DP_EXTRA_STATE = HeadsetUtil.getStaticStringField("android.bluetooth.BluetoothA2dp", "EXTRA_STATE");
    private static final String BLUETOOTH_ACTION_CONNECTION_STATE_CHANGED = HeadsetUtil.getStaticStringField("android.bluetooth.BluetoothHeadset", "ACTION_CONNECTION_STATE_CHANGED");
    private static final String BLUETOOTH_EXTRA_STATE = HeadsetUtil.getStaticStringField("android.bluetooth.BluetoothProfile", "EXTRA_STATE");
    private static final String ACTION_SCO_AUDIO_STATE_UPDATED = "android.media.ACTION_SCO_AUDIO_STATE_UPDATED";
    private static HeadsetUtil instance = null;
    private static final int BT_STATE_DISCONNECTED = 0;
    private static final int BT_STATE_CONNECTED = 2;
    private static final int BT_STATE_PLAYING = 4;
    private Context mContext;
    private ListenerList mListenerList = new ListenerList();
    private boolean mBluetoothHeadsetOn = false;
    private boolean mWiredHeadsetOn = false;
    private boolean mBluetoothScoAudioOn = false;
    private boolean mIsStartingSco;
    private boolean mIsStoppingSco;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothHeadset mBluetoothHeadset;
    private BluetoothDevice mBluetoothDevice;
    private Object mHeadsetProfileListener;
    private AudioManager mAudioManager;
    private boolean mStartBluetoothScoCalled = false;
    private Handler mHandler = new Handler();

    public static synchronized HeadsetUtil getInstance() {
        if (instance == null) {
            instance = new HeadsetUtil();
        }
        return instance;
    }

    private HeadsetUtil() {
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mHeadsetProfileListener = new BluetoothProfile.ServiceListener(){

            public void onServiceDisconnected(int profile) {
                if (HeadsetUtil.this.mAudioManager != null) {
                    HeadsetUtil.this.mAudioManager.stopBluetoothSco();
                }
                if (HeadsetUtil.this.mBluetoothAdapter != null && HeadsetUtil.this.mBluetoothHeadset != null) {
                    HeadsetUtil.this.mBluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)HeadsetUtil.this.mBluetoothHeadset);
                    HeadsetUtil.this.mBluetoothHeadset = null;
                }
                HeadsetUtil.this.mStartBluetoothScoCalled = false;
                HeadsetUtil.this.resetSco();
                HeadsetUtil.this.checkBTConnectionStatus();
            }

            public void onServiceConnected(int profile, BluetoothProfile proxy) {
                BluetoothHeadset headset = (BluetoothHeadset)proxy;
                HeadsetUtil.this.mBluetoothHeadset = headset;
                List devices = headset.getConnectedDevices();
                if (devices.size() > 0) {
                    HeadsetUtil.this.mBluetoothDevice = (BluetoothDevice)devices.get(0);
                    HeadsetUtil.this.mBluetoothHeadsetOn = true;
                    HeadsetUtil.this.resetSco();
                    HeadsetUtil.this.postNotifyHeadsetConnectionChanged();
                }
            }
        };
    }

    public void initialize(Context context, boolean enableBluetoothScoOnly) {
        this.mContext = context;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.HEADSET_PLUG");
        filter.addAction("android.media.SCO_AUDIO_STATE_CHANGED");
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        if (BLUETOOTH_ACTION_CONNECTION_STATE_CHANGED != null && enableBluetoothScoOnly) {
            filter.addAction(BLUETOOTH_ACTION_CONNECTION_STATE_CHANGED);
        } else if (A2DP_ACTION_CONNECTION_STATE_CHANGED != null) {
            filter.addAction(A2DP_ACTION_CONNECTION_STATE_CHANGED);
        }
        try {
            context.registerReceiver((BroadcastReceiver)this, filter);
            this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
            this.mWiredHeadsetOn = this.mAudioManager.isWiredHeadsetOn();
            boolean bl = this.mBluetoothHeadsetOn = this.mAudioManager.isBluetoothA2dpOn() || this.mAudioManager.isBluetoothScoOn();
            if (enableBluetoothScoOnly) {
                this.mBluetoothAdapter.getProfileProxy(context, (BluetoothProfile.ServiceListener)this.mHeadsetProfileListener, 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addListener(IHeadsetConnectionListener l) {
        this.mListenerList.add(l);
    }

    public void removeListener(IHeadsetConnectionListener l) {
        this.mListenerList.remove(l);
    }

    public void onReceive(Context content, Intent intent) {
        if (A2DP_ACTION_CONNECTION_STATE_CHANGED != null && A2DP_ACTION_CONNECTION_STATE_CHANGED.equals(intent.getAction())) {
            int state = intent.getIntExtra(A2DP_EXTRA_STATE, -1);
            if (state == 2 || state == 4) {
                this.mBluetoothHeadsetOn = true;
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (bluetoothDevice != null) {
                    this.mBluetoothDevice = bluetoothDevice;
                }
                this.postNotifyHeadsetConnectionChanged();
            } else if (state == 0) {
                this.mBluetoothHeadsetOn = false;
                this.mBluetoothScoAudioOn = false;
                this.mStartBluetoothScoCalled = false;
                this.postNotifyHeadsetConnectionChanged();
            }
        } else if ("android.media.SCO_AUDIO_STATE_CHANGED".equals(intent.getAction()) || ACTION_SCO_AUDIO_STATE_UPDATED.equals(intent.getAction())) {
            int state = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
            boolean bl = this.mBluetoothScoAudioOn = state == 1;
            if (state == 1) {
                this.mIsStartingSco = false;
            } else if (state == 0) {
                this.mIsStoppingSco = false;
            } else if (state != 2) {
                this.resetSco();
            }
            if (this.mBluetoothScoAudioOn && !this.mStartBluetoothScoCalled) {
                this.mBluetoothScoAudioOn = false;
            }
            this.notifyBluetoothScoAudioStatus(this.mBluetoothScoAudioOn);
        } else if (BLUETOOTH_ACTION_CONNECTION_STATE_CHANGED != null && BLUETOOTH_ACTION_CONNECTION_STATE_CHANGED.equals(intent.getAction())) {
            int state = intent.getIntExtra(BLUETOOTH_EXTRA_STATE, -1);
            if (state == 2 || state == 4) {
                this.mBluetoothHeadsetOn = true;
                BluetoothDevice bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (bluetoothDevice != null) {
                    this.mBluetoothDevice = bluetoothDevice;
                }
                this.postNotifyHeadsetConnectionChanged();
            } else if (state == 0) {
                this.mStartBluetoothScoCalled = false;
                this.checkBTConnectionStatus();
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        HeadsetUtil.this.checkBTConnectionStatus();
                    }
                }, 3000L);
            }
        } else if ("android.intent.action.HEADSET_PLUG".equals(intent.getAction())) {
            this.mWiredHeadsetOn = intent.getIntExtra("state", -1) == 1;
            this.postNotifyHeadsetConnectionChanged();
        } else if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction())) {
            int blueState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
            switch (blueState) {
                case 12: {
                    if (this.mBluetoothAdapter == null || this.mBluetoothHeadset != null) break;
                    this.resetSco();
                    this.mBluetoothAdapter.getProfileProxy(this.mContext, (BluetoothProfile.ServiceListener)this.mHeadsetProfileListener, 1);
                }
            }
        }
    }

    private boolean hasBlueHeadSet() {
        return this.mBluetoothAdapter != null && this.mBluetoothAdapter.isEnabled() && this.mBluetoothHeadset != null && !CollectionsUtil.isListEmpty(this.mBluetoothHeadset.getConnectedDevices());
    }

    public boolean ismIsStartingSco() {
        return this.mIsStartingSco;
    }

    public boolean ismIsStoppingSco() {
        return this.mIsStoppingSco;
    }

    public String getConnectedBTName() {
        if (this.mBluetoothDevice != null) {
            return this.mBluetoothDevice.getName();
        }
        return null;
    }

    private void checkBTConnectionStatus() {
        boolean oldHeadsetOn = this.mBluetoothHeadsetOn;
        boolean oldScoOn = this.mBluetoothScoAudioOn;
        boolean hasBlueHeadSet = this.hasBlueHeadSet();
        if (!hasBlueHeadSet && this.mAudioManager.isBluetoothScoOn()) {
            this.mAudioManager.stopBluetoothSco();
        }
        if (this.mAudioManager != null) {
            boolean bl = this.mBluetoothHeadsetOn = hasBlueHeadSet && (this.mAudioManager.isBluetoothA2dpOn() || this.mAudioManager.isBluetoothScoOn());
        }
        if (this.mAudioManager != null) {
            boolean bl = this.mBluetoothScoAudioOn = hasBlueHeadSet && this.mAudioManager.isBluetoothScoOn();
        }
        if (oldScoOn != this.mBluetoothScoAudioOn) {
            this.notifyBluetoothScoAudioStatus(this.mBluetoothScoAudioOn);
        }
        if (oldHeadsetOn != this.mBluetoothHeadsetOn) {
            this.postNotifyHeadsetConnectionChanged();
        }
    }

    public boolean isBluetoothHeadsetOn() {
        return this.mBluetoothHeadsetOn;
    }

    public boolean isWiredHeadsetOn() {
        return this.mWiredHeadsetOn;
    }

    public boolean isBluetoothScoAudioOn() {
        return this.mBluetoothScoAudioOn;
    }

    public boolean isBTAndWiredHeadsetsOn() {
        return this.isBluetoothHeadsetOn() && this.isWiredHeadsetOn();
    }

    public void startBluetoothSco() {
        if (this.mContext == null) {
            return;
        }
        if (this.mAudioManager == null) {
            try {
                this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mAudioManager == null) {
            return;
        }
        try {
            if (!this.mAudioManager.isBluetoothScoOn()) {
                this.mIsStartingSco = true;
                this.mAudioManager.startBluetoothSco();
            }
        }
        catch (Exception e) {
            this.mIsStartingSco = false;
        }
        this.mStartBluetoothScoCalled = true;
    }

    public void stopBluetoothSco() {
        if (this.mContext == null) {
            return;
        }
        if (this.mAudioManager == null) {
            try {
                this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mAudioManager == null) {
            return;
        }
        this.mIsStoppingSco = true;
        this.mAudioManager.stopBluetoothSco();
        this.mStartBluetoothScoCalled = false;
        this.mBluetoothScoAudioOn = false;
    }

    private void postNotifyHeadsetConnectionChanged() {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                HeadsetUtil.this.notifyHeadsetConnectionChanged(HeadsetUtil.this.mWiredHeadsetOn, HeadsetUtil.this.mBluetoothHeadsetOn);
            }
        }, 500L);
    }

    private void notifyHeadsetConnectionChanged(boolean wiredHeadsetOn, boolean bluetoothHeadsetOn) {
        IListener[] listeners;
        for (IListener l : listeners = this.mListenerList.getAll()) {
            IHeadsetConnectionListener listener = (IHeadsetConnectionListener)l;
            listener.onHeadsetStatusChanged(wiredHeadsetOn, bluetoothHeadsetOn);
        }
    }

    private void notifyBluetoothScoAudioStatus(boolean on) {
        IListener[] listeners;
        for (IListener l : listeners = this.mListenerList.getAll()) {
            IHeadsetConnectionListener listener = (IHeadsetConnectionListener)l;
            listener.onBluetoothScoAudioStatus(on);
        }
    }

    private void resetSco() {
        this.mIsStartingSco = false;
        this.mIsStoppingSco = false;
    }

    public void enterA2dpMode() {
        this.resetSco();
        this.notifyBluetoothScoAudioStatus(this.mBluetoothScoAudioOn);
    }

    private static String getStaticStringField(String className, String fieldName) {
        Class<?> clazz = null;
        Field field = null;
        String value = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            field = clazz.getField(fieldName);
        }
        catch (Exception e) {
            return null;
        }
        try {
            value = (String)field.get(clazz);
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    public static interface IHeadsetConnectionListener
    extends IListener {
        public void onHeadsetStatusChanged(boolean var1, boolean var2);

        public void onBluetoothScoAudioStatus(boolean var1);
    }
}

