/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.app.KeyguardManager;
import android.hardware.fingerprint.FingerprintManager;
import android.os.CancellationSignal;
import android.support.annotation.RequiresApi;
import us.zoom.androidlib.app.ZMActivity;

public class FingerprintUtil {
    private FingerprintManager mFingerprintManager;
    private KeyguardManager mKeyManager;
    private CancellationSignal mCancellationSignal;
    private ZMActivity mActivity;

    @RequiresApi(api=23)
    public FingerprintUtil(ZMActivity ctx) {
        this.mActivity = ctx;
        this.mFingerprintManager = (FingerprintManager)ctx.getSystemService(FingerprintManager.class);
        this.mKeyManager = (KeyguardManager)this.mActivity.getSystemService("keyguard");
    }

    @RequiresApi(api=23)
    public void callFingerPrintVerify(final IFingerprintResultListener listener) {
        if (!this.isHardwareDetected()) {
            if (listener != null) {
                listener.onNoHardwareDetected();
            }
            return;
        }
        if (!this.isHasEnrolledFingerprints()) {
            if (listener != null) {
                listener.onNoEnroll();
            }
            return;
        }
        if (!this.isKeyguardSecure()) {
            if (listener != null) {
                listener.onInSecurity();
            }
            return;
        }
        if (listener != null) {
            listener.onSupport();
        }
        if (listener != null) {
            listener.onAuthenticateStart();
        }
        if (this.mCancellationSignal == null) {
            this.mCancellationSignal = new CancellationSignal();
        }
        try {
            this.mFingerprintManager.authenticate(null, this.mCancellationSignal, 0, new FingerprintManager.AuthenticationCallback(){

                public void onAuthenticationError(int errMsgId, CharSequence errString) {
                    if (listener != null) {
                        listener.onAuthenticateError(errMsgId, errString);
                    }
                }

                public void onAuthenticationFailed() {
                    if (listener != null) {
                        listener.onAuthenticateFailed();
                    }
                }

                public void onAuthenticationHelp(int helpMsgId, CharSequence helpString) {
                    if (listener != null) {
                        listener.onAuthenticateHelp(helpMsgId, helpString);
                    }
                }

                public void onAuthenticationSucceeded(FingerprintManager.AuthenticationResult result) {
                    if (listener != null) {
                        listener.onAuthenticateSucceeded(result);
                    }
                }
            }, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequiresApi(api=23)
    public boolean isSupportFingerprint() {
        return this.isHardwareDetected() && this.isKeyguardSecure() && this.isHasEnrolledFingerprints();
    }

    @RequiresApi(api=23)
    private boolean isHasEnrolledFingerprints() {
        try {
            return this.mFingerprintManager.hasEnrolledFingerprints();
        }
        catch (Exception e) {
            return false;
        }
    }

    @RequiresApi(api=23)
    public boolean isHardwareDetected() {
        try {
            return this.mFingerprintManager.isHardwareDetected();
        }
        catch (Exception e) {
            return false;
        }
    }

    @RequiresApi(api=16)
    private boolean isKeyguardSecure() {
        try {
            return this.mKeyManager.isKeyguardSecure();
        }
        catch (Exception e) {
            return false;
        }
    }

    @RequiresApi(api=16)
    public void cancelAuthenticate() {
        if (this.mCancellationSignal != null) {
            this.mCancellationSignal.cancel();
            this.mCancellationSignal = null;
        }
    }

    @RequiresApi(api=16)
    public void onDestroy() {
        this.cancelAuthenticate();
        this.mKeyManager = null;
        this.mFingerprintManager = null;
    }

    public static interface IFingerprintResultListener {
        public void onNoHardwareDetected();

        public void onInSecurity();

        public void onNoEnroll();

        public void onSupport();

        public void onAuthenticateStart();

        public void onAuthenticateError(int var1, CharSequence var2);

        public void onAuthenticateFailed();

        public void onAuthenticateHelp(int var1, CharSequence var2);

        public void onAuthenticateSucceeded(FingerprintManager.AuthenticationResult var1);
    }
}

