/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.os.Handler;
import android.os.Looper;
import java.util.Vector;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;

public final class EventTaskManager {
    private static final String TAG = EventTaskManager.class.getSimpleName();
    private Vector<EventTask> mCachedTasks;
    private IUIElement mUI;
    private Handler mHandler = new Handler();
    private boolean mDestroyed = false;

    public EventTaskManager() {
        this.mCachedTasks = new Vector();
    }

    public void destroy() {
        this.mCachedTasks.clear();
        this.mDestroyed = true;
        this.mUI = null;
    }

    public void onPause(IUIElement ui) {
        this.mUI = null;
    }

    public void onResume(IUIElement ui) {
        this.mDestroyed = false;
        this.mUI = ui;
        this.executeCachedTasks();
    }

    public void onStart(IUIElement ui) {
    }

    public void onStop(IUIElement ui) {
        this.mUI = null;
    }

    public void onUIDestroy(IUIElement ui) {
        this.mUI = null;
    }

    public boolean isUIActive() {
        return this.mUI != null;
    }

    public boolean hasPendingTask() {
        return this.mCachedTasks.size() > 0;
    }

    public void push(EventAction action) {
        this.push(null, action, false);
    }

    public void push(String uniqueId, EventAction action) {
        this.push(uniqueId, action, false);
    }

    public void pushLater(EventAction action) {
        this.push(null, action, true);
    }

    public void pushLater(String uniqueId, EventAction action) {
        this.push(uniqueId, action, true);
    }

    private void push(final String uniqueId, final EventAction action, boolean later) {
        if (action == null) {
            return;
        }
        if (this.mDestroyed) {
            return;
        }
        if (!later && Thread.currentThread().getId() == Looper.getMainLooper().getThread().getId()) {
            this.pushOnUiThread(uniqueId, action);
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    EventTaskManager.this.pushOnUiThread(uniqueId, action);
                }
            });
        }
    }

    private void pushOnUiThread(String uniqueId, EventAction action) {
        if (this.mDestroyed) {
            return;
        }
        if (this.isUIActive()) {
            this.executeTask(action);
        } else {
            this.cacheTask(uniqueId, action);
        }
    }

    private void executeTask(EventAction action) {
        action.run(this.mUI);
    }

    private void cacheTask(String uniqueId, EventAction action) {
        EventTask task = new EventTask(uniqueId, action);
        if (uniqueId == null || uniqueId.length() == 0) {
            this.mCachedTasks.add(task);
            return;
        }
        this.removePrevUniqueTask(uniqueId);
        this.mCachedTasks.add(task);
    }

    private void removePrevUniqueTask(String uniqueId) {
        for (int i = 0; i < this.mCachedTasks.size(); ++i) {
            EventTask taskItem = this.mCachedTasks.get(i);
            if (!uniqueId.equals(taskItem.id)) continue;
            this.mCachedTasks.remove(i);
            break;
        }
    }

    private void executeCachedTasks() {
        for (EventTask taskItem : this.mCachedTasks) {
            this.executeTask(taskItem.action);
        }
        this.mCachedTasks.clear();
    }

    class EventTask {
        String id;
        EventAction action;

        EventTask(String id2, EventAction action) {
            this.id = id2;
            this.action = action;
        }
    }
}

