/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;
import java.util.HashMap;

public class EventRecurrence {
    private static String TAG = "EventRecur";
    public static final int SECONDLY = 1;
    public static final int MINUTELY = 2;
    public static final int HOURLY = 3;
    public static final int DAILY = 4;
    public static final int WEEKLY = 5;
    public static final int MONTHLY = 6;
    public static final int YEARLY = 7;
    public static final int SU = 65536;
    public static final int MO = 131072;
    public static final int TU = 262144;
    public static final int WE = 524288;
    public static final int TH = 0x100000;
    public static final int FR = 0x200000;
    public static final int SA = 0x400000;
    public Time startDate;
    public int freq;
    public String until;
    public int count;
    public int interval;
    public int wkst;
    public int[] bysecond;
    public int bysecondCount;
    public int[] byminute;
    public int byminuteCount;
    public int[] byhour;
    public int byhourCount;
    public int[] byday;
    public int[] bydayNum;
    public int bydayCount;
    public int[] bymonthday;
    public int bymonthdayCount;
    public int[] byyearday;
    public int byyeardayCount;
    public int[] byweekno;
    public int byweeknoCount;
    public int[] bymonth;
    public int bymonthCount;
    public int[] bysetpos;
    public int bysetposCount;
    private static HashMap<String, PartParser> sParsePartMap = new HashMap();
    private static final int PARSED_FREQ = 1;
    private static final int PARSED_UNTIL = 2;
    private static final int PARSED_COUNT = 4;
    private static final int PARSED_INTERVAL = 8;
    private static final int PARSED_BYSECOND = 16;
    private static final int PARSED_BYMINUTE = 32;
    private static final int PARSED_BYHOUR = 64;
    private static final int PARSED_BYDAY = 128;
    private static final int PARSED_BYMONTHDAY = 256;
    private static final int PARSED_BYYEARDAY = 512;
    private static final int PARSED_BYWEEKNO = 1024;
    private static final int PARSED_BYMONTH = 2048;
    private static final int PARSED_BYSETPOS = 4096;
    private static final int PARSED_WKST = 8192;
    private static final HashMap<String, Integer> sParseFreqMap;
    private static final HashMap<String, Integer> sParseWeekdayMap;
    private static final boolean ALLOW_LOWER_CASE = false;
    private static final boolean VALIDATE_UNTIL = false;
    private static final boolean ONLY_ONE_UNTIL_COUNT = false;

    public void setStartDate(Time date) {
        this.startDate = date;
    }

    public static int calendarDay2Day(int day) {
        switch (day) {
            case 1: {
                return 65536;
            }
            case 2: {
                return 131072;
            }
            case 3: {
                return 262144;
            }
            case 4: {
                return 524288;
            }
            case 5: {
                return 0x100000;
            }
            case 6: {
                return 0x200000;
            }
            case 7: {
                return 0x400000;
            }
        }
        throw new RuntimeException("bad day of week: " + day);
    }

    public static int timeDay2Day(int day) {
        switch (day) {
            case 0: {
                return 65536;
            }
            case 1: {
                return 131072;
            }
            case 2: {
                return 262144;
            }
            case 3: {
                return 524288;
            }
            case 4: {
                return 0x100000;
            }
            case 5: {
                return 0x200000;
            }
            case 6: {
                return 0x400000;
            }
        }
        throw new RuntimeException("bad day of week: " + day);
    }

    public static int day2TimeDay(int day) {
        switch (day) {
            case 65536: {
                return 0;
            }
            case 131072: {
                return 1;
            }
            case 262144: {
                return 2;
            }
            case 524288: {
                return 3;
            }
            case 0x100000: {
                return 4;
            }
            case 0x200000: {
                return 5;
            }
            case 0x400000: {
                return 6;
            }
        }
        throw new RuntimeException("bad day of week: " + day);
    }

    public static int day2CalendarDay(int day) {
        switch (day) {
            case 65536: {
                return 1;
            }
            case 131072: {
                return 2;
            }
            case 262144: {
                return 3;
            }
            case 524288: {
                return 4;
            }
            case 0x100000: {
                return 5;
            }
            case 0x200000: {
                return 6;
            }
            case 0x400000: {
                return 7;
            }
        }
        throw new RuntimeException("bad day of week: " + day);
    }

    private static String day2String(int day) {
        switch (day) {
            case 65536: {
                return "SU";
            }
            case 131072: {
                return "MO";
            }
            case 262144: {
                return "TU";
            }
            case 524288: {
                return "WE";
            }
            case 0x100000: {
                return "TH";
            }
            case 0x200000: {
                return "FR";
            }
            case 0x400000: {
                return "SA";
            }
        }
        throw new IllegalArgumentException("bad day argument: " + day);
    }

    private static void appendNumbers(StringBuilder s, String label, int count, int[] values) {
        if (count > 0) {
            s.append(label);
            --count;
            for (int i = 0; i < count; ++i) {
                s.append(values[i]);
                s.append(",");
            }
            s.append(values[count]);
        }
    }

    private void appendByDay(StringBuilder s, int i) {
        int n = this.bydayNum[i];
        if (n != 0) {
            s.append(n);
        }
        String str = EventRecurrence.day2String(this.byday[i]);
        s.append(str);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("FREQ=");
        switch (this.freq) {
            case 1: {
                s.append("SECONDLY");
                break;
            }
            case 2: {
                s.append("MINUTELY");
                break;
            }
            case 3: {
                s.append("HOURLY");
                break;
            }
            case 4: {
                s.append("DAILY");
                break;
            }
            case 5: {
                s.append("WEEKLY");
                break;
            }
            case 6: {
                s.append("MONTHLY");
                break;
            }
            case 7: {
                s.append("YEARLY");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.until)) {
            s.append(";UNTIL=");
            s.append(this.until);
        }
        if (this.count != 0) {
            s.append(";COUNT=");
            s.append(this.count);
        }
        if (this.interval != 0) {
            s.append(";INTERVAL=");
            s.append(this.interval);
        }
        if (this.wkst != 0) {
            s.append(";WKST=");
            s.append(EventRecurrence.day2String(this.wkst));
        }
        EventRecurrence.appendNumbers(s, ";BYSECOND=", this.bysecondCount, this.bysecond);
        EventRecurrence.appendNumbers(s, ";BYMINUTE=", this.byminuteCount, this.byminute);
        EventRecurrence.appendNumbers(s, ";BYSECOND=", this.byhourCount, this.byhour);
        int count = this.bydayCount;
        if (count > 0) {
            s.append(";BYDAY=");
            --count;
            for (int i = 0; i < count; ++i) {
                this.appendByDay(s, i);
                s.append(",");
            }
            this.appendByDay(s, count);
        }
        EventRecurrence.appendNumbers(s, ";BYMONTHDAY=", this.bymonthdayCount, this.bymonthday);
        EventRecurrence.appendNumbers(s, ";BYYEARDAY=", this.byyeardayCount, this.byyearday);
        EventRecurrence.appendNumbers(s, ";BYWEEKNO=", this.byweeknoCount, this.byweekno);
        EventRecurrence.appendNumbers(s, ";BYMONTH=", this.bymonthCount, this.bymonth);
        EventRecurrence.appendNumbers(s, ";BYSETPOS=", this.bysetposCount, this.bysetpos);
        return s.toString();
    }

    public boolean repeatsOnEveryWeekDay() {
        if (this.freq != 5) {
            return false;
        }
        int count = this.bydayCount;
        if (count != 5) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            int day = this.byday[i];
            if (day != 65536 && day != 0x400000) continue;
            return false;
        }
        return true;
    }

    public boolean repeatsMonthlyOnDayCount() {
        if (this.freq != 6) {
            return false;
        }
        if (this.bydayCount != 1 || this.bymonthdayCount != 0) {
            return false;
        }
        return this.bydayNum[0] > 0;
    }

    private static boolean arraysEqual(int[] array1, int count1, int[] array2, int count2) {
        if (count1 != count2) {
            return false;
        }
        for (int i = 0; i < count1; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventRecurrence)) {
            return false;
        }
        EventRecurrence er = (EventRecurrence)obj;
        return (this.startDate == null ? er.startDate == null : Time.compare((Time)this.startDate, (Time)er.startDate) == 0) && this.freq == er.freq && (this.until == null ? er.until == null : this.until.equals(er.until)) && this.count == er.count && this.interval == er.interval && this.wkst == er.wkst && EventRecurrence.arraysEqual(this.bysecond, this.bysecondCount, er.bysecond, er.bysecondCount) && EventRecurrence.arraysEqual(this.byminute, this.byminuteCount, er.byminute, er.byminuteCount) && EventRecurrence.arraysEqual(this.byhour, this.byhourCount, er.byhour, er.byhourCount) && EventRecurrence.arraysEqual(this.byday, this.bydayCount, er.byday, er.bydayCount) && EventRecurrence.arraysEqual(this.bydayNum, this.bydayCount, er.bydayNum, er.bydayCount) && EventRecurrence.arraysEqual(this.bymonthday, this.bymonthdayCount, er.bymonthday, er.bymonthdayCount) && EventRecurrence.arraysEqual(this.byyearday, this.byyeardayCount, er.byyearday, er.byyeardayCount) && EventRecurrence.arraysEqual(this.byweekno, this.byweeknoCount, er.byweekno, er.byweeknoCount) && EventRecurrence.arraysEqual(this.bymonth, this.bymonthCount, er.bymonth, er.bymonthCount) && EventRecurrence.arraysEqual(this.bysetpos, this.bysetposCount, er.bysetpos, er.bysetposCount);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    private void resetFields() {
        this.until = null;
        this.bysetposCount = 0;
        this.bymonthCount = 0;
        this.byweeknoCount = 0;
        this.byyeardayCount = 0;
        this.bymonthdayCount = 0;
        this.bydayCount = 0;
        this.byhourCount = 0;
        this.byminuteCount = 0;
        this.bysecondCount = 0;
        this.interval = 0;
        this.count = 0;
        this.freq = 0;
    }

    public void parse(String recur) {
        String[] parts;
        this.resetFields();
        int parseFlags = 0;
        for (String part : parts = recur.split(";")) {
            int equalIndex = part.indexOf(61);
            if (equalIndex <= 0) {
                throw new InvalidFormatException("Missing LHS in " + part);
            }
            String lhs = part.substring(0, equalIndex);
            String rhs = part.substring(equalIndex + 1);
            if (rhs.length() == 0) {
                throw new InvalidFormatException("Missing RHS in " + part);
            }
            PartParser parser = sParsePartMap.get(lhs);
            if (parser == null) {
                if (lhs.startsWith("X-")) continue;
                throw new InvalidFormatException("Couldn't find parser for " + lhs);
            }
            int flag = parser.parsePart(rhs, this);
            if ((parseFlags & flag) != 0) {
                throw new InvalidFormatException("Part " + lhs + " was specified twice");
            }
            parseFlags |= flag;
        }
        if ((parseFlags & 0x2000) == 0) {
            this.wkst = 131072;
        }
        if ((parseFlags & 1) == 0) {
            throw new InvalidFormatException("Must specify a FREQ value");
        }
        if ((parseFlags & 6) == 6) {
            Log.w((String)TAG, (String)("Warning: rrule has both UNTIL and COUNT: " + recur));
        }
    }

    static {
        sParsePartMap.put("FREQ", new ParseFreq());
        sParsePartMap.put("UNTIL", new ParseUntil());
        sParsePartMap.put("COUNT", new ParseCount());
        sParsePartMap.put("INTERVAL", new ParseInterval());
        sParsePartMap.put("BYSECOND", new ParseBySecond());
        sParsePartMap.put("BYMINUTE", new ParseByMinute());
        sParsePartMap.put("BYHOUR", new ParseByHour());
        sParsePartMap.put("BYDAY", new ParseByDay());
        sParsePartMap.put("BYMONTHDAY", new ParseByMonthDay());
        sParsePartMap.put("BYYEARDAY", new ParseByYearDay());
        sParsePartMap.put("BYWEEKNO", new ParseByWeekNo());
        sParsePartMap.put("BYMONTH", new ParseByMonth());
        sParsePartMap.put("BYSETPOS", new ParseBySetPos());
        sParsePartMap.put("WKST", new ParseWkst());
        sParseFreqMap = new HashMap();
        sParseFreqMap.put("SECONDLY", 1);
        sParseFreqMap.put("MINUTELY", 2);
        sParseFreqMap.put("HOURLY", 3);
        sParseFreqMap.put("DAILY", 4);
        sParseFreqMap.put("WEEKLY", 5);
        sParseFreqMap.put("MONTHLY", 6);
        sParseFreqMap.put("YEARLY", 7);
        sParseWeekdayMap = new HashMap();
        sParseWeekdayMap.put("SU", 65536);
        sParseWeekdayMap.put("MO", 131072);
        sParseWeekdayMap.put("TU", 262144);
        sParseWeekdayMap.put("WE", 524288);
        sParseWeekdayMap.put("TH", 0x100000);
        sParseWeekdayMap.put("FR", 0x200000);
        sParseWeekdayMap.put("SA", 0x400000);
    }

    private static class ParseWkst
    extends PartParser {
        private ParseWkst() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            Integer wkst = (Integer)sParseWeekdayMap.get(value);
            if (wkst == null) {
                throw new InvalidFormatException("Invalid WKST value: " + value);
            }
            er.wkst = wkst;
            return 8192;
        }
    }

    private static class ParseBySetPos
    extends PartParser {
        private ParseBySetPos() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            int[] bysetpos = ParseBySetPos.parseNumberList(value, Integer.MIN_VALUE, Integer.MAX_VALUE, true);
            er.bysetpos = bysetpos;
            er.bysetposCount = bysetpos.length;
            return 4096;
        }
    }

    private static class ParseByMonth
    extends PartParser {
        private ParseByMonth() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            int[] bymonth = ParseByMonth.parseNumberList(value, 1, 12, false);
            er.bymonth = bymonth;
            er.bymonthCount = bymonth.length;
            return 2048;
        }
    }

    private static class ParseByWeekNo
    extends PartParser {
        private ParseByWeekNo() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            int[] byweekno = ParseByWeekNo.parseNumberList(value, -53, 53, false);
            er.byweekno = byweekno;
            er.byweeknoCount = byweekno.length;
            return 1024;
        }
    }

    private static class ParseByYearDay
    extends PartParser {
        private ParseByYearDay() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            int[] byyearday = ParseByYearDay.parseNumberList(value, -366, 366, false);
            er.byyearday = byyearday;
            er.byyeardayCount = byyearday.length;
            return 512;
        }
    }

    private static class ParseByMonthDay
    extends PartParser {
        private ParseByMonthDay() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            int[] bymonthday = ParseByMonthDay.parseNumberList(value, -31, 31, false);
            er.bymonthday = bymonthday;
            er.bymonthdayCount = bymonthday.length;
            return 256;
        }
    }

    private static class ParseByDay
    extends PartParser {
        private ParseByDay() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            int[] bydayNum;
            int[] byday;
            int bydayCount;
            if (value.indexOf(",") < 0) {
                bydayCount = 1;
                byday = new int[1];
                bydayNum = new int[1];
                ParseByDay.parseWday(value, byday, bydayNum, 0);
            } else {
                int len;
                String[] wdays = value.split(",");
                bydayCount = len = wdays.length;
                byday = new int[len];
                bydayNum = new int[len];
                for (int i = 0; i < len; ++i) {
                    ParseByDay.parseWday(wdays[i], byday, bydayNum, i);
                }
            }
            er.byday = byday;
            er.bydayNum = bydayNum;
            er.bydayCount = bydayCount;
            return 128;
        }

        private static void parseWday(String str, int[] byday, int[] bydayNum, int index) {
            String wdayStr;
            int wdayStrStart = str.length() - 2;
            if (wdayStrStart > 0) {
                int num;
                String numPart = str.substring(0, wdayStrStart);
                bydayNum[index] = num = ParseByDay.parseIntRange(numPart, -53, 53, false);
                wdayStr = str.substring(wdayStrStart);
            } else {
                wdayStr = str;
            }
            Integer wday = (Integer)sParseWeekdayMap.get(wdayStr);
            if (wday == null) {
                throw new InvalidFormatException("Invalid BYDAY value: " + str);
            }
            byday[index] = wday;
        }
    }

    private static class ParseByHour
    extends PartParser {
        private ParseByHour() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            int[] byhour = ParseByHour.parseNumberList(value, 0, 23, true);
            er.byhour = byhour;
            er.byhourCount = byhour.length;
            return 64;
        }
    }

    private static class ParseByMinute
    extends PartParser {
        private ParseByMinute() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            int[] byminute = ParseByMinute.parseNumberList(value, 0, 59, true);
            er.byminute = byminute;
            er.byminuteCount = byminute.length;
            return 32;
        }
    }

    private static class ParseBySecond
    extends PartParser {
        private ParseBySecond() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            int[] bysecond = ParseBySecond.parseNumberList(value, 0, 59, true);
            er.bysecond = bysecond;
            er.bysecondCount = bysecond.length;
            return 16;
        }
    }

    private static class ParseInterval
    extends PartParser {
        private ParseInterval() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            er.interval = ParseInterval.parseIntRange(value, 1, Integer.MAX_VALUE, false);
            return 8;
        }
    }

    private static class ParseCount
    extends PartParser {
        private ParseCount() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            er.count = ParseCount.parseIntRange(value, 0, Integer.MAX_VALUE, true);
            return 4;
        }
    }

    private static class ParseUntil
    extends PartParser {
        private ParseUntil() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            er.until = value;
            return 2;
        }
    }

    private static class ParseFreq
    extends PartParser {
        private ParseFreq() {
        }

        @Override
        public int parsePart(String value, EventRecurrence er) {
            Integer freq = (Integer)sParseFreqMap.get(value);
            if (freq == null) {
                throw new InvalidFormatException("Invalid FREQ value: " + value);
            }
            er.freq = freq;
            return 1;
        }
    }

    static abstract class PartParser {
        PartParser() {
        }

        public abstract int parsePart(String var1, EventRecurrence var2);

        public static int parseIntRange(String str, int minVal, int maxVal, boolean allowZero) {
            try {
                int val;
                if (str.charAt(0) == '+') {
                    str = str.substring(1);
                }
                if ((val = Integer.parseInt(str)) < minVal || val > maxVal || val == 0 && !allowZero) {
                    throw new InvalidFormatException("Integer value out of range: " + str);
                }
                return val;
            }
            catch (NumberFormatException nfe) {
                throw new InvalidFormatException("Invalid integer value: " + str);
            }
        }

        public static int[] parseNumberList(String listStr, int minVal, int maxVal, boolean allowZero) {
            int[] values;
            if (listStr.indexOf(",") < 0) {
                values = new int[]{PartParser.parseIntRange(listStr, minVal, maxVal, allowZero)};
            } else {
                String[] valueStrs = listStr.split(",");
                int len = valueStrs.length;
                values = new int[len];
                for (int i = 0; i < len; ++i) {
                    values[i] = PartParser.parseIntRange(valueStrs[i], minVal, maxVal, allowZero);
                }
            }
            return values;
        }
    }

    public static class InvalidFormatException
    extends RuntimeException {
        InvalidFormatException(String s) {
            super(s);
        }
    }
}

