/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.os.Handler;
import android.os.Process;
import android.provider.CalendarContract;
import android.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import us.zoom.androidlib.util.Event;

@TargetApi(value=14)
public class EventLoader {
    private Context mContext;
    private Handler mHandler = new Handler();
    private AtomicInteger mSequenceNumber = new AtomicInteger();
    private LinkedBlockingQueue<LoadRequest> mLoaderQueue;
    private LoaderThread mLoaderThread;
    private ContentResolver mResolver;

    public EventLoader(Context context) {
        this.mContext = context;
        this.mLoaderQueue = new LinkedBlockingQueue();
        this.mResolver = context.getContentResolver();
    }

    public void startBackgroundThread() {
        this.mLoaderThread = new LoaderThread(this.mLoaderQueue, this);
        this.mLoaderThread.start();
    }

    public void stopBackgroundThread() {
        this.mLoaderThread.shutdown();
    }

    public void loadEventsInBackground(int numDays, ArrayList<Event> events, int startDay, Runnable successCallback, Runnable cancelCallback) {
        int id2 = this.mSequenceNumber.incrementAndGet();
        LoadEventsRequest request = new LoadEventsRequest(id2, startDay, numDays, events, successCallback, cancelCallback);
        try {
            this.mLoaderQueue.put(request);
        }
        catch (InterruptedException ex) {
            Log.e((String)"Cal", (String)"loadEventsInBackground() interrupted!");
        }
    }

    void loadEventDaysInBackground(int startDay, int numDays, boolean[] eventDays, Runnable uiCallback) {
        LoadEventDaysRequest request = new LoadEventDaysRequest(startDay, numDays, eventDays, uiCallback);
        try {
            this.mLoaderQueue.put(request);
        }
        catch (InterruptedException ex) {
            Log.e((String)"Cal", (String)"loadEventDaysInBackground() interrupted!");
        }
    }

    private static class LoaderThread
    extends Thread {
        LinkedBlockingQueue<LoadRequest> mQueue;
        EventLoader mEventLoader;

        public LoaderThread(LinkedBlockingQueue<LoadRequest> queue, EventLoader eventLoader) {
            this.mQueue = queue;
            this.mEventLoader = eventLoader;
        }

        public void shutdown() {
            try {
                this.mQueue.put(new ShutdownRequest());
            }
            catch (InterruptedException ex) {
                Log.e((String)"Cal", (String)"LoaderThread.shutdown() interrupted!");
            }
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            while (true) {
                try {
                    while (true) {
                        LoadRequest request = this.mQueue.take();
                        while (!this.mQueue.isEmpty()) {
                            request.skipRequest(this.mEventLoader);
                            request = this.mQueue.take();
                        }
                        if (request instanceof ShutdownRequest) {
                            return;
                        }
                        request.processRequest(this.mEventLoader);
                    }
                }
                catch (InterruptedException ex) {
                    Log.e((String)"Cal", (String)"background LoaderThread interrupted!");
                    continue;
                }
                break;
            }
        }
    }

    private static class LoadEventsRequest
    implements LoadRequest {
        public int id;
        public int startDay;
        public int numDays;
        public ArrayList<Event> events;
        public Runnable successCallback;
        public Runnable cancelCallback;

        public LoadEventsRequest(int id2, int startDay, int numDays, ArrayList<Event> events, Runnable successCallback, Runnable cancelCallback) {
            this.id = id2;
            this.startDay = startDay;
            this.numDays = numDays;
            this.events = events;
            this.successCallback = successCallback;
            this.cancelCallback = cancelCallback;
        }

        @Override
        public void processRequest(EventLoader eventLoader) {
            Event.loadEvents(eventLoader.mContext, this.events, this.startDay, this.numDays, this.id, eventLoader.mSequenceNumber);
            if (this.id == eventLoader.mSequenceNumber.get()) {
                eventLoader.mHandler.post(this.successCallback);
            } else {
                eventLoader.mHandler.post(this.cancelCallback);
            }
        }

        @Override
        public void skipRequest(EventLoader eventLoader) {
            eventLoader.mHandler.post(this.cancelCallback);
        }
    }

    private static class LoadEventDaysRequest
    implements LoadRequest {
        public int startDay;
        public int numDays;
        public boolean[] eventDays;
        public Runnable uiCallback;
        private static final String[] PROJECTION = new String[]{"startDay", "endDay"};

        public LoadEventDaysRequest(int startDay, int numDays, boolean[] eventDays, Runnable uiCallback) {
            this.startDay = startDay;
            this.numDays = numDays;
            this.eventDays = eventDays;
            this.uiCallback = uiCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processRequest(EventLoader eventLoader) {
            Handler handler = eventLoader.mHandler;
            ContentResolver cr = eventLoader.mResolver;
            Arrays.fill(this.eventDays, false);
            try (Cursor cursor = CalendarContract.EventDays.query((ContentResolver)cr, (int)this.startDay, (int)this.numDays, (String[])PROJECTION);){
                int startDayColumnIndex = cursor.getColumnIndexOrThrow("startDay");
                int endDayColumnIndex = cursor.getColumnIndexOrThrow("endDay");
                while (cursor.moveToNext()) {
                    int firstDay = cursor.getInt(startDayColumnIndex);
                    int lastDay = cursor.getInt(endDayColumnIndex);
                    int firstIndex = Math.max(firstDay - this.startDay, 0);
                    int lastIndex = Math.min(lastDay - this.startDay, 30);
                    for (int i = firstIndex; i <= lastIndex; ++i) {
                        this.eventDays[i] = true;
                    }
                }
            }
            handler.post(this.uiCallback);
        }

        @Override
        public void skipRequest(EventLoader eventLoader) {
        }
    }

    private static class ShutdownRequest
    implements LoadRequest {
        private ShutdownRequest() {
        }

        @Override
        public void processRequest(EventLoader eventLoader) {
        }

        @Override
        public void skipRequest(EventLoader eventLoader) {
        }
    }

    private static interface LoadRequest {
        public void processRequest(EventLoader var1);

        public void skipRequest(EventLoader var1);
    }
}

