/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.view.accessibility.CaptioningManager;
import java.util.Locale;
import us.zoom.androidlib.util.CaptionStyleCompat;
import us.zoom.androidlib.util.CompatUtils;

public class CaptionUtil {
    private static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int DEFAULT_TEXT_SIZE = 16;

    public static CaptionStyleCompat getCaptionStyle(Context context) {
        if (Build.VERSION.SDK_INT >= 19 && CaptionUtil.isCaptionEnabled(context)) {
            return CaptionUtil.getUserCaptionStyleV19(context);
        }
        return CaptionStyleCompat.DEFAULT;
    }

    public static float getCaptionFontScale(Context context) {
        if (Build.VERSION.SDK_INT >= 19 && CaptionUtil.isCaptionEnabled(context)) {
            return CaptionUtil.getUserCaptionFontScaleV19(context);
        }
        return 1.0f;
    }

    public static boolean isCaptionEnabled(Context context) {
        if (Build.VERSION.SDK_INT >= 19) {
            return CaptionUtil.isCaptionEnabledV19(context);
        }
        return false;
    }

    public static Locale getLocale(Context context) {
        if (Build.VERSION.SDK_INT >= 19 && CaptionUtil.isCaptionEnabled(context)) {
            return CaptionUtil.getLocaleV19(context);
        }
        return CompatUtils.getLocalDefault();
    }

    @TargetApi(value=19)
    private static boolean isCaptionEnabledV19(Context context) {
        if (context == null) {
            return false;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        if (captioningManager == null) {
            return false;
        }
        return captioningManager.isEnabled();
    }

    @TargetApi(value=19)
    private static Locale getLocaleV19(Context context) {
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        if (captioningManager == null) {
            return CompatUtils.getLocalDefault();
        }
        return captioningManager.getLocale();
    }

    @TargetApi(value=19)
    private static CaptionStyleCompat getUserCaptionStyleV19(Context context) {
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        if (captioningManager == null) {
            return CaptionStyleCompat.DEFAULT;
        }
        return CaptionStyleCompat.createFromCaptionStyle(captioningManager.getUserStyle());
    }

    @TargetApi(value=19)
    private static float getUserCaptionFontScaleV19(Context context) {
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        if (captioningManager == null) {
            return 1.0f;
        }
        return captioningManager.getFontScale();
    }
}

