/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.INameAbbrGenerator;
import us.zoom.androidlib.util.StringUtil;

public class CNNameAbbrGenerator
implements INameAbbrGenerator {
    @Override
    public String getNameAbbreviation(String name, Locale locale) {
        if (name == null) {
            return "";
        }
        String abbr = null;
        String[] words = name.split("\\s");
        if (words.length >= 2) {
            if (StringUtil.isAllAssii(words[0]) && StringUtil.isAllAssii(words[1])) {
                String firstChar = "";
                String secondChar = "";
                if (words[0].length() > 0) {
                    firstChar = String.valueOf(words[0].charAt(0));
                }
                if (words[1].length() > 0) {
                    secondChar = String.valueOf(words[1].charAt(0));
                }
                abbr = firstChar + secondChar;
            } else {
                String firstName = words[words.length - 1];
                abbr = this.getLast2Chars(firstName);
            }
        } else {
            abbr = name.length() == 0 ? "" : this.getLast2Chars(name);
        }
        abbr = abbr.toUpperCase(CompatUtils.getLocalDefault());
        return abbr;
    }

    private String getLast2Chars(String str) {
        int from = str.length() - 2;
        if (from < 0) {
            from = 0;
        }
        return str.substring(from);
    }
}

