/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.util;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityEventCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.view.accessibility.AccessibilityRecordCompat;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.util.OsUtil;

public class AccessibilityUtil {
    public static final long DELAY_SEND_FOCUS_EVENT = 200L;
    public static final long DELAY_SHOW_TIP = 1000L;

    public static boolean isSpokenFeedbackEnabled(Context context) {
        if (context == null) {
            return false;
        }
        AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
        return accessibilityManager != null && accessibilityManager.isEnabled() && !AccessibilityUtil.getEnabledServicesFor(accessibilityManager, 1).isEmpty();
    }

    private static List<AccessibilityServiceInfo> getEnabledServicesFor(AccessibilityManager accessibilityManager, int feedbackTypeFlags) {
        if (accessibilityManager == null) {
            return Collections.emptyList();
        }
        return accessibilityManager.getEnabledAccessibilityServiceList(feedbackTypeFlags);
    }

    public static void sendAccessibilityFocusEvent(View view) {
        if (view == null) {
            return;
        }
        Context context = view.getContext();
        if (context == null || !AccessibilityUtil.isSpokenFeedbackEnabled(context)) {
            return;
        }
        view.sendAccessibilityEvent(8);
    }

    public static void announceNoInterruptForAccessibilityCompat(View view, int textResourceId) {
        if (view == null) {
            return;
        }
        Context context = view.getContext();
        if (context == null) {
            return;
        }
        context = context.getApplicationContext();
        AccessibilityUtil.announceForAccessibilityCompat(view, context.getString(textResourceId), false);
    }

    public static void announceForAccessibilityCompat(View view, int textResourceId) {
        if (view == null) {
            return;
        }
        Context context = view.getContext();
        if (context == null) {
            return;
        }
        context = context.getApplicationContext();
        AccessibilityUtil.announceForAccessibilityCompat(view, context.getString(textResourceId), true);
    }

    public static void announceForAccessibilityCompat(View view, CharSequence text) {
        AccessibilityUtil.announceForAccessibilityCompat(view, text, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void announceForAccessibilityCompat(View view, CharSequence text, boolean isInterrupt) {
        block7: {
            AccessibilityManager accessibilityManager;
            Context context;
            block8: {
                if (view == null) {
                    return;
                }
                context = view.getContext();
                if (context == null) {
                    return;
                }
                accessibilityManager = (AccessibilityManager)(context = context.getApplicationContext()).getSystemService("accessibility");
                if (accessibilityManager == null) {
                    return;
                }
                if (!isInterrupt) break block8;
                try {
                    accessibilityManager.interrupt();
                }
                catch (NullPointerException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        int eventType = OsUtil.isAtLeastJB() ? 16384 : 8;
                        AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
                        event.getText().add(text);
                        event.setEnabled(view.isEnabled());
                        event.setClassName((CharSequence)view.getClass().getName());
                        event.setPackageName((CharSequence)context.getPackageName());
                        AccessibilityRecordCompat record = AccessibilityEventCompat.asRecord((AccessibilityEvent)event);
                        record.setSource(view);
                        accessibilityManager.sendAccessibilityEvent(event);
                        throw throwable;
                    }
                    int eventType = OsUtil.isAtLeastJB() ? 16384 : 8;
                    AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
                    event.getText().add(text);
                    event.setEnabled(view.isEnabled());
                    event.setClassName((CharSequence)view.getClass().getName());
                    event.setPackageName((CharSequence)context.getPackageName());
                    AccessibilityRecordCompat record = AccessibilityEventCompat.asRecord((AccessibilityEvent)event);
                    record.setSource(view);
                    accessibilityManager.sendAccessibilityEvent(event);
                    break block7;
                }
                int eventType = OsUtil.isAtLeastJB() ? 16384 : 8;
                AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
                event.getText().add(text);
                event.setEnabled(view.isEnabled());
                event.setClassName((CharSequence)view.getClass().getName());
                event.setPackageName((CharSequence)context.getPackageName());
                AccessibilityRecordCompat record = AccessibilityEventCompat.asRecord((AccessibilityEvent)event);
                record.setSource(view);
                accessibilityManager.sendAccessibilityEvent(event);
                break block7;
            }
            int eventType = OsUtil.isAtLeastJB() ? 16384 : 8;
            AccessibilityEvent event = AccessibilityEvent.obtain((int)eventType);
            event.getText().add(text);
            event.setEnabled(view.isEnabled());
            event.setClassName((CharSequence)view.getClass().getName());
            event.setPackageName((CharSequence)context.getPackageName());
            AccessibilityRecordCompat record = AccessibilityEventCompat.asRecord((AccessibilityEvent)event);
            record.setSource(view);
            accessibilityManager.sendAccessibilityEvent(event);
        }
    }

    public static boolean getIsAccessibilityFocused(View view) {
        if (view.getWindowToken() == null) {
            return false;
        }
        AccessibilityNodeInfoCompat node = AccessibilityUtil.createNodeInfoFromView(view);
        boolean isAccessibilityFocused = node.isAccessibilityFocused();
        node.recycle();
        return isAccessibilityFocused;
    }

    private static AccessibilityNodeInfoCompat createNodeInfoFromView(View view) {
        AccessibilityNodeInfoCompat nodeInfo = AccessibilityNodeInfoCompat.obtain();
        ViewCompat.onInitializeAccessibilityNodeInfo((View)view, (AccessibilityNodeInfoCompat)nodeInfo);
        return nodeInfo;
    }
}

