/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.proxy;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import us.zoom.androidlib.proxy.ProxyConfig;
import us.zoom.androidlib.util.StringUtil;

public class ProxySettings {
    private static final String TAG = ProxySettings.class.getName();

    public static ProxyConfig[] getHttpProxyConfigs(Context context) {
        return ProxySettings.getProxyConfigsForUri(context, "http://aafxbcfyfsghwcwu");
    }

    public static ProxyConfig[] getHttpsProxyConfigs(Context context) {
        return ProxySettings.getProxyConfigsForUri(context, "https://aafxbcfyfsghwcwu");
    }

    public static ProxyConfig[] getFtpProxyConfigs(Context context) {
        return ProxySettings.getProxyConfigsForUri(context, "ftp://aafxbcfyfsghwcwu");
    }

    public static ProxyConfig[] getSocketProxyConfigs(Context context) {
        return ProxySettings.getProxyConfigsForUri(context, "socket://aafxbcfyfsghwcwu");
    }

    public static ProxyConfig[] getProxyConfigsForUri(Context context, String uri) {
        if (Build.VERSION.SDK_INT >= 12) {
            return ProxySettings.getProxySelectorConfigs(context, URI.create(uri));
        }
        return ProxySettings.getProxyConfigsBelowOS31(context);
    }

    public static String getProxyConfigsStringForUri(Context context, String uri) {
        ProxyConfig[] configs = ProxySettings.getProxyConfigsForUri(context, uri);
        if (configs == null || configs.length == 0) {
            return "";
        }
        String str = configs[0].toString();
        for (int i = 1; i < configs.length; ++i) {
            str = str + ";" + configs[i].toString();
        }
        return str;
    }

    private static ProxyConfig[] getProxySelectorConfigs(Context context, URI uri) {
        ProxySelector proxySelector = ProxySelector.getDefault();
        List<Proxy> proxyList = proxySelector.select(uri);
        if (proxyList.size() > 0) {
            ProxyConfig[] configs = new ProxyConfig[proxyList.size()];
            for (int i = 0; i < proxyList.size(); ++i) {
                Proxy proxy = proxyList.get(i);
                configs[i] = new ProxyConfig(proxy);
            }
            return configs;
        }
        return null;
    }

    private static ProxyConfig[] getProxyConfigsBelowOS31(Context context) {
        String[] parts;
        ContentResolver contentResolver = context.getContentResolver();
        if (contentResolver == null) {
            return null;
        }
        String proxyString = Settings.Secure.getString((ContentResolver)contentResolver, (String)"http_proxy");
        if (!StringUtil.isEmptyOrNull(proxyString) && proxyString.contains(":") && (parts = proxyString.split(":")) != null && parts.length == 2) {
            String proxyAddress = parts[0];
            try {
                Integer proxyPort = Integer.parseInt(parts[1]);
                Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyAddress, (int)proxyPort));
                ProxyConfig config = new ProxyConfig(p);
                return new ProxyConfig[]{config};
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

