/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app.preference;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import us.zoom.androidlib.app.preference.ZMBasePreferencesProvider;
import us.zoom.androidlib.app.preference.ZMPreferences;

class ZMPreferencesProvider {
    ZMPreferencesProvider() {
    }

    static boolean putString(Context context, String spName, String key, String value) {
        Uri uri = ZMPreferencesProvider.buildUri(context, 100, spName, key, value);
        ContentResolver cr = context.getContentResolver();
        try {
            ContentValues values = new ContentValues();
            values.put(key, value);
            cr.insert(uri, values);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static boolean remove(Context context, String spName, String key) {
        try {
            Uri uri = ZMPreferencesProvider.buildUri(context, 106, spName, key, null);
            ContentResolver cr = context.getContentResolver();
            cr.delete(uri, null, null);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static String getString(Context context, String spName, String key) {
        return ZMPreferencesProvider.getString(context, spName, key, "");
    }

    static String getString(Context context, String spName, String key, String defaultValue) {
        String result = defaultValue;
        Uri uri = ZMPreferencesProvider.buildUri(context, 100, spName, key, defaultValue);
        ContentResolver cr = context.getContentResolver();
        Cursor cursor = cr.query(uri, null, null, null, null);
        if (cursor == null) {
            return result;
        }
        if (cursor.moveToNext()) {
            result = cursor.getString(cursor.getColumnIndex(ZMBasePreferencesProvider.COLUMNNAME));
        }
        return result;
    }

    static boolean putInt(Context context, String spName, String key, int value) {
        Uri uri = ZMPreferencesProvider.buildUri(context, 101, spName, key, value);
        ContentResolver cr = context.getContentResolver();
        try {
            ContentValues values = new ContentValues();
            values.put(key, Integer.valueOf(value));
            cr.insert(uri, values);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static int getInt(Context context, String spName, String key) {
        return ZMPreferencesProvider.getInt(context, spName, key, -1);
    }

    static int getInt(Context context, String spName, String key, int defaultValue) {
        int result = defaultValue;
        Uri uri = ZMPreferencesProvider.buildUri(context, 101, spName, key, defaultValue);
        ContentResolver cr = context.getContentResolver();
        Cursor cursor = cr.query(uri, null, null, null, null);
        if (cursor == null) {
            return result;
        }
        if (cursor.moveToNext()) {
            result = cursor.getInt(cursor.getColumnIndex(ZMBasePreferencesProvider.COLUMNNAME));
        }
        return result;
    }

    static boolean putLong(Context context, String spName, String key, long value) {
        Uri uri = ZMPreferencesProvider.buildUri(context, 102, spName, key, value);
        ContentResolver cr = context.getContentResolver();
        try {
            ContentValues values = new ContentValues();
            values.put(key, Long.valueOf(value));
            cr.insert(uri, values);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static long getLong(Context context, String spName, String key) {
        return ZMPreferencesProvider.getLong(context, spName, key, -1L);
    }

    static long getLong(Context context, String spName, String key, long defaultValue) {
        long result = defaultValue;
        Uri uri = ZMPreferencesProvider.buildUri(context, 102, spName, key, defaultValue);
        ContentResolver cr = context.getContentResolver();
        Cursor cursor = cr.query(uri, null, null, null, null);
        if (cursor == null) {
            return result;
        }
        if (cursor.moveToNext()) {
            result = cursor.getLong(cursor.getColumnIndex(ZMBasePreferencesProvider.COLUMNNAME));
        }
        return result;
    }

    static boolean putFloat(Context context, String spName, String key, float value) {
        Uri uri = ZMPreferencesProvider.buildUri(context, 104, spName, key, Float.valueOf(value));
        ContentResolver cr = context.getContentResolver();
        try {
            ContentValues values = new ContentValues();
            values.put(key, Float.valueOf(value));
            cr.insert(uri, values);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static float getFloat(Context context, String spName, String key) {
        return ZMPreferencesProvider.getFloat(context, spName, key, -1.0f);
    }

    static float getFloat(Context context, String spName, String key, float defaultValue) {
        float result = defaultValue;
        Uri uri = ZMPreferencesProvider.buildUri(context, 104, spName, key, Float.valueOf(defaultValue));
        ContentResolver cr = context.getContentResolver();
        Cursor cursor = cr.query(uri, null, null, null, null);
        if (cursor == null) {
            return result;
        }
        if (cursor.moveToNext()) {
            result = cursor.getFloat(cursor.getColumnIndex(ZMBasePreferencesProvider.COLUMNNAME));
        }
        return result;
    }

    static boolean putBoolean(Context context, String spName, String key, boolean value) {
        Uri uri = ZMPreferencesProvider.buildUri(context, 105, spName, key, value);
        ContentResolver cr = context.getContentResolver();
        try {
            ContentValues values = new ContentValues();
            values.put(key, Boolean.valueOf(value));
            cr.insert(uri, values);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static boolean getBoolean(Context context, String spName, String key) {
        return ZMPreferencesProvider.getBoolean(context, spName, key, false);
    }

    static boolean getBoolean(Context context, String spName, String key, boolean defaultValue) {
        boolean result = defaultValue;
        Uri uri = ZMPreferencesProvider.buildUri(context, 105, spName, key, defaultValue);
        ContentResolver cr = context.getContentResolver();
        Cursor cursor = cr.query(uri, null, null, null, null);
        if (cursor == null) {
            return result;
        }
        if (cursor.moveToNext()) {
            result = Boolean.valueOf(cursor.getString(cursor.getColumnIndex(ZMBasePreferencesProvider.COLUMNNAME)));
        }
        return result;
    }

    static boolean put(Context context, String spName, ContentValues datas) {
        Uri uri = ZMPreferencesProvider.buildUri(context, 107, spName, null, null);
        ContentResolver cr = context.getContentResolver();
        try {
            cr.insert(uri, datas);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Uri buildUri(Context context, int code, String spName, String key, Object value) {
        String authorities = ZMPreferences.getString(context, ZMBasePreferencesProvider.AUTHORITIES_SPNAME, ZMBasePreferencesProvider.AUTHORITIES_KEY);
        Uri uri = null;
        switch (code) {
            case 100: {
                uri = Uri.parse((String)("content://" + authorities + "/string/" + spName + "/" + key + "/" + value));
                break;
            }
            case 101: {
                uri = Uri.parse((String)("content://" + authorities + "/integer/" + spName + "/" + key + "/" + value));
                break;
            }
            case 102: {
                uri = Uri.parse((String)("content://" + authorities + "/long/" + spName + "/" + key + "/" + value));
                break;
            }
            case 104: {
                uri = Uri.parse((String)("content://" + authorities + "/float/" + spName + "/" + key + "/" + value));
                break;
            }
            case 105: {
                uri = Uri.parse((String)("content://" + authorities + "/boolean/" + spName + "/" + key + "/" + value));
                break;
            }
            case 106: {
                uri = Uri.parse((String)("content://" + authorities + "/delete/" + spName + "/" + key));
                break;
            }
            case 107: {
                uri = Uri.parse((String)("content://" + authorities + "/puts"));
                break;
            }
        }
        return uri;
    }
}

