/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app.preference;

import android.content.Context;
import android.content.SharedPreferences;

class ZMPreferences {
    ZMPreferences() {
    }

    static boolean putString(Context context, String spName, String key, String value) {
        SharedPreferences settings = context.getSharedPreferences(spName, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString(key, value);
        return editor.commit();
    }

    static boolean remove(Context context, String spName, String key) {
        SharedPreferences settings = context.getSharedPreferences(spName, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.remove(key);
        return editor.commit();
    }

    static String getString(Context context, String spName, String key) {
        return ZMPreferences.getString(context, spName, key, null);
    }

    static String getString(Context context, String spName, String key, String defaultValue) {
        SharedPreferences settings = context.getSharedPreferences(spName, 0);
        return settings.getString(key, defaultValue);
    }

    static boolean putInt(Context context, String spName, String key, int value) {
        SharedPreferences settings = context.getSharedPreferences(spName, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putInt(key, value);
        return editor.commit();
    }

    static int getInt(Context context, String spName, String key) {
        return ZMPreferences.getInt(context, spName, key, -1);
    }

    static int getInt(Context context, String spName, String key, int defaultValue) {
        SharedPreferences settings = context.getSharedPreferences(spName, 0);
        return settings.getInt(key, defaultValue);
    }

    static boolean putLong(Context context, String spName, String key, long value) {
        SharedPreferences settings = context.getSharedPreferences(spName, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putLong(key, value);
        return editor.commit();
    }

    static long getLong(Context context, String spName, String key) {
        return ZMPreferences.getLong(context, spName, key, -1L);
    }

    static long getLong(Context context, String spName, String key, long defaultValue) {
        SharedPreferences settings = context.getSharedPreferences(spName, 0);
        return settings.getLong(key, defaultValue);
    }

    static boolean putFloat(Context context, String spName, String key, float value) {
        SharedPreferences settings = context.getSharedPreferences(spName, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putFloat(key, value);
        return editor.commit();
    }

    static SharedPreferences.Editor getEditor(Context context, String spName) {
        SharedPreferences settings = context.getSharedPreferences(spName, 0);
        SharedPreferences.Editor editor = settings.edit();
        return editor;
    }

    static float getFloat(Context context, String spName, String key) {
        return ZMPreferences.getFloat(context, spName, key, -1.0f);
    }

    static float getFloat(Context context, String spName, String key, float defaultValue) {
        SharedPreferences settings = context.getSharedPreferences(spName, 0);
        return settings.getFloat(key, defaultValue);
    }

    static boolean putBoolean(Context context, String spName, String key, boolean value) {
        SharedPreferences settings = context.getSharedPreferences(spName, 0);
        SharedPreferences.Editor editor = settings.edit();
        editor.putBoolean(key, value);
        return editor.commit();
    }

    static boolean getBoolean(Context context, String spName, String key) {
        return ZMPreferences.getBoolean(context, spName, key, false);
    }

    static boolean getBoolean(Context context, String spName, String key, boolean defaultValue) {
        SharedPreferences settings = context.getSharedPreferences(spName, 0);
        return settings.getBoolean(key, defaultValue);
    }
}

