/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app.preference;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.text.TextUtils;
import java.util.Set;
import us.zoom.androidlib.app.preference.ZMPreferences;

public abstract class ZMBasePreferencesProvider
extends ContentProvider {
    private UriMatcher mUriMatcher;
    public static String COLUMNNAME = "SPCOLUMNNAME";
    public static String AUTHORITIES_KEY = "authorities_key";
    public static String AUTHORITIES_SPNAME = "authorities_spname";
    private String mStringPath = "string/*/*/";
    public static final int STRING_CONTENT_URI_CODE = 100;
    private String mIntegerPath = "integer/*/*/";
    public static final int INTEGER_CONTENT_URI_CODE = 101;
    private String mLongPath = "long/*/*/";
    public static final int LONG_CONTENT_URI_CODE = 102;
    private String mFloatPath = "float/*/*/";
    public static final int FLOAT_CONTENT_URI_CODE = 104;
    private String mBooleanPath = "boolean/*/*/";
    public static final int BOOLEAN_CONTENT_URI_CODE = 105;
    private String mDeletePath = "delete/*/*/";
    public static final int DELETE_CONTENT_URI_CODE = 106;
    private String mPutsPath = "puts";
    public static final int PUTS_CONTENT_URI_CODE = 107;

    public abstract String getAuthorities();

    public boolean onCreate() {
        String authorities = this.getAuthorities();
        ZMPreferences.putString(this.getContext(), AUTHORITIES_SPNAME, AUTHORITIES_KEY, authorities);
        this.mUriMatcher = new UriMatcher(-1);
        this.mUriMatcher.addURI(authorities, this.mStringPath, 100);
        this.mUriMatcher.addURI(authorities, this.mStringPath + "*/", 100);
        this.mUriMatcher.addURI(authorities, this.mIntegerPath, 101);
        this.mUriMatcher.addURI(authorities, this.mIntegerPath + "*/", 101);
        this.mUriMatcher.addURI(authorities, this.mLongPath, 102);
        this.mUriMatcher.addURI(authorities, this.mLongPath + "*/", 102);
        this.mUriMatcher.addURI(authorities, this.mFloatPath, 104);
        this.mUriMatcher.addURI(authorities, this.mFloatPath + "*/", 104);
        this.mUriMatcher.addURI(authorities, this.mBooleanPath, 105);
        this.mUriMatcher.addURI(authorities, this.mBooleanPath + "*/", 105);
        this.mUriMatcher.addURI(authorities, this.mDeletePath, 106);
        this.mUriMatcher.addURI(authorities, this.mPutsPath, 107);
        return false;
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Model model = this.getModel(uri);
        if (model == null) {
            return null;
        }
        int code = this.mUriMatcher.match(uri);
        Cursor cursor = this.buildCursor(this.getContext(), model, code);
        return cursor;
    }

    public String getType(Uri uri) {
        return null;
    }

    public Uri insert(Uri uri, ContentValues values) {
        Model model = this.getModel(uri);
        if (model == null) {
            return null;
        }
        int code = this.mUriMatcher.match(uri);
        if (code == 100 || code == 101 || code == 102 || code == 104 || code == 105 || code == 107) {
            this.insert(this.getContext(), values, model);
        }
        return uri;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        Model model = this.getModel(uri);
        if (model == null) {
            return -1;
        }
        int code = this.mUriMatcher.match(uri);
        if (code == 100 || code == 101 || code == 102 || code == 104 || code == 105) {
            this.delete(this.getContext(), model);
        }
        return 0;
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        Model model = this.getModel(uri);
        if (model == null) {
            return -1;
        }
        int code = this.mUriMatcher.match(uri);
        if (code == 100 || code == 101 || code == 102 || code == 104 || code == 105) {
            this.insert(this.getContext(), values, model);
        }
        return 0;
    }

    private void delete(Context context, Model model) {
        SharedPreferences.Editor editor = ZMPreferences.getEditor(context, model.getSpName());
        editor.remove(model.getKey());
        editor.apply();
    }

    private void insert(Context context, ContentValues values, Model model) {
        SharedPreferences.Editor editor = ZMPreferences.getEditor(context, model.getSpName());
        Set keys = values.keySet();
        for (String key : keys) {
            Object value = values.get(key);
            if (value instanceof Integer) {
                editor.putInt(key, Integer.parseInt(value + ""));
                continue;
            }
            if (value instanceof Long) {
                editor.putLong(key, Long.parseLong(value + ""));
                continue;
            }
            if (value instanceof Float) {
                editor.putFloat(key, Float.parseFloat(value + ""));
                continue;
            }
            if (value instanceof Boolean) {
                editor.putBoolean(key, Boolean.valueOf(value + "").booleanValue());
                continue;
            }
            editor.putString(key, (value == null ? "" : value) + "");
        }
        editor.apply();
    }

    private Cursor buildCursor(Context context, Model model, int code) {
        Object value = null;
        Object defValue = model.getDefValue();
        switch (code) {
            case 100: {
                if (defValue == null) {
                    value = ZMPreferences.getString(context, model.getSpName(), model.getKey());
                    break;
                }
                value = ZMPreferences.getString(context, model.getSpName(), model.getKey(), String.valueOf(defValue));
                break;
            }
            case 101: {
                if (defValue == null) {
                    value = ZMPreferences.getInt(context, model.getSpName(), model.getKey());
                    break;
                }
                if (!TextUtils.isDigitsOnly((CharSequence)(defValue + ""))) {
                    defValue = -1;
                }
                value = ZMPreferences.getInt(context, model.getSpName(), model.getKey(), Integer.parseInt(defValue + ""));
                break;
            }
            case 102: {
                if (defValue == null) {
                    value = ZMPreferences.getLong(context, model.getSpName(), model.getKey());
                    break;
                }
                if (!TextUtils.isDigitsOnly((CharSequence)(defValue + ""))) {
                    defValue = -1;
                }
                value = ZMPreferences.getLong(context, model.getSpName(), model.getKey(), Long.parseLong(defValue + ""));
                break;
            }
            case 104: {
                if (defValue == null) {
                    value = Float.valueOf(ZMPreferences.getFloat(context, model.getSpName(), model.getKey()));
                    break;
                }
                value = Float.valueOf(ZMPreferences.getFloat(context, model.getSpName(), model.getKey(), Float.parseFloat(defValue + "")));
                break;
            }
            case 105: {
                if (defValue == null) {
                    value = ZMPreferences.getBoolean(context, model.getSpName(), model.getKey()) + "";
                    break;
                }
                value = ZMPreferences.getBoolean(context, model.getSpName(), model.getKey(), Boolean.valueOf(defValue + "")) + "";
                break;
            }
        }
        if (value == null) {
            return null;
        }
        String[] columnNames = new String[]{COLUMNNAME};
        MatrixCursor cursor = new MatrixCursor(columnNames);
        Object[] values = new Object[]{value};
        cursor.addRow(values);
        return cursor;
    }

    private Model getModel(Uri uri) {
        try {
            Model model = new Model();
            model.setSpName((String)uri.getPathSegments().get(1));
            if (uri.getPathSegments().size() > 2) {
                model.setKey((String)uri.getPathSegments().get(2));
            }
            if (uri.getPathSegments().size() > 3) {
                model.setDefValue(uri.getPathSegments().get(3));
            }
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private class Model {
        private String spName;
        private String key;
        private Object defValue;

        private Model() {
        }

        public String getSpName() {
            return this.spName;
        }

        public void setSpName(String spName) {
            this.spName = spName;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Object getDefValue() {
            return this.defValue;
        }

        public void setDefValue(Object defValue) {
            this.defValue = defValue;
        }
    }
}

