/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.StatFs;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMAsyncTask;

public class ZMStorageUtil {
    private static final String TAG = ZMStorageUtil.class.getSimpleName();
    public static final int TYPE_INTERNAL_STORAGE = 1;
    public static final int TYPE_SDCARD = 2;
    public static final int TYPE_USB_STORAGE = 3;
    private static ListenerList sListeners = new ListenerList();
    private static AsyncLoadAllStorage sLoader = null;
    private static ArrayList<ZMStorageItem> sCachedStorages = new ArrayList();
    private static Handler sHandler = new Handler();
    private static Runnable sTimeOutRunnable = new Runnable(){

        @Override
        public void run() {
            ZMStorageUtil.notifyListeners(sCachedStorages);
        }
    };

    private static void addListener(ZMStorageListener l) {
        sListeners.add(l);
    }

    public static void removeListener(ZMStorageListener l) {
        sListeners.remove(l);
    }

    public static boolean isInternalStorageMounted() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getInternalStoragePath() {
        File file = Environment.getExternalStorageDirectory();
        if (file == null) {
            return null;
        }
        return file.getPath();
    }

    private static boolean checkFsWritable(String dir) {
        File directory;
        if (dir == null) {
            return false;
        }
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if (!(directory = new File(dir)).isDirectory() && !directory.mkdirs()) {
            return false;
        }
        File f = new File(directory, ".zoomflajfalsfka");
        try {
            if (f.exists()) {
                f.delete();
            }
            if (!f.createNewFile()) {
                return false;
            }
            f.delete();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void asyncGetAllStorages(ZMStorageListener l, long timeout) {
        ZMStorageUtil.addListener(l);
        if (sLoader != null) {
            return;
        }
        sLoader = new AsyncLoadAllStorage();
        sLoader.execute(new Void[0]);
        sHandler.removeCallbacks(sTimeOutRunnable);
        sHandler.postDelayed(sTimeOutRunnable, timeout);
    }

    private static void notifyListeners(List<ZMStorageItem> result) {
        IListener[] listeners;
        for (IListener l : listeners = sListeners.getAll()) {
            if (!(l instanceof ZMStorageListener)) continue;
            ZMStorageListener listener = (ZMStorageListener)l;
            listener.onRecieveStorageInfo(result);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static long getAvailableMemSize(String path) {
        if (StringUtil.isEmptyOrNull(path)) {
            return 0L;
        }
        StatFs stat = null;
        try {
            stat = new StatFs(path);
        }
        catch (Exception e) {
            return 0L;
        }
        if (stat == null) {
            return 0L;
        }
        long availableBytes = 0L;
        availableBytes = Build.VERSION.SDK_INT < 18 ? (long)stat.getAvailableBlocks() * (long)stat.getBlockSize() : stat.getAvailableBytes();
        return availableBytes;
    }

    private static class AsyncLoadAllStorage
    extends ZMAsyncTask<Void, Void, List<ZMStorageItem>> {
        private AsyncLoadAllStorage() {
        }

        protected List<ZMStorageItem> doInBackground(Void ... params) {
            return this.getAllStorageInfo();
        }

        @Override
        protected void onPostExecute(List<ZMStorageItem> result) {
            sCachedStorages.clear();
            sCachedStorages.addAll(result);
            ZMStorageUtil.notifyListeners(result);
            sHandler.removeCallbacks(sTimeOutRunnable);
            sLoader = null;
        }

        private List<ZMStorageItem> getAllStorageInfo() {
            ArrayList<ZMStorageItem> storageList = new ArrayList<ZMStorageItem>();
            List<String> paths = this.getAllExternalStoragePaths();
            ZMStorageItem interStorage = new ZMStorageItem();
            interStorage.path = ZMStorageUtil.getInternalStoragePath();
            interStorage.type = 1;
            interStorage.mounted = ZMStorageUtil.isInternalStorageMounted();
            interStorage.availableSize = ZMStorageUtil.getAvailableMemSize(interStorage.path);
            storageList.add(interStorage);
            for (String path : paths) {
                boolean mount = ZMStorageUtil.checkFsWritable(path);
                ZMStorageItem item = new ZMStorageItem();
                String lowerPath = path.toLowerCase(Locale.US);
                item.type = this.isUsbStorage(lowerPath) ? 3 : 2;
                item.path = path;
                item.mounted = mount;
                item.availableSize = ZMStorageUtil.getAvailableMemSize(path);
                storageList.add(item);
            }
            return storageList;
        }

        private boolean isUsbStorage(String path) {
            if (StringUtil.isEmptyOrNull(path)) {
                return false;
            }
            String tmp = path.toLowerCase(Locale.US);
            return tmp.contains("usb");
        }

        private List<String> getAllExternalStoragePaths() {
            String internalStoragePath;
            ArrayList<String> storagePaths = new ArrayList<String>();
            try {
                String line;
                Runtime runtime = Runtime.getRuntime();
                Process proc = runtime.exec("mount");
                InputStream is = proc.getInputStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                while ((line = br.readLine()) != null) {
                    String path;
                    String[] columns;
                    if (line.contains("secure") || line.contains("asec") || line.contains("media") || line.contains("system") || line.contains("cache") || line.contains("sys") || line.contains("data") || line.contains("tmpfs") || line.contains("shell") || line.contains("root") || line.contains("acct") || line.contains("proc") || line.contains("misc") || line.contains("obb") || !line.contains("fat") && !line.contains("fuse") && !line.contains("ntfs") || (columns = line.split(" ")) == null || columns.length <= 1 || (path = columns[1]) == null || storagePaths.contains(path) || !path.toLowerCase(Locale.US).contains("sd") && !this.isUsbStorage(path)) continue;
                    storagePaths.add(columns[1]);
                }
            }
            catch (Exception runtime) {
                // empty catch block
            }
            if (storagePaths.contains(internalStoragePath = ZMStorageUtil.getInternalStoragePath())) {
                storagePaths.remove(internalStoragePath);
            }
            return storagePaths;
        }
    }

    public static interface ZMStorageListener
    extends IListener {
        public void onRecieveStorageInfo(List<ZMStorageItem> var1);
    }

    public static class ZMStorageItem {
        public String path;
        public int type = 0;
        public boolean mounted = false;
        long availableSize;
    }
}

