/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.text.ClipboardManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.R;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;

public class ZMSendMessageFragment
extends ZMDialogFragment {
    private static final String TAG = ZMSendMessageFragment.class.getSimpleName();
    public static final int APP_TYPE_EMAIL = 1;
    public static final int APP_TYPE_SMS = 2;
    public static final int APP_TYPE_CLIPBOARD = 4;
    public static final int APP_TYPE_ALL = -1;
    private static final String ARG_EMAIL = "email";
    private static final String ARG_PHONE_NUMBERS = "phoneNumbers";
    private static final String ARG_TOPIC = "topic";
    private static final String ARG_CONTENT = "content";
    private static final String ARG_SMS_CONTENT = "smsContent";
    private static final String ARG_STREAM = "stream";
    private static final String ARG_CHOOSER_TITLE = "chooserTitle";
    private static final String ARG_APP_TYPES = "appTypes";
    private static final String ARG_EXT_ITEMS = "extItems";
    private AppListAdapter mAdapter;

    public static void show(Context context, FragmentManager fm, String[] email, String[] phoneNumbers, String topic, String content, String smsContent, String stream, String chooserTitle) {
        ZMSendMessageFragment.show(context, fm, email, phoneNumbers, topic, content, smsContent, stream, chooserTitle, -1);
    }

    public static void show(Context context, FragmentManager fm, String[] email, String[] phoneNumbers, String topic, String content, String smsContent, String stream, String chooserTitle, int appTypes) {
        ZMSendMessageFragment.show(context, fm, email, phoneNumbers, topic, content, smsContent, stream, chooserTitle, appTypes, null);
    }

    public static void show(Context context, FragmentManager fm, String[] email, String[] phoneNumbers, String topic, String content, String smsContent, String stream, String chooserTitle, int appTypes, ExtAppItem[] extItems) {
        List<ResolveInfo> emailAppList = AndroidAppUtil.queryEmailActivities(context);
        List<ResolveInfo> smsAppList = AndroidAppUtil.querySMSActivities(context);
        int countApps = 0;
        if ((appTypes & 1) != 0) {
            countApps += emailAppList.size();
        }
        if ((appTypes & 2) != 0) {
            countApps += smsAppList.size();
        }
        if ((appTypes & 4) == 0) {
            if (countApps == 0) {
                return;
            }
            if (countApps == 1) {
                if ((appTypes & 1) != 0 && emailAppList.size() > 0) {
                    ResolveInfo info = emailAppList.get(0);
                    AndroidAppUtil.sendEmailVia(info, context, email, topic, content, stream);
                } else if ((appTypes & 2) != 0 && smsAppList.size() > 0) {
                    ResolveInfo info = smsAppList.get(0);
                    AndroidAppUtil.sendSMSVia(info, context, phoneNumbers, content);
                }
                return;
            }
        }
        if (StringUtil.isEmptyOrNull(smsContent)) {
            smsContent = content;
        }
        Bundle args = new Bundle();
        args.putStringArray(ARG_EMAIL, email);
        args.putStringArray(ARG_PHONE_NUMBERS, phoneNumbers);
        args.putString(ARG_TOPIC, topic);
        args.putString(ARG_CONTENT, content);
        args.putString(ARG_SMS_CONTENT, smsContent);
        args.putString(ARG_STREAM, stream);
        args.putString(ARG_CHOOSER_TITLE, chooserTitle);
        args.putInt(ARG_APP_TYPES, appTypes);
        args.putParcelableArray(ARG_EXT_ITEMS, (Parcelable[])extItems);
        ZMSendMessageFragment f = new ZMSendMessageFragment();
        f.setArguments(args);
        f.show(fm, ZMSendMessageFragment.class.getName());
    }

    public ZMSendMessageFragment() {
        this.setCancelable(true);
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Bundle args = this.getArguments();
        String chooserTitle = args.getString(ARG_CHOOSER_TITLE);
        int appTypes = args.getInt(ARG_APP_TYPES);
        ExtAppItem[] extItems = (ExtAppItem[])args.getParcelableArray(ARG_EXT_ITEMS);
        this.mAdapter = new AppListAdapter((ZMActivity)this.getActivity(), appTypes, extItems);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(chooserTitle).setAdapter((ListAdapter)this.mAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ZMSendMessageFragment.this.onClickItem(ZMSendMessageFragment.this.mAdapter, which);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        return dialog;
    }

    @Override
    public void onStart() {
        super.onStart();
    }

    public void onCancel(DialogInterface dialog) {
        super.onCancel(dialog);
    }

    private void onClickItem(AppListAdapter adapter, int which) {
        Bundle args = this.getArguments();
        String[] email = args.getStringArray(ARG_EMAIL);
        String[] phoneNumbers = args.getStringArray(ARG_PHONE_NUMBERS);
        String topic = args.getString(ARG_TOPIC);
        String content = args.getString(ARG_CONTENT);
        String smsContent = args.getString(ARG_SMS_CONTENT);
        String stream = args.getString(ARG_STREAM);
        Object oItem = this.mAdapter.getItem(which);
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        if (oItem instanceof AppItem) {
            AppItem item = (AppItem)oItem;
            if (item.appType == 1) {
                AndroidAppUtil.sendEmailVia(item.appInfo, (Context)activity, email, topic, content, stream);
            } else if (item.appType == 2) {
                AndroidAppUtil.sendSMSVia(item.appInfo, (Context)activity, phoneNumbers, smsContent);
            } else if (item.appType == 4) {
                this.copyToClipboard(content);
            }
        } else if (oItem instanceof ExtAppItem) {
            ExtAppItem item = (ExtAppItem)oItem;
            try {
                activity.startActivity(item.intent);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void copyToClipboard(String content) {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        ClipboardManager clipboard = (ClipboardManager)activity.getSystemService("clipboard");
        clipboard.setText((CharSequence)content);
    }

    static class AppListAdapter
    extends BaseAdapter {
        private ZMActivity mActivity;
        private List<AppItem> mList;
        private ExtAppItem[] mExtItems;

        public AppListAdapter(ZMActivity activity, int appTypes, ExtAppItem[] extItems) {
            AppItem item;
            this.mActivity = activity;
            this.mExtItems = extItems;
            this.mList = new ArrayList<AppItem>();
            if ((appTypes & 1) != 0) {
                List<ResolveInfo> emailAppList = AndroidAppUtil.queryEmailActivities((Context)activity);
                for (ResolveInfo info : emailAppList) {
                    item = new AppItem(1, info);
                    this.mList.add(item);
                }
            }
            if ((appTypes & 2) != 0) {
                List<ResolveInfo> smsAppList = AndroidAppUtil.querySMSActivities((Context)activity);
                for (ResolveInfo info : smsAppList) {
                    item = new AppItem(2, info);
                    this.mList.add(item);
                }
            }
            if ((appTypes & 4) != 0) {
                AppItem item2 = new AppItem(4, null);
                this.mList.add(item2);
            }
        }

        public int getCount() {
            return this.mList.size() + (this.mExtItems != null ? this.mExtItems.length : 0);
        }

        public Object getItem(int position) {
            if (position < 0) {
                return null;
            }
            int sizeExtItems = 0;
            if (this.mExtItems != null && position < (sizeExtItems = this.mExtItems.length)) {
                return this.mExtItems[position];
            }
            return this.mList.get(position - sizeExtItems);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            Object oItem = this.getItem(position);
            if (convertView == null) {
                convertView = View.inflate((Context)this.mActivity, (int)R.layout.zm_app_item, null);
            }
            ImageView imgIcon = (ImageView)convertView.findViewById(R.id.imgIcon);
            TextView txtLabel = (TextView)convertView.findViewById(R.id.txtLabel);
            if (oItem instanceof AppItem) {
                AppItem item = (AppItem)oItem;
                if (item.appInfo != null) {
                    imgIcon.setVisibility(0);
                    imgIcon.setImageDrawable(AndroidAppUtil.getApplicationIcon((Context)this.mActivity, item.appInfo));
                    txtLabel.setText((CharSequence)AndroidAppUtil.getApplicationLabel((Context)this.mActivity, item.appInfo));
                } else if (item.appType == 4) {
                    imgIcon.setVisibility(0);
                    imgIcon.setImageResource(R.drawable.zm_copy);
                    txtLabel.setText(R.string.zm_lbl_copy_to_clipboard);
                }
            } else if (oItem instanceof ExtAppItem) {
                ExtAppItem item = (ExtAppItem)oItem;
                ApplicationInfo info = AndroidAppUtil.getApplicationInfo((Context)this.mActivity, item.packageName);
                String label = AndroidAppUtil.getApplicationLabel((Context)this.mActivity, info);
                Drawable icon = AndroidAppUtil.getApplicationIcon((Context)this.mActivity, info);
                imgIcon.setVisibility(0);
                imgIcon.setImageDrawable(icon);
                txtLabel.setText((CharSequence)label);
            }
            return convertView;
        }
    }

    public static class ExtAppItem
    implements Parcelable {
        Intent intent;
        String packageName;
        public static final Parcelable.Creator<ExtAppItem> CREATOR = new Parcelable.Creator<ExtAppItem>(){

            public ExtAppItem createFromParcel(Parcel source) {
                Intent intent = (Intent)Intent.CREATOR.createFromParcel(source);
                String packageName = source.readString();
                return new ExtAppItem(intent, packageName);
            }

            public ExtAppItem[] newArray(int size) {
                return new ExtAppItem[size];
            }
        };

        public ExtAppItem(Intent intent, String packageName) {
            this.intent = intent;
            this.packageName = packageName;
        }

        public int describeContents() {
            return this.intent != null ? this.intent.describeContents() : 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            if (dest == null) {
                return;
            }
            this.intent.writeToParcel(dest, flags);
            dest.writeString(this.packageName);
        }
    }

    static class AppItem {
        int appType = 0;
        ResolveInfo appInfo = null;

        AppItem(int type, ResolveInfo info) {
            this.appType = type;
            this.appInfo = info;
        }
    }
}

