/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.os.Environment;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

class ZMLocalFileListSession {
    private ArrayList<String> pathDirsList = new ArrayList();
    private List<File> mFileList = new ArrayList<File>();
    private String mFileListPath;
    private FilenameFilter mFileNameFilter = null;
    private File mDir = null;

    public ZMLocalFileListSession() {
        this.init(null);
    }

    public ZMLocalFileListSession(String dir) {
        this.init(dir);
    }

    public ZMLocalFileListSession(String dir, FilenameFilter filter) {
        this.init(dir);
        this.mFileNameFilter = filter;
    }

    public void setFileNameFilter(FilenameFilter filter) {
        this.mFileNameFilter = filter;
    }

    public FilenameFilter getFileNameFilter() {
        return this.mFileNameFilter;
    }

    public void setDir(String dir) {
        this.init(dir);
        this.loadFileList();
    }

    private void init(String dir) {
        File tempFile;
        if (!StringUtil.isEmptyOrNull(dir) && (tempFile = new File(dir)).isDirectory()) {
            this.mDir = tempFile;
        }
        if (this.mDir == null) {
            this.mDir = Environment.getExternalStorageDirectory().isDirectory() && Environment.getExternalStorageDirectory().canRead() ? Environment.getExternalStorageDirectory() : new File("/");
        }
        this.parseDirectoryPath();
    }

    private void parseDirectoryPath() {
        if (this.mDir == null) {
            return;
        }
        this.pathDirsList.clear();
        String pathString = this.mDir.getAbsolutePath();
        String[] parts = pathString.split("/");
        for (int i = 0; i < parts.length; ++i) {
            this.pathDirsList.add(parts[i]);
        }
    }

    private boolean loadFileList() {
        if (this.mDir == null) {
            return false;
        }
        this.mFileList.clear();
        this.mFileListPath = null;
        try {
            ZMLocalFileListSession.getDirectoryFileList(this.mDir.getPath(), this.mFileNameFilter, this.mFileList);
        }
        catch (Exception e) {
            return false;
        }
        this.mFileListPath = this.mDir.getPath();
        return true;
    }

    public File getCurrentDir() {
        return this.mDir;
    }

    public String getCurrentDirPath() {
        if (this.mDir == null) {
            return null;
        }
        return this.mDir.getPath();
    }

    public List<File> getCurrentFileList() {
        if (!(this.mFileListPath != null && this.mDir != null && this.mFileListPath.equals(this.mDir.getPath()) || this.loadFileList())) {
            return null;
        }
        return this.mFileList;
    }

    public void upCurrentDirectory() {
        if (this.mDir == null) {
            return;
        }
        if (this.pathDirsList.size() == 0) {
            this.mDir = new File("/");
        } else {
            String s = this.pathDirsList.remove(this.pathDirsList.size() - 1);
            String dir = this.mDir.toString().substring(0, this.mDir.toString().lastIndexOf(s));
            this.mDir = StringUtil.isEmptyOrNull(dir) ? new File("/") : new File(dir);
        }
        this.loadFileList();
    }

    public void getDirFileList(String dirPath, List<File> fileList) throws Exception {
        ZMLocalFileListSession.getDirectoryFileList(dirPath, this.mFileNameFilter, fileList);
    }

    public int getDirFilesCount(String dirPath) throws Exception {
        ArrayList<File> fileList = new ArrayList<File>();
        ZMLocalFileListSession.getDirectoryFileList(dirPath, this.mFileNameFilter, fileList);
        return fileList.size();
    }

    public static void getDirectoryFileList(String dirPath, FilenameFilter filter, List<File> fileList) {
        if (StringUtil.isEmptyOrNull(dirPath)) {
            return;
        }
        File dir = new File(dirPath);
        if (!(dir.exists() && dir.canRead() && dir.isDirectory())) {
            return;
        }
        File[] files = filter == null ? dir.listFiles() : dir.listFiles(filter);
        if (fileList != null) {
            for (File file : files) {
                if (!file.canRead() || file.isHidden() || !file.exists() || !file.isFile() && !file.isDirectory()) continue;
                fileList.add(file);
            }
        }
    }
}

