/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.R;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMFileListBaseAdapter;
import us.zoom.androidlib.app.ZMFileListEntry;
import us.zoom.androidlib.app.ZMFileListListener;
import us.zoom.androidlib.app.ZMLocalFileListSession;
import us.zoom.androidlib.app.ZMStorageUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMAsyncTask;

public class ZMLocalFileListAdapter
extends ZMFileListBaseAdapter
implements ZMStorageUtil.ZMStorageListener {
    private ZMFileListListener mListener;
    private ZMLocalFileListSession mLocalFileSession;
    private String mCurrentDir = null;
    private List<ZMStorageUtil.ZMStorageItem> mStorages = new ArrayList<ZMStorageUtil.ZMStorageItem>();
    private int mSDCardCount = 0;
    private int mUsbCount = 0;
    private Handler mHandler = new Handler();
    private ZMAsyncTask<String, Void, ArrayList<ZMFileListEntry>> mTaskOpenDir;
    private Runnable mShowWaitingStartRunnable = new Runnable(){

        @Override
        public void run() {
            if (ZMLocalFileListAdapter.this.mListener != null) {
                ZMLocalFileListAdapter.this.mListener.onWaitingStart(null);
            }
        }
    };
    private FilenameFilter mFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String fileName) {
            File file = new File(dir, fileName);
            if (!file.exists() || !file.canRead() || file.isHidden()) {
                return false;
            }
            return file.isDirectory() || ZMLocalFileListAdapter.this.acceptFileType(fileName);
        }
    };

    @Override
    public void init(ZMActivity activity, ZMFileListListener l) {
        super.init(activity, l);
        this.mListener = l;
        this.mLocalFileSession = new ZMLocalFileListSession();
        this.mLocalFileSession.setFileNameFilter(this.mFileFilter);
    }

    private void asyncLoadStorages() {
        ZMStorageUtil.asyncGetAllStorages(this, 8000L);
        if (this.mListener != null) {
            this.mListener.onStarting();
            this.mHandler.postDelayed(this.mShowWaitingStartRunnable, 50L);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.checkStoragePermission()) {
            this.asyncLoadStorages();
        } else {
            this.requestStoragePermission();
        }
    }

    @Override
    public boolean openDir(String dir) {
        if (this.mStorages.size() <= 0) {
            Context mContext = this.getContext();
            if (mContext != null) {
                this.setLastErrorMessage(mContext.getString(R.string.zm_alert_no_sdcard));
            }
            return false;
        }
        if (this.mTaskOpenDir != null && this.mTaskOpenDir.getStatus() == ZMAsyncTask.Status.RUNNING) {
            this.mTaskOpenDir.cancel(true);
            this.mTaskOpenDir = null;
        }
        this.mTaskOpenDir = new ZMAsyncTask<String, Void, ArrayList<ZMFileListEntry>>(){

            protected ArrayList<ZMFileListEntry> doInBackground(String ... params) {
                if (this.isCancelled()) {
                    return null;
                }
                String dir = params[0];
                if (StringUtil.isEmptyOrNull(dir)) {
                    return null;
                }
                ArrayList<ZMFileListEntry> fileEntryList = new ArrayList<ZMFileListEntry>();
                boolean succ = ZMLocalFileListAdapter.this.getFileListInfo(dir, fileEntryList);
                if (this.isCancelled()) {
                    return null;
                }
                if (succ) {
                    ZMLocalFileListAdapter.this.mLocalFileSession.setDir(dir);
                    return fileEntryList;
                }
                return null;
            }

            @Override
            protected void onPostExecute(ArrayList<ZMFileListEntry> result) {
                if (!this.isCancelled() && result != null) {
                    ZMLocalFileListAdapter.this.mFileList.clear();
                    ZMLocalFileListAdapter.this.mFileList.addAll(result);
                    ZMLocalFileListAdapter.this.mCurrentDir = ZMLocalFileListAdapter.this.mLocalFileSession.getCurrentDirPath();
                    ZMLocalFileListAdapter.this.sortFileList();
                    ZMLocalFileListAdapter.this.notifyDataSetChanged();
                    if (ZMLocalFileListAdapter.this.mListener != null) {
                        ZMLocalFileListAdapter.this.mListener.onRefresh();
                    }
                }
            }
        };
        this.mTaskOpenDir.execute((String[])new String[]{dir});
        this.setLastErrorMessage(null);
        return true;
    }

    @Override
    public void onDestroy() {
        if (this.mTaskOpenDir != null && this.mTaskOpenDir.getStatus() == ZMAsyncTask.Status.RUNNING) {
            this.mTaskOpenDir.cancel(true);
            this.mTaskOpenDir = null;
        }
        ZMStorageUtil.removeListener(this);
    }

    @Override
    public boolean isRootDir() {
        return StringUtil.isEmptyOrNull(this.mCurrentDir);
    }

    private boolean checkStoragePermission() {
        ZMActivity activity = this.getActivity();
        if (activity == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        int perm = activity.zm_checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE");
        return perm == 0;
    }

    private void requestStoragePermission() {
        ZMActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        activity.zm_requestPermissions(new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 0);
    }

    @Override
    public void onStoragePermissionResult(int permission2) {
        if (permission2 == 0) {
            this.asyncLoadStorages();
        } else {
            ZMActivity activity = this.getActivity();
            if (activity != null) {
                activity.finish();
            }
        }
    }

    private boolean isInternalStorageRoot() {
        if (StringUtil.isEmptyOrNull(this.mCurrentDir)) {
            return false;
        }
        for (ZMStorageUtil.ZMStorageItem item : this.mStorages) {
            if (!item.mounted || item.type != 1 || !this.mCurrentDir.equals(item.path)) continue;
            return true;
        }
        return false;
    }

    private boolean isSDCardStorageRoot() {
        if (StringUtil.isEmptyOrNull(this.mCurrentDir)) {
            return false;
        }
        for (ZMStorageUtil.ZMStorageItem item : this.mStorages) {
            if (!item.mounted || item.type != 2 || !this.mCurrentDir.equals(item.path)) continue;
            return true;
        }
        return false;
    }

    private boolean isUSBStorageRoot() {
        if (StringUtil.isEmptyOrNull(this.mCurrentDir)) {
            return false;
        }
        for (ZMStorageUtil.ZMStorageItem item : this.mStorages) {
            if (!item.mounted || item.type != 3 || !this.mCurrentDir.equals(item.path)) continue;
            return true;
        }
        return false;
    }

    private boolean isStorageRootDir() {
        if (StringUtil.isEmptyOrNull(this.mCurrentDir)) {
            return true;
        }
        if (this.isSDCardStorageRoot()) {
            return true;
        }
        if (this.isUSBStorageRoot()) {
            return true;
        }
        return this.isInternalStorageRoot();
    }

    @Override
    public String getCurrentDirName() {
        if (this.mCurrentDir == null) {
            return "";
        }
        if (this.isInternalStorageRoot()) {
            return this.mActivity.getString(R.string.zm_lbl_internal_storage);
        }
        if (this.isSDCardStorageRoot()) {
            int index = this.getStorageIndex(this.mStorages, this.mCurrentDir, 2);
            return this.getSDCardName(index);
        }
        if (this.isUSBStorageRoot()) {
            int index = this.getStorageIndex(this.mStorages, this.mCurrentDir, 3);
            return this.getUsbStorageName(index);
        }
        File dir = this.mLocalFileSession.getCurrentDir();
        if (dir == null) {
            return "";
        }
        return dir.getName();
    }

    private String getSDCardName(int index) {
        if (this.mSDCardCount <= 0) {
            return "";
        }
        if (this.mSDCardCount <= 1) {
            return this.mActivity.getResources().getString(R.string.zm_lbl_sdcard, new Object[]{""});
        }
        return this.mActivity.getResources().getString(R.string.zm_lbl_sdcard, new Object[]{String.valueOf(index)});
    }

    private String getUsbStorageName(int index) {
        if (this.mUsbCount <= 0) {
            return "";
        }
        if (this.mUsbCount == 1) {
            return this.mActivity.getResources().getString(R.string.zm_lbl_usb_storage, new Object[]{""});
        }
        return this.mActivity.getResources().getString(R.string.zm_lbl_usb_storage, new Object[]{String.valueOf(index)});
    }

    @Override
    public String getCurrentDirPath() {
        if (this.mCurrentDir == null) {
            return "";
        }
        return this.mCurrentDir;
    }

    @Override
    protected void gotoParentDir() {
        if (this.isStorageRootDir()) {
            this.mCurrentDir = null;
            this.notifyDataSetChanged();
            return;
        }
        this.mLocalFileSession.upCurrentDirectory();
        String dir = this.mLocalFileSession.getCurrentDirPath();
        this.openDir(dir);
    }

    @Override
    protected void openDir(ZMFileListEntry dirEntry) {
        if (dirEntry == null) {
            return;
        }
        String dir = dirEntry.getPath();
        if (StringUtil.isEmptyOrNull(dir) || !dirEntry.isDir()) {
            return;
        }
        this.openDir(dir);
    }

    @Override
    protected void openFile(ZMFileListEntry file) {
        if (file == null) {
            return;
        }
        String filePath = file.getPath();
        if (StringUtil.isEmptyOrNull(filePath) || file.isDir()) {
            return;
        }
        if (this.mListener != null) {
            this.mListener.onSelectedFile(filePath, file.getDisplayName());
        }
    }

    private boolean getFileListInfo(String dir, ArrayList<ZMFileListEntry> fileEntryList) {
        ArrayList<File> fileList = new ArrayList<File>();
        ZMLocalFileListSession.getDirectoryFileList(dir, this.mLocalFileSession.getFileNameFilter(), fileList);
        for (File file : fileList) {
            if (!file.exists() || !file.canRead() || !file.isFile() && !file.isDirectory()) continue;
            int count = 0;
            if (file.isDirectory()) {
                try {
                    count = this.mLocalFileSession.getDirFilesCount(file.getPath());
                }
                catch (Exception e) {
                    continue;
                }
            }
            ZMFileListEntry entry = new ZMFileListEntry();
            entry.setBytes(file.length());
            entry.setDate(file.lastModified());
            if (file.isDirectory()) {
                entry.setDir(true);
                entry.setChildEntryCount(count);
            } else {
                entry.setDir(false);
            }
            entry.setDisplayName(file.getName());
            entry.setPath(file.getPath());
            fileEntryList.add(entry);
        }
        return true;
    }

    private View createView(ViewGroup parent) {
        Holder holder = new Holder();
        View view = this.mInflater.inflate(R.layout.zm_storage_list_item, parent, false);
        holder.mDisplayName = (TextView)view.findViewById(R.id.txtStorageName);
        holder.mIcon = (ImageView)view.findViewById(R.id.storageIcon);
        view.setTag((Object)holder);
        return view;
    }

    private int getStorageIndex(List<ZMStorageUtil.ZMStorageItem> storages, int position, int type) {
        if (storages == null || position >= storages.size()) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i <= position; ++i) {
            ZMStorageUtil.ZMStorageItem item = storages.get(i);
            if (item.type != type) continue;
            ++count;
        }
        return count;
    }

    private int getStorageCount(List<ZMStorageUtil.ZMStorageItem> storages, int type) {
        if (storages == null || storages.size() == 0) {
            return 0;
        }
        int count = 0;
        for (ZMStorageUtil.ZMStorageItem item : storages) {
            if (item.type != type) continue;
            ++count;
        }
        return count;
    }

    private int getStorageIndex(List<ZMStorageUtil.ZMStorageItem> storages, String path, int type) {
        if (storages == null || storages.size() == 0 || StringUtil.isEmptyOrNull(path)) {
            return 0;
        }
        int count = 0;
        for (ZMStorageUtil.ZMStorageItem item : storages) {
            if (item.type != type) continue;
            ++count;
            if (!path.equals(item.path)) continue;
            return count;
        }
        return 0;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (!this.isRootDir()) {
            return super.getView(position, convertView, parent);
        }
        if (position >= this.mStorages.size()) {
            return null;
        }
        ZMStorageUtil.ZMStorageItem item = this.mStorages.get(position);
        View view = convertView;
        if (view == null || !(view.getTag() instanceof Holder)) {
            view = this.createView(parent);
        }
        Holder holder = (Holder)view.getTag();
        switch (item.type) {
            case 1: {
                holder.mDisplayName.setText(R.string.zm_lbl_internal_storage);
                holder.mIcon.setImageResource(R.drawable.zm_ic_storage_internal);
                break;
            }
            case 2: {
                int index = this.getStorageIndex(this.mStorages, position, 2);
                holder.mDisplayName.setText((CharSequence)this.getSDCardName(index));
                holder.mIcon.setImageResource(R.drawable.zm_ic_storage_sdcard);
                break;
            }
            case 3: {
                int index = this.getStorageIndex(this.mStorages, position, 3);
                holder.mDisplayName.setText((CharSequence)this.getUsbStorageName(index));
                holder.mIcon.setImageResource(R.drawable.zm_ic_storage_external);
            }
        }
        return view;
    }

    @Override
    public int getCount() {
        if (!this.isRootDir()) {
            return super.getCount();
        }
        if (this.mStorages == null) {
            return 0;
        }
        return this.mStorages.size();
    }

    @Override
    public ZMFileListEntry getItem(int position) {
        if (!this.isRootDir()) {
            return super.getItem(position);
        }
        if (this.mStorages == null || position >= this.mStorages.size()) {
            return null;
        }
        ZMStorageUtil.ZMStorageItem item = this.mStorages.get(position);
        ZMFileListEntry entry = new ZMFileListEntry();
        entry.setPath(item.path);
        entry.setDir(true);
        return entry;
    }

    @Override
    public void onRecieveStorageInfo(List<ZMStorageUtil.ZMStorageItem> storages) {
        ZMStorageUtil.removeListener(this);
        this.mStorages.clear();
        if (storages != null && storages.size() > 0) {
            for (ZMStorageUtil.ZMStorageItem item : storages) {
                if (!item.mounted) continue;
                this.mStorages.add(item);
            }
        }
        this.mSDCardCount = this.getStorageCount(this.mStorages, 2);
        this.mUsbCount = this.getStorageCount(this.mStorages, 3);
        if (this.mListener != null) {
            this.mHandler.removeCallbacks(this.mShowWaitingStartRunnable);
            this.mListener.onWaitingEnd();
            if (this.mStorages.size() > 0) {
                this.setLastErrorMessage(null);
                this.mListener.onStarted(true, null);
            } else {
                Context mContext = this.getContext();
                if (mContext != null) {
                    this.setLastErrorMessage(mContext.getString(R.string.zm_alert_no_sdcard));
                    this.mListener.onStarted(false, mContext.getString(R.string.zm_alert_no_sdcard));
                } else {
                    this.mListener.onStarted(false, null);
                }
            }
        }
        this.notifyDataSetChanged();
    }

    private class Holder {
        TextView mDisplayName;
        ImageView mIcon;

        private Holder() {
        }
    }
}

