/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import us.zoom.androidlib.R;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFileListBaseAdapter;
import us.zoom.androidlib.app.ZMFileListListener;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMDynTextSizeTextView;

public class ZMFileListActivity
extends ZMActivity
implements AdapterView.OnItemClickListener,
View.OnClickListener,
ZMFileListListener {
    public static final String SELECTED_FILE_PATH = "selected_file_path";
    public static final String SELECTED_FILE_NAME = "selected_file_name";
    public static final String FAILED_PROMT = "failed_promt";
    private static final String ADAPTER_CLASS_NAME = "adapter_class_name";
    private static final String FILTER_FILE_EXTENSIONS = "filter_file_extensions";
    private static final String DIR_START_PATH = "dir_start_path";
    private static final String SELECTED_BUTTON_TEXT_RES_ID = "selected_button_text_res_id";
    private static final String STARTED_STATUS_FLAG = "started_status_flag";
    private static final String FILE_LIST_PROMPT_MESSAGE = "file_list_prompt_message";
    private final int STATUS_IDLE = 0;
    private final int STATUS_STARTING = 1;
    private final int STATUS_STARTED = 2;
    private final int STATUS_OPENED = 3;
    private final int STATUS_ERROR = 4;
    private int mStatus = 0;
    private ListView mFileList;
    private ZMFileListBaseAdapter mAdapter;
    private Button mBtnExit;
    private Button mBtnBack;
    private Button mBtnSelect;
    private Button mBtnClose;
    private View mPrompt;
    private TextView mPromptMsgView;
    private ZMDynTextSizeTextView mTitle;
    private View mWaitingProgress;
    private TextView mWaitingPromt;
    private String mAdatpterClassName = null;
    private String mDirPath = null;
    private String[] mFilterExtensions = null;
    private int mSelTextResId = 0;
    private String mPromptMessage = null;

    public static void startFileListActivity(Activity activity, Class<? extends ZMFileListBaseAdapter> adapterClass, int requestCode) {
        ZMFileListActivity.startFileListActivity(activity, adapterClass, requestCode, null, null, 0, null);
    }

    public static void startFileListActivity(Activity activity, Class<? extends ZMFileListBaseAdapter> adapterClass, int requestCode, String[] filterExtensions) {
        ZMFileListActivity.startFileListActivity(activity, adapterClass, requestCode, filterExtensions, null, 0, null);
    }

    public static void startFileListActivity(Activity activity, Class<? extends ZMFileListBaseAdapter> adapterClass, int requestCode, String startDir) {
        ZMFileListActivity.startFileListActivity(activity, adapterClass, requestCode, null, startDir, 0, null);
    }

    public static void startFileListActivity(Activity activity, Class<? extends ZMFileListBaseAdapter> adapterClass, int requestCode, String[] filterExtensions, String startDir, int selectedButtonTextResId, String promtMsg) {
        if (activity == null || adapterClass == null) {
            return;
        }
        Intent intent = ZMFileListActivity.buildIntent(adapterClass, requestCode, filterExtensions, startDir, selectedButtonTextResId, promtMsg);
        intent.setClass((Context)activity, ZMFileListActivity.class);
        activity.startActivityForResult(intent, requestCode);
    }

    public static void startFileListActivity(Fragment fragment, Class<? extends ZMFileListBaseAdapter> adapterClass, int requestCode) {
        ZMFileListActivity.startFileListActivity(fragment, adapterClass, requestCode, null, null, 0, null);
    }

    public static void startFileListActivity(Fragment fragment, Class<? extends ZMFileListBaseAdapter> adapterClass, int requestCode, String[] filterExtensions) {
        ZMFileListActivity.startFileListActivity(fragment, adapterClass, requestCode, filterExtensions, null, 0, null);
    }

    public static void startFileListActivity(Fragment fragment, Class<? extends ZMFileListBaseAdapter> adapterClass, int requestCode, String startDir) {
        ZMFileListActivity.startFileListActivity(fragment, adapterClass, requestCode, null, startDir, 0, null);
    }

    public static void startFileListActivity(Fragment fragment, Class<? extends ZMFileListBaseAdapter> adapterClass, int requestCode, String[] filterExtensions, String startDir, int selectedButtonTextResId, String promtMsg) {
        if (fragment == null || adapterClass == null) {
            return;
        }
        Intent intent = ZMFileListActivity.buildIntent(adapterClass, requestCode, filterExtensions, startDir, selectedButtonTextResId, promtMsg);
        intent.setClass((Context)fragment.getActivity(), ZMFileListActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static Intent buildIntent(Class<? extends ZMFileListBaseAdapter> adapterClass, int requestCode, String[] filterExtensions, String startDir, int selectedButtonTextResId, String promtMsg) {
        Intent intent = new Intent();
        intent.putExtra(ADAPTER_CLASS_NAME, adapterClass.getName());
        if (filterExtensions != null && filterExtensions.length > 0) {
            intent.putExtra(FILTER_FILE_EXTENSIONS, filterExtensions);
        }
        if (!StringUtil.isEmptyOrNull(startDir)) {
            intent.putExtra(DIR_START_PATH, startDir);
        }
        if (selectedButtonTextResId > 0) {
            intent.putExtra(SELECTED_BUTTON_TEXT_RES_ID, selectedButtonTextResId);
        }
        if (!StringUtil.isEmptyOrNull(promtMsg)) {
            intent.putExtra(FILE_LIST_PROMPT_MESSAGE, promtMsg);
        }
        return intent;
    }

    private void initial(Bundle savedInstanceState) {
        this.mAdatpterClassName = null;
        if (savedInstanceState != null) {
            this.mAdatpterClassName = savedInstanceState.getString(ADAPTER_CLASS_NAME);
            this.mFilterExtensions = savedInstanceState.getStringArray(FILTER_FILE_EXTENSIONS);
            this.mDirPath = savedInstanceState.getString(DIR_START_PATH);
            this.mSelTextResId = savedInstanceState.getInt(SELECTED_BUTTON_TEXT_RES_ID);
            this.mPromptMessage = savedInstanceState.getString(FILE_LIST_PROMPT_MESSAGE);
            this.mStatus = savedInstanceState.getInt(STARTED_STATUS_FLAG);
            return;
        }
        Intent intent = this.getIntent();
        if (intent != null) {
            this.mAdatpterClassName = intent.getStringExtra(ADAPTER_CLASS_NAME);
            this.mFilterExtensions = intent.getStringArrayExtra(FILTER_FILE_EXTENSIONS);
            this.mDirPath = intent.getStringExtra(DIR_START_PATH);
            this.mSelTextResId = intent.getIntExtra(SELECTED_BUTTON_TEXT_RES_ID, 0);
            this.mPromptMessage = intent.getStringExtra(FILE_LIST_PROMPT_MESSAGE);
            this.mStatus = 0;
        }
    }

    private ZMFileListBaseAdapter getAdapter(String className) {
        if (StringUtil.isEmptyOrNull(className)) {
            return null;
        }
        Class<?> adapterClass = null;
        ZMFileListBaseAdapter adapter = null;
        try {
            adapterClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        try {
            adapter = (ZMFileListBaseAdapter)((Object)adapterClass.newInstance());
        }
        catch (Exception e) {
            return null;
        }
        return adapter;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.zm_file_list);
        this.mPrompt = this.findViewById(R.id.file_list_prompt);
        this.mPromptMsgView = (TextView)this.findViewById(R.id.prompt_message);
        this.mBtnExit = (Button)this.findViewById(R.id.btnExit);
        this.mBtnBack = (Button)this.findViewById(R.id.btnBack);
        this.mBtnClose = (Button)this.findViewById(R.id.btnClose);
        this.mBtnSelect = (Button)this.findViewById(R.id.btnSelect);
        this.mWaitingProgress = this.findViewById(R.id.waitingProgress);
        this.mWaitingPromt = (TextView)this.findViewById(R.id.txtWaitingPromt);
        this.mTitle = (ZMDynTextSizeTextView)this.findViewById(R.id.txtTitle);
        this.mFileList = (ListView)this.findViewById(R.id.file_list);
        this.mBtnExit.setOnClickListener((View.OnClickListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnClose.setOnClickListener((View.OnClickListener)this);
        this.mBtnSelect.setOnClickListener((View.OnClickListener)this);
        this.initial(savedInstanceState);
        if (this.mSelTextResId > 0) {
            this.mBtnSelect.setText(this.mSelTextResId);
        }
        this.mAdapter = this.getAdapter(this.mAdatpterClassName);
        if (this.mAdapter == null) {
            this.mStatus = 4;
            return;
        }
        this.mAdapter.init(this, this);
        if (this.mFilterExtensions != null && this.mFilterExtensions.length > 0) {
            this.mAdapter.setFilterExtens(this.mFilterExtensions);
        }
        this.mFileList.setChoiceMode(1);
        this.mFileList.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mFileList.setAdapter((ListAdapter)this.mAdapter);
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mAdatpterClassName != null) {
            outState.putString(ADAPTER_CLASS_NAME, this.mAdatpterClassName);
        }
        if (this.mAdapter != null && !this.mAdapter.isRootDir()) {
            this.mDirPath = this.mAdapter.getCurrentDirPath();
            outState.putString(DIR_START_PATH, this.mAdapter.getCurrentDirPath());
        }
        if (this.mFilterExtensions != null && this.mFilterExtensions.length > 0) {
            outState.putStringArray(FILTER_FILE_EXTENSIONS, this.mFilterExtensions);
        }
        if (this.mSelTextResId > 0) {
            outState.putInt(SELECTED_BUTTON_TEXT_RES_ID, this.mSelTextResId);
        }
        if (StringUtil.isEmptyOrNull(this.mPromptMessage)) {
            outState.putString(FILE_LIST_PROMPT_MESSAGE, this.mPromptMessage);
        }
        outState.putInt(STARTED_STATUS_FLAG, this.mStatus);
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.initial(savedInstanceState);
    }

    @Override
    public void onDestroy() {
        if (this.mAdapter != null) {
            this.mAdapter.onDestroy();
        }
        super.onDestroy();
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.mAdapter != null) {
            this.mAdapter.onPause();
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (this.mAdapter != null) {
            this.mAdapter.onStart();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mAdapter == null) {
            this.exit();
            return;
        }
        if (this.mAdapter.isNeedAuth() && this.mStatus == 0) {
            this.mAdapter.login();
        } else {
            this.mAdapter.onResume();
        }
        this.refresh();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (this.mAdapter != null) {
            this.mAdapter.onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void onRequestPermissionsResult(final int requestCode, final @NonNull String[] permissions, final @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.getEventTaskManager().pushLater("fileListPermissionResult", new EventAction("fileListPermissionResult"){

            @Override
            public void run(IUIElement ui) {
                ((ZMFileListActivity)ui).handleRequestPermissionResult(requestCode, permissions, grantResults);
            }
        });
    }

    protected void handleRequestPermissionResult(int requestCode, String[] permissions, int[] grantResults) {
        if (permissions == null || grantResults == null) {
            return;
        }
        for (int i = 0; i < permissions.length; ++i) {
            if (!"android.permission.READ_EXTERNAL_STORAGE".equals(permissions[i]) || this.mAdapter == null) continue;
            this.mAdapter.onStoragePermissionResult(grantResults[i]);
        }
    }

    private void open() {
        if (this.mStatus == 2) {
            boolean opened = this.mAdapter.openDir(this.mDirPath);
            this.mStatus = opened ? 3 : 4;
        }
    }

    public void refresh() {
        switch (this.mStatus) {
            case 0: 
            case 1: {
                this.mBtnExit.setVisibility(8);
                this.mBtnBack.setVisibility(8);
                this.mBtnSelect.setVisibility(8);
                this.mBtnClose.setVisibility(0);
                this.mPrompt.setVisibility(8);
                break;
            }
            case 2: 
            case 3: {
                if (this.mAdapter.isRootDir() && !StringUtil.isEmptyOrNull(this.mPromptMessage)) {
                    this.mPromptMsgView.setText((CharSequence)this.mPromptMessage);
                    this.mPrompt.setVisibility(0);
                } else {
                    this.mPrompt.setVisibility(8);
                }
                this.mTitle.setText(this.mAdapter.getCurrentDirName());
                if (this.mAdapter.isRootDir()) {
                    if (this.mAdapter.isNeedAuth()) {
                        this.mBtnExit.setVisibility(0);
                    } else {
                        this.mBtnExit.setVisibility(8);
                    }
                    this.mBtnBack.setVisibility(8);
                } else {
                    this.mBtnExit.setVisibility(8);
                    this.mBtnBack.setVisibility(0);
                }
                if (this.mAdapter.isFileSelected()) {
                    this.mBtnSelect.setVisibility(0);
                    this.mBtnClose.setVisibility(8);
                    break;
                }
                this.mBtnSelect.setVisibility(8);
                this.mBtnClose.setVisibility(0);
                break;
            }
            case 4: {
                this.mBtnExit.setVisibility(8);
                this.mBtnBack.setVisibility(8);
                this.mBtnSelect.setVisibility(8);
                this.mBtnClose.setVisibility(0);
                if (this.mAdapter != null && !this.mAdapter.isNeedAuth()) {
                    String errorMsg = this.mAdapter.getLastErrorMessage();
                    if (!StringUtil.isEmptyOrNull(errorMsg)) {
                        this.mPromptMsgView.setText((CharSequence)errorMsg);
                        this.mPrompt.setVisibility(0);
                        break;
                    }
                    this.mPrompt.setVisibility(8);
                    break;
                }
                this.mPrompt.setVisibility(8);
            }
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mAdapter != null) {
            this.mAdapter.onClickItem(position);
        }
        this.refresh();
    }

    @Override
    public void onBackPressed() {
        if (this.mAdapter != null && this.mAdapter.onBackPressed()) {
            this.exit();
            return;
        }
        this.refresh();
    }

    private void onClickExit() {
        if (this.mAdapter != null && this.mAdapter.isNeedAuth()) {
            this.mAdapter.logout();
        }
        this.exit();
    }

    private void onClickBack() {
        if (this.mStatus != 3 || this.mAdapter == null || this.mAdapter.isRootDir()) {
            return;
        }
        this.mAdapter.upDir();
        this.refresh();
    }

    private void onClickSelect() {
        if (this.mAdapter != null && this.mAdapter.isFileSelected()) {
            this.mAdapter.openSelectedFile();
        }
    }

    private void onClickClose() {
        this.exit();
    }

    public void onClick(View v) {
        if (v == this.mBtnExit) {
            this.onClickExit();
        } else if (v == this.mBtnBack) {
            this.onClickBack();
        } else if (v == this.mBtnSelect) {
            this.onClickSelect();
        } else if (v == this.mBtnClose) {
            this.onClickClose();
        }
    }

    @Override
    public void onRefresh() {
        this.refresh();
    }

    @Override
    public void onSelectedFile(String path, String fileName) {
        this.exitOK(path, fileName);
    }

    @Override
    public void onReLogin() {
        if (this.mAdapter != null && !this.mAdapter.isNeedAuth()) {
            return;
        }
        this.mAdapter.logout();
        this.mStatus = 0;
        this.mAdapter.login();
    }

    private void exit() {
        this.setResult(0);
        this.finish();
    }

    private void exitOK(String cachePath, String fileName) {
        Intent intent = new Intent();
        if (!StringUtil.isEmptyOrNull(cachePath)) {
            intent.putExtra(SELECTED_FILE_PATH, cachePath);
        }
        if (!StringUtil.isEmptyOrNull(fileName)) {
            intent.putExtra(SELECTED_FILE_NAME, fileName);
        }
        this.setResult(-1, intent);
        this.finish();
    }

    private void exitByFailed(String promt) {
        Intent intent = new Intent();
        if (!StringUtil.isEmptyOrNull(promt)) {
            intent.putExtra(FAILED_PROMT, promt);
        }
        this.setResult(0, intent);
        this.finish();
    }

    @Override
    public void onStarting() {
        this.mStatus = 1;
    }

    @Override
    public void onStarted(boolean success, String failedMsg) {
        if (!success) {
            this.exitByFailed(failedMsg);
            return;
        }
        this.mStatus = 2;
        this.open();
        this.refresh();
    }

    @Override
    public void onWaitingStart(String message) {
        this.mWaitingProgress.setVisibility(0);
        if (StringUtil.isEmptyOrNull(message)) {
            this.mWaitingPromt.setText((CharSequence)this.getString(R.string.zm_msg_loading));
        } else {
            this.mWaitingPromt.setText((CharSequence)message);
        }
    }

    @Override
    public void onUpdateWaitingMessage(String message) {
        if (StringUtil.isEmptyOrNull(message) || this.mWaitingProgress.getVisibility() != 0) {
            return;
        }
        this.mWaitingPromt.setText((CharSequence)message);
    }

    @Override
    public void onWaitingEnd() {
        this.mWaitingProgress.setVisibility(8);
    }

    @Override
    public void onOpenDirFailed(String message) {
        ShowAlertDialog.showDialog(this.getSupportFragmentManager(), message);
    }

    @Override
    public void onOpenFileFailed(String message) {
        ShowAlertDialog.showDialog(this.getSupportFragmentManager(), message);
    }

    public static class ShowAlertDialog
    extends ZMDialogFragment {
        private static final String ARG_MESSAGE = "arg_message";

        public static void showDialog(FragmentManager fragmentMgr, String message) {
            ShowAlertDialog dlg = new ShowAlertDialog();
            Bundle args = new Bundle();
            if (!StringUtil.isEmptyOrNull(message)) {
                args.putString(ARG_MESSAGE, message);
            }
            dlg.setArguments(args);
            dlg.show(fragmentMgr, ShowAlertDialog.class.getName());
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            Bundle args = this.getArguments();
            String message = args.getString(ARG_MESSAGE);
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            });
            builder.setMessage(message);
            return builder.create();
        }
    }
}

