/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.annotation.SuppressLint;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.Fragment;
import us.zoom.androidlib.app.ZMActivity;

class ZMActivityCompat {
    ZMActivityCompat() {
    }

    public static void requestPermissionsFromFragment(Fragment fragment, String[] permissions, int requestCode) {
        if (fragment == null || permissions == null || permissions.length <= 0) {
            return;
        }
        ZMActivity activity = (ZMActivity)fragment.getActivity();
        if (activity == null) {
            return;
        }
        if ((requestCode & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Can only use lower 16 bits for requestCode");
        }
        int index = activity.getFragmentIndex(fragment);
        ZMActivityCompat.requestPermissionsCompat(activity, permissions, (index + 1 << 16) + (requestCode & 0xFFFF));
    }

    @SuppressLint(value={"NewApi"})
    public static void requestPermissionsCompat(final ZMActivity activity, final String[] permissions, final int requestCode) {
        if (activity == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            activity.requestPermissions(permissions, requestCode);
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    int[] grantResults = new int[permissions.length];
                    PackageManager packageManager = activity.getPackageManager();
                    String packageName = activity.getPackageName();
                    int permissionCount = permissions.length;
                    for (int i = 0; i < permissionCount; ++i) {
                        grantResults[i] = packageManager.checkPermission(permissions[i], packageName);
                    }
                    activity.onRequestPermissionsResult(requestCode, permissions, grantResults);
                }
            });
        }
    }
}

