/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.androidlib.app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.DisplayMetrics;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.accessibility.AccessibilityEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.R;
import us.zoom.androidlib.app.ForegroundTaskManager;
import us.zoom.androidlib.app.ZMActivityCompat;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.EventTaskManager;
import us.zoom.androidlib.util.IListener;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.LanguageUtil;
import us.zoom.androidlib.util.ListenerList;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;

public class ZMActivity
extends FragmentActivity
implements IUIElement {
    private final String mTag = this.getClass().getSimpleName();
    private boolean mActive = false;
    private boolean mDestroyed = false;
    private boolean mDisableGestureFinish = false;
    private EventTaskManager mTaskMgr = null;
    private RetainedFragment mRetainedFragment = null;
    private static ZMActivity sFrontActivity = null;
    private static boolean sHasActivityCreated = false;
    private static ListenerList sGlobalActivityListenerList = new ListenerList();
    private Handler mHandler = new Handler();
    private final GestureDetector.SimpleOnGestureListener mGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return ZMActivity.this.onFling(e1, e2, velocityX, velocityY);
        }
    };
    private GestureDetector mGestureDetector;
    private List<View> mDisableGestureFinishView = new ArrayList<View>();
    private static ArrayList<ZMActivity> sActivityStack = new ArrayList();

    public static void addGlobalActivityListener(GlobalActivityListener l) {
        if (l == null) {
            return;
        }
        IListener[] listeners = sGlobalActivityListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i].getClass() != l.getClass()) continue;
            ZMActivity.removeGlobalActivityListener((GlobalActivityListener)listeners[i]);
        }
        sGlobalActivityListenerList.add(l);
    }

    public static void removeGlobalActivityListener(GlobalActivityListener l) {
        sGlobalActivityListenerList.remove(l);
    }

    public final boolean isActive() {
        return this.mActive && !this.isFinishing() && !ZMActivity.isActivityDestroyed((Activity)this);
    }

    @Nullable
    public final EventTaskManager getEventTaskManager() {
        RetainedFragment f = this.getRetainedFragment();
        if (f != null) {
            return f.mTaskMgr;
        }
        return null;
    }

    @NonNull
    public final EventTaskManager getNonNullEventTaskManagerOrThrowException() {
        RetainedFragment f = this.getRetainedFragment();
        if (f != null) {
            return f.mTaskMgr;
        }
        throw new NullPointerException("Exception in getNonNullEventTaskManagerOrThrowException. class=" + this.getClass().getName());
    }

    public static ZMActivity getFrontActivity() {
        return sFrontActivity;
    }

    public static boolean hasActivityCreated() {
        return sHasActivityCreated;
    }

    private static void setHasActivityCreated(boolean b) {
        sHasActivityCreated = b;
    }

    public static int getInProcessActivityCountInStack() {
        return sActivityStack.size();
    }

    public static ZMActivity getInProcessActivityInStackAt(int index) {
        if (index < 0 || index >= sActivityStack.size()) {
            return null;
        }
        return sActivityStack.get(index);
    }

    public static boolean isActivityDestroyed(Activity activity) {
        if (activity == null) {
            return false;
        }
        Class<?> clazz = activity.getClass();
        Method methodIsDestroyed = null;
        try {
            methodIsDestroyed = clazz.getMethod("isDestroyed", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        if (methodIsDestroyed != null) {
            Boolean oIsDestroyed = null;
            try {
                oIsDestroyed = (Boolean)methodIsDestroyed.invoke((Object)activity, new Object[0]);
            }
            catch (Exception e) {
                return false;
            }
            if (oIsDestroyed != null) {
                return oIsDestroyed;
            }
        }
        return false;
    }

    public void addDisableGestureFinishView(View view) {
        if (view == null) {
            return;
        }
        if (!this.mDisableGestureFinishView.contains(view)) {
            this.mDisableGestureFinishView.add(view);
        }
    }

    public void removeDisableGestureFinishView(View view) {
        if (view == null) {
            return;
        }
        this.mDisableGestureFinishView.remove(view);
    }

    public boolean isInMultiWindowMode() {
        if (OsUtil.isAtLeastN()) {
            return super.isInMultiWindowMode();
        }
        return false;
    }

    public void disableFinishActivityByGesture(boolean isDisable) {
        this.mDisableGestureFinish = isDisable;
    }

    private boolean isMotionEventInDisableGestureFinishView(MotionEvent ev) {
        if (this.mDisableGestureFinishView.size() == 0 || ev == null) {
            return false;
        }
        float x = ev.getRawX();
        float y = ev.getRawY();
        Rect rect = new Rect();
        for (View v : this.mDisableGestureFinishView) {
            if (!v.isShown()) continue;
            v.getGlobalVisibleRect(rect);
            if (!rect.contains((int)x, (int)y)) continue;
            return true;
        }
        return false;
    }

    private boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (!this.mDisableGestureFinish && e1 != null && e2 != null) {
            float dx = Math.abs(e1.getRawX() - e2.getRawX());
            float dy = Math.abs(e1.getRawY() - e2.getRawY());
            if (velocityX > 3000.0f && dx > 0.0f && Math.abs(dy) < (float)UIUtil.dip2px((Context)this, 50.0f)) {
                this.onBackPressed();
                return true;
            }
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public boolean isDestroyed() {
        if (Build.VERSION.SDK_INT >= 17) {
            return super.isDestroyed();
        }
        return this.mDestroyed;
    }

    public void finishActivityFromFragment(Fragment fragment, int requestCode) {
        if (fragment == null) {
            return;
        }
        if (requestCode == -1) {
            this.finishActivity(-1);
            return;
        }
        if ((requestCode & 0xFFFF0000) != 0) {
            throw new IllegalArgumentException("Can only use lower 16 bits for requestCode");
        }
        int index = this.getFragmentIndex(fragment);
        if (index < 0) {
            return;
        }
        this.finishActivity((index + 1 << 16) + (requestCode & 0xFFFF));
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        int index = requestCode >> 16 & 0xFFFF;
        if (index != 0) {
            this.onRequestPermissionsResultForFragment(requestCode, permissions, grantResults);
        }
    }

    private void onRequestPermissionsResultForFragment(int requestCode, String[] permissions, int[] grantResults) {
        int index = requestCode >> 16 & 0xFFFF;
        if (index != 0) {
            --index;
            FragmentManager fm = this.getSupportFragmentManager();
            if (fm == null) {
                return;
            }
            List activeFragments = fm.getFragments();
            if (activeFragments == null) {
                return;
            }
            int activeFragmentsCount = activeFragments.size();
            if (activeFragmentsCount == 0 || index < 0 || index >= activeFragmentsCount) {
                return;
            }
            Fragment frag = (Fragment)activeFragments.get(index);
            if (frag != null) {
                if (frag instanceof ZMFragment) {
                    ZMFragment zmFragment = (ZMFragment)frag;
                    zmFragment.onRequestPermissionsResult(requestCode & 0xFFFF, permissions, grantResults);
                } else if (frag instanceof ZMDialogFragment) {
                    ZMDialogFragment dialogFragment = (ZMDialogFragment)frag;
                    dialogFragment.onRequestPermissionsResult(requestCode & 0xFFFF, permissions, grantResults);
                }
            }
        }
    }

    public void zm_requestPermissions(String[] permissions, int requestCode) {
        ZMActivityCompat.requestPermissionsCompat(this, permissions, requestCode);
    }

    public int zm_checkSelfPermission(String permission) {
        if (StringUtil.isEmptyOrNull(permission)) {
            return -1;
        }
        try {
            return this.checkPermission(permission, Process.myPid(), Process.myUid());
        }
        catch (Throwable e) {
            return -1;
        }
    }

    protected int getFragmentIndex(Fragment f) {
        if (f == null) {
            return -1;
        }
        try {
            Field field = Fragment.class.getDeclaredField("mIndex");
            if (field == null) {
                return -1;
            }
            field.setAccessible(true);
            int index = field.getInt(f);
            return index;
        }
        catch (NoSuchFieldException e) {
            return -1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }

    @SuppressLint(value={"NewApi"})
    protected void onCreate(Bundle savedInstanceState) {
        ZMActivity.setHasActivityCreated(true);
        this.mDestroyed = false;
        super.onCreate(savedInstanceState);
        LanguageUtil.updateLocaleForContextWrapper((ContextWrapper)this);
        this.initRetainedFragment();
        this.mTaskMgr = this.getRetainedFragment().mTaskMgr;
        sActivityStack.add(this);
        if (Build.VERSION.SDK_INT >= 21) {
            View decorView;
            Window window = this.getWindow();
            if (Build.VERSION.SDK_INT >= 23 && (decorView = window.getDecorView()) != null) {
                int vis = decorView.getSystemUiVisibility();
                decorView.setSystemUiVisibility(vis &= 0xFFFFDFFF);
            }
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(this.getResources().getColor(R.color.zm_title_bar_dark_bg));
        }
        this.mGestureDetector = new GestureDetector((Context)this, (GestureDetector.OnGestureListener)this.mGestureListener);
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(LanguageUtil.getUpdateLocaleForContext(newBase));
    }

    public void onConfigurationChanged(Configuration newConfig) {
        Locale locale = LanguageUtil.getAppLocale((Context)this);
        if (locale != null && !StringUtil.isEmptyOrNull(locale.getLanguage())) {
            Resources resources = this.getResources();
            DisplayMetrics dm = resources.getDisplayMetrics();
            Configuration config = resources.getConfiguration();
            config.locale = locale;
            resources.updateConfiguration(config, dm);
        }
        super.onConfigurationChanged(newConfig);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent ev) {
        this.notifiyUserActivityOnUI();
        return super.dispatchGenericMotionEvent(ev);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        this.notifiyUserActivityOnUI();
        return super.dispatchKeyEvent(event);
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent event) {
        this.notifiyUserActivityOnUI();
        return super.dispatchKeyShortcutEvent(event);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.notifiyUserActivityOnUI();
        return super.dispatchPopulateAccessibilityEvent(event);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (!this.isMotionEventInDisableGestureFinishView(ev) && !this.mDisableGestureFinish && this.mGestureDetector.onTouchEvent(ev)) {
            return true;
        }
        this.notifiyUserActivityOnUI();
        return super.dispatchTouchEvent(ev);
    }

    public boolean dispatchTrackballEvent(MotionEvent ev) {
        this.notifiyUserActivityOnUI();
        return super.dispatchTrackballEvent(ev);
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            if (this.isFinishing()) {
                return;
            }
            this.mRetainedFragment = new RetainedFragment();
            this.getSupportFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, this.getClass().getName() + ":" + RetainedFragment.class.getName()).commit();
        }
    }

    private RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        FragmentManager fm = this.getSupportFragmentManager();
        RetainedFragment retainedFragment = (RetainedFragment)fm.findFragmentByTag(this.getClass().getName() + ":" + RetainedFragment.class.getName());
        return retainedFragment;
    }

    protected void onDestroy() {
        this.mActive = false;
        if (sFrontActivity == this) {
            sFrontActivity = null;
        }
        this.mTaskMgr.onUIDestroy(this);
        if (this.isFinishing()) {
            this.mTaskMgr.destroy();
        }
        super.onDestroy();
        sActivityStack.remove(this);
        this.mDestroyed = true;
    }

    protected void onPause() {
        if (!this.isInMultiWindowMode()) {
            this.mActive = false;
            this.mTaskMgr.onPause(this);
        }
        super.onPause();
        if (!this.isInMultiWindowMode()) {
            this.performMoveToBackground();
        }
    }

    private void performMoveToBackground() {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                ZMActivity activity = ZMActivity.getFrontActivity();
                if (activity == null || !activity.isActive()) {
                    ZMActivity.this.notifyMoveToBackground();
                }
            }
        }, 500L);
    }

    protected void onResume() {
        super.onResume();
        this.mActive = true;
        sFrontActivity = this;
        if (!this.isInMultiWindowMode()) {
            this.performMoveToFront();
        }
    }

    private void performMoveToFront() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (ZMActivity.this.isActive()) {
                    ZMActivity.this.notifyMoveToFront();
                }
            }
        });
    }

    private void notifyMoveToFront() {
        this.mTaskMgr.onResume(this);
        ForegroundTaskManager foregroundTaskMgr = ForegroundTaskManager.getInstance();
        foregroundTaskMgr.onActivityMoveToFront(this);
        IListener[] listeners = sGlobalActivityListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            ((GlobalActivityListener)listeners[i]).onActivityMoveToFront(this);
        }
    }

    private void notifyMoveToBackground() {
        IListener[] listeners = sGlobalActivityListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            ((GlobalActivityListener)listeners[i]).onUIMoveToBackground();
        }
    }

    private void notifiyUserActivityOnUI() {
        IListener[] listeners = sGlobalActivityListenerList.getAll();
        for (int i = 0; i < listeners.length; ++i) {
            ((GlobalActivityListener)listeners[i]).onUserActivityOnUI();
        }
    }

    protected void onStart() {
        this.mActive = true;
        super.onStart();
        this.mTaskMgr.onStart(this);
        if (this.isInMultiWindowMode()) {
            sFrontActivity = this;
            this.performMoveToFront();
        }
    }

    protected void onStop() {
        this.mActive = false;
        this.mTaskMgr.onStop(this);
        if (this.isInMultiWindowMode()) {
            this.performMoveToBackground();
        }
        super.onStop();
    }

    protected void onSaveInstanceState(Bundle outState) {
        this.mActive = false;
        if (outState != null) {
            outState.putString("WORKAROUND_FOR_BUG_19917_KEY", "WORKAROUND_FOR_BUG_19917_VALUE");
        }
        super.onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
    }

    public void onBackPressed() {
        FragmentManager fm = this.getSupportFragmentManager();
        if (fm != null && fm.getBackStackEntryCount() == 0) {
            this.finish();
            return;
        }
        try {
            super.onBackPressed();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in ZMActivity.onBackPressed(). class=" + this.getClass().getName(), e);
        }
    }

    public static class RetainedFragment
    extends Fragment {
        EventTaskManager mTaskMgr = new EventTaskManager();

        public RetainedFragment() {
            this.setRetainInstance(true);
        }
    }

    public static interface GlobalActivityListener
    extends IListener {
        public void onActivityMoveToFront(ZMActivity var1);

        public void onUIMoveToBackground();

        public void onUserActivityOnUI();
    }
}

