/*
 * Decompiled with CFR 0.152.
 */
package us.zoom.template;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import us.zoom.template.IStatement;
import us.zoom.template.IfStatement;
import us.zoom.template.SimpleStringStatement;
import us.zoom.template.VariableStatement;

public class Template {
    private static final String TAG = Template.class.getSimpleName();
    private ArrayList<IStatement> mStatements = new ArrayList();
    private int mStackSize = 0;

    public Template(String strTemplate) {
        if (strTemplate != null) {
            strTemplate = this.preParse(strTemplate);
            this.parse(strTemplate);
        }
    }

    private String preParse(String strTemplate) {
        BufferedReader reader = new BufferedReader(new StringReader(strTemplate));
        StringWriter writer = new StringWriter();
        try {
            String line = null;
            boolean ignoreLastNewLine = true;
            do {
                if ((line = reader.readLine()) == null) continue;
                if (!ignoreLastNewLine) {
                    writer.append('\n');
                }
                writer.append(line);
                ignoreLastNewLine = line.matches("<[#|/][^<>]*>");
            } while (line != null);
            if (strTemplate.endsWith("\n")) {
                writer.append('\n');
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return writer.toString();
    }

    private void parse(String strTemplate) {
        StringReader reader = new StringReader(strTemplate);
        StringWriter writer = new StringWriter();
        try {
            int ch = 0;
            do {
                if ((ch = reader.read()) == -1) {
                    SimpleStringStatement strStmt = new SimpleStringStatement(writer.toString());
                    this.mStatements.add(strStmt);
                    break;
                }
                if (ch == 36) {
                    int ch2 = reader.read();
                    if (ch2 == -1) {
                        writer.write(ch);
                        SimpleStringStatement strStmt = new SimpleStringStatement(writer.toString());
                        this.mStatements.add(strStmt);
                        break;
                    }
                    if (ch2 == 123) {
                        SimpleStringStatement strStmt = new SimpleStringStatement(writer.toString());
                        this.mStatements.add(strStmt);
                        writer = new StringWriter();
                        VariableStatement stmt = this.parseVariableStatement(reader);
                        this.mStatements.add(stmt);
                        continue;
                    }
                    writer.write(ch);
                    continue;
                }
                if (ch == 60) {
                    char[] buff = new char[4];
                    int len = reader.read(buff);
                    String str = new String(buff, 0, len);
                    if (str.equals("#if ")) {
                        SimpleStringStatement strStmt = new SimpleStringStatement(writer.toString());
                        this.mStatements.add(strStmt);
                        writer = new StringWriter();
                        IfStatement ifstmt = this.parseIfStatement(reader);
                        this.mStatements.add(ifstmt);
                        continue;
                    }
                    writer.write(ch);
                    writer.write(str);
                    continue;
                }
                writer.write(ch);
            } while (ch != -1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private IfStatement parseIfStatement(StringReader reader) {
        try {
            int ch = 0;
            StringWriter writer = new StringWriter();
            IfStatement stmt = null;
            do {
                if ((ch = reader.read()) == -1) {
                    throw new RuntimeException("\"??>\" or \">\" expected but not found after \"" + writer.toString() + "\"");
                }
                if (ch == 62) {
                    String conditionVariable = writer.toString().trim();
                    this.mStackSize = 1;
                    String[] strSubTemplates = this.readToEndIf(reader);
                    stmt = new IfStatement(conditionVariable, new Template(strSubTemplates[0]), new Template(strSubTemplates[1]));
                    break;
                }
                if (ch == 63) {
                    char[] buff = new char[2];
                    int len = reader.read(buff);
                    String str = new String(buff, 0, len);
                    if (str.equals("?>")) {
                        String conditionVariable = writer.toString().trim();
                        this.mStackSize = 1;
                        String[] strSubTemplates = this.readToEndIf(reader);
                        stmt = new IfStatement(conditionVariable, new Template(strSubTemplates[0]), new Template(strSubTemplates[1]));
                        break;
                    }
                    writer.write(ch);
                    writer.write(str);
                    continue;
                }
                writer.write(ch);
            } while (ch != -1);
            return stmt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String[] readToEndIf(StringReader reader) {
        try {
            int ch = 0;
            StringWriter writer = new StringWriter();
            String[] res = new String[2];
            int idx = 0;
            do {
                if ((ch = reader.read()) == -1) {
                    throw new RuntimeException("\"<#if>\" expected but not found after \"" + writer.toString() + "\"");
                }
                if (ch == 60) {
                    char[] buff = new char[5];
                    int len = reader.read(buff);
                    String str = new String(buff, 0, len);
                    if (str.startsWith("#if ")) {
                        writer.write(ch);
                        writer.write(str);
                        ++this.mStackSize;
                        continue;
                    }
                    if (str.equals("/#if>")) {
                        if (this.mStackSize > 1) {
                            writer.write(ch);
                            writer.write(str);
                            --this.mStackSize;
                            continue;
                        }
                        res[idx++] = writer.toString();
                        return res;
                    }
                    if (str.equals("#else")) {
                        ch = reader.read();
                        if (ch != 62 || this.mStackSize > 1) {
                            writer.write(ch);
                            writer.write(str);
                            continue;
                        }
                        res[idx++] = writer.toString();
                        writer = new StringWriter();
                        continue;
                    }
                    writer.write(ch);
                    writer.write(str);
                    continue;
                }
                writer.write(ch);
            } while (ch != -1);
            throw new RuntimeException("\"</#if>\" expected but not found after \"" + writer.toString() + "\"");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private VariableStatement parseVariableStatement(StringReader reader) {
        try {
            int ch = 0;
            StringWriter writer = new StringWriter();
            VariableStatement stmt = null;
            do {
                if ((ch = reader.read()) == -1) {
                    throw new RuntimeException("\"}\" expected but not found after \"" + writer.toString() + "\"");
                }
                if (ch == 125) {
                    stmt = new VariableStatement(writer.toString().trim());
                    break;
                }
                writer.write(ch);
            } while (ch != -1);
            return stmt;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String format(Map<String, String> config) {
        StringBuffer buff = new StringBuffer();
        for (IStatement stmt : this.mStatements) {
            buff.append(stmt.format(config));
        }
        return buff.toString();
    }
}

